/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dx.cf.code.BasicBlocker;
import com.android.dx.cf.code.ByteBlock;
import com.android.dx.cf.code.ByteBlockList;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.direct.CodeObserver;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.Method;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BaseDumper;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.cst.CstType;
import com.android.dx.ssa.Optimizer;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import java.io.PrintStream;

public class BlockDumper
extends BaseDumper {
    private final boolean rop;
    protected DirectClassFile classFile;
    protected boolean suppressDump;
    private boolean first;
    private final boolean optimize;

    public static void dump(byte[] bytes, PrintStream out, String filePath, boolean rop, Args args) {
        BlockDumper bd2 = new BlockDumper(bytes, out, filePath, rop, args);
        bd2.dump();
    }

    BlockDumper(byte[] bytes, PrintStream out, String filePath, boolean rop, Args args) {
        super(bytes, out, filePath, args);
        this.rop = rop;
        this.classFile = null;
        this.suppressDump = true;
        this.first = true;
        this.optimize = args.optimize;
    }

    public void dump() {
        byte[] bytes = this.getBytes();
        ByteArray ba2 = new ByteArray(bytes);
        this.classFile = new DirectClassFile(ba2, this.getFilePath(), this.getStrictParse());
        this.classFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        this.classFile.getMagic();
        DirectClassFile liveCf = new DirectClassFile(ba2, this.getFilePath(), this.getStrictParse());
        liveCf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        liveCf.setObserver(this);
        liveCf.getMagic();
    }

    @Override
    public void changeIndent(int indentDelta) {
        if (!this.suppressDump) {
            super.changeIndent(indentDelta);
        }
    }

    @Override
    public void parsed(ByteArray bytes, int offset, int len, String human) {
        if (!this.suppressDump) {
            super.parsed(bytes, offset, len, human);
        }
    }

    protected boolean shouldDumpMethod(String name) {
        return this.args.method == null || this.args.method.equals(name);
    }

    @Override
    public void startParsingMember(ByteArray bytes, int offset, String name, String descriptor) {
        if (descriptor.indexOf(40) < 0) {
            return;
        }
        if (!this.shouldDumpMethod(name)) {
            return;
        }
        this.suppressDump = false;
        if (this.first) {
            this.first = false;
        } else {
            this.parsed(bytes, offset, 0, "\n");
        }
        this.parsed(bytes, offset, 0, "method " + name + " " + descriptor);
        this.suppressDump = true;
    }

    @Override
    public void endParsingMember(ByteArray bytes, int offset, String name, String descriptor, Member member) {
        if (!(member instanceof Method)) {
            return;
        }
        if (!this.shouldDumpMethod(name)) {
            return;
        }
        if ((member.getAccessFlags() & 0x500) != 0) {
            return;
        }
        ConcreteMethod meth = new ConcreteMethod((Method)member, this.classFile, true, true);
        if (this.rop) {
            this.ropDump(meth);
        } else {
            this.regularDump(meth);
        }
    }

    private void regularDump(ConcreteMethod meth) {
        BytecodeArray code = meth.getCode();
        ByteArray bytes = code.getBytes();
        ByteBlockList list = BasicBlocker.identifyBlocks(meth);
        int sz = list.size();
        CodeObserver codeObserver = new CodeObserver(bytes, this);
        this.suppressDump = false;
        int byteAt = 0;
        for (int i2 = 0; i2 < sz; ++i2) {
            int len;
            ByteBlock bb2 = list.get(i2);
            int start = bb2.getStart();
            int end = bb2.getEnd();
            if (byteAt < start) {
                this.parsed(bytes, byteAt, start - byteAt, "dead code " + Hex.u2(byteAt) + ".." + Hex.u2(start));
            }
            this.parsed(bytes, start, 0, "block " + Hex.u2(bb2.getLabel()) + ": " + Hex.u2(start) + ".." + Hex.u2(end));
            this.changeIndent(1);
            for (int j2 = start; j2 < end; j2 += len) {
                len = code.parseInstruction(j2, codeObserver);
                codeObserver.setPreviousOffset(j2);
            }
            IntList successors = bb2.getSuccessors();
            int ssz = successors.size();
            if (ssz == 0) {
                this.parsed(bytes, end, 0, "returns");
            } else {
                for (int j3 = 0; j3 < ssz; ++j3) {
                    int succ = successors.get(j3);
                    this.parsed(bytes, end, 0, "next " + Hex.u2(succ));
                }
            }
            ByteCatchList catches = bb2.getCatches();
            int csz = catches.size();
            for (int j4 = 0; j4 < csz; ++j4) {
                ByteCatchList.Item one = catches.get(j4);
                CstType exceptionClass = one.getExceptionClass();
                this.parsed(bytes, end, 0, "catch " + (exceptionClass == CstType.OBJECT ? "<any>" : exceptionClass.toHuman()) + " -> " + Hex.u2(one.getHandlerPc()));
            }
            this.changeIndent(-1);
            byteAt = end;
        }
        int end = bytes.size();
        if (byteAt < end) {
            this.parsed(bytes, byteAt, end - byteAt, "dead code " + Hex.u2(byteAt) + ".." + Hex.u2(end));
        }
        this.suppressDump = true;
    }

    private void ropDump(ConcreteMethod meth) {
        DexTranslationAdvice advice = DexTranslationAdvice.THE_ONE;
        BytecodeArray code = meth.getCode();
        ByteArray bytes = code.getBytes();
        RopMethod rmeth = Ropper.convert(meth, advice, this.classFile.getMethods(), this.dexOptions);
        StringBuilder sb2 = new StringBuilder(2000);
        if (this.optimize) {
            boolean isStatic = AccessFlags.isStatic(meth.getAccessFlags());
            int paramWidth = BlockDumper.computeParamWidth(meth, isStatic);
            rmeth = Optimizer.optimize(rmeth, paramWidth, isStatic, true, advice);
        }
        BasicBlockList blocks = rmeth.getBlocks();
        int[] order = blocks.getLabelsInOrder();
        sb2.append("first " + Hex.u2(rmeth.getFirstLabel()) + "\n");
        for (int label : order) {
            BasicBlock bb2 = blocks.get(blocks.indexOfLabel(label));
            sb2.append("block ");
            sb2.append(Hex.u2(label));
            sb2.append("\n");
            IntList preds = rmeth.labelToPredecessors(label);
            int psz = preds.size();
            for (int i2 = 0; i2 < psz; ++i2) {
                sb2.append("  pred ");
                sb2.append(Hex.u2(preds.get(i2)));
                sb2.append("\n");
            }
            InsnList il = bb2.getInsns();
            int ilsz = il.size();
            for (int i3 = 0; i3 < ilsz; ++i3) {
                Insn one = il.get(i3);
                sb2.append("  ");
                sb2.append(il.get(i3).toHuman());
                sb2.append("\n");
            }
            IntList successors = bb2.getSuccessors();
            int ssz = successors.size();
            if (ssz == 0) {
                sb2.append("  returns\n");
                continue;
            }
            int primary = bb2.getPrimarySuccessor();
            for (int i4 = 0; i4 < ssz; ++i4) {
                int succ = successors.get(i4);
                sb2.append("  next ");
                sb2.append(Hex.u2(succ));
                if (ssz != 1 && succ == primary) {
                    sb2.append(" *");
                }
                sb2.append("\n");
            }
        }
        this.suppressDump = false;
        this.parsed(bytes, 0, bytes.size(), sb2.toString());
        this.suppressDump = true;
    }
}

