/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.c;
import com.android.tools.r8.o;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.t;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.z;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class u
extends c {
    static final String a = String.join((CharSequence)"\n", Arrays.asList("Usage: r8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --release                # Compile without debugging information (default).", "  --debug                  # Compile with debugging information.", "  --output <file>          # Output result in <file>.", "                           # <file> must be an existing directory or a zip file.", "  --lib <file>             # Add <file> as a library resource.", "  --min-api                # Minimum Android API level compatibility.", "  --pg-conf <file>         # Proguard configuration <file>.", "  --pg-map-output <file>   # Output the resulting name and line mapping to <file>.", "  --no-tree-shaking        # Force disable tree shaking of unreachable classes.", "  --no-minification        # Force disable minification of names.", "  --no-data-resources      # Ignore all data resources.", "  --no-desugaring          # Force disable desugaring.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version of r8.", "  --help                   # Print this message."));

    public static R8Command.Builder a(String[] stringArray, Origin origin) {
        u u2;
        u u3 = u2;
        u3();
        return u2.a(stringArray, origin, R8Command.builder());
    }

    public static R8Command.Builder a(String[] stringArray, Origin origin, DiagnosticsHandler diagnosticsHandler) {
        u u2;
        u u3 = u2;
        u3();
        return u2.a(stringArray, origin, R8Command.builder(diagnosticsHandler));
    }

    private R8Command.Builder a(String[] object, Origin object2, R8Command.Builder builder) {
        t t2;
        t t3 = t2;
        t2 = new t(null);
        object = z.a(object, builder);
        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
            String string = object[i2].trim();
            if (string.length() == 0) continue;
            if (string.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (string.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (string.equals("--debug")) {
                if (t3.a == CompilationMode.RELEASE) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", (Origin)object2));
                }
                t3.a = CompilationMode.DEBUG;
                continue;
            }
            if (string.equals("--release")) {
                if (t3.a == CompilationMode.DEBUG) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", (Origin)object2));
                }
                t3.a = CompilationMode.RELEASE;
                continue;
            }
            if (string.equals("--dex")) {
                if (t3.b == OutputMode.ClassFile) {
                    builder.error(new StringDiagnostic("Cannot compile in both --dex and --classfile output mode.", (Origin)object2));
                }
                t3.b = OutputMode.DexIndexed;
                continue;
            }
            if (string.equals("--classfile")) {
                if (t3.b == OutputMode.DexIndexed) {
                    builder.error(new StringDiagnostic("Cannot compile in both --dex and --classfile output mode.", (Origin)object2));
                }
                t3.b = OutputMode.ClassFile;
                continue;
            }
            if (string.equals("--output")) {
                string = object[++i2];
                if (t3.c != null) {
                    builder.error(new StringDiagnostic(o.a("Cannot output both to '").append(t3.c.toString()).append("' and '").append(string).append("'").toString(), (Origin)object2));
                }
                t3.c = Paths.get(string, new String[0]);
                continue;
            }
            if (string.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(object[++i2], new String[0]));
                continue;
            }
            if (string.equals("--min-api")) {
                string = object[++i2];
                if (t3.d) {
                    builder.error(new StringDiagnostic("Cannot set multiple --min-api options", (Origin)object2));
                    continue;
                }
                c.a(builder, string, object2);
                t3.d = true;
                continue;
            }
            if (string.equals("--no-tree-shaking")) {
                builder.setDisableTreeShaking(true);
                continue;
            }
            if (string.equals("--no-minification")) {
                builder.setDisableMinification(true);
                continue;
            }
            if (string.equals("--no-desugaring")) {
                builder.setDisableDesugaring(true);
                continue;
            }
            if (string.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(object[++i2], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(object[++i2], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(object[++i2], new String[0]));
                continue;
            }
            if (string.equals("--optimize-multidex-for-linearalloc")) {
                builder.setOptimizeMultidexForLinearAlloc(true);
                continue;
            }
            if (string.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(object[++i2], new String[0]));
                continue;
            }
            if (string.equals("--pg-map-output")) {
                builder.setProguardMapOutputPath(Paths.get(object[++i2], new String[0]));
                continue;
            }
            if (string.equals("--no-data-resources")) {
                t.a(t3, false);
                continue;
            }
            if (string.startsWith("--")) {
                builder.error(new StringDiagnostic(o.a("Unknown option: ", string), (Origin)object2));
            }
            builder.addProgramFiles(Paths.get(string, new String[0]));
        }
        object = t3.a;
        if (object != null) {
            builder.setMode((CompilationMode)((Object)object));
        }
        if ((object = t3.c) == null) {
            object = Paths.get(".", new String[0]);
        }
        object2 = t3.b;
        if (object2 == null) {
            object2 = OutputMode.DexIndexed;
        }
        R8Command.Builder builder2 = builder;
        builder2.setOutput((Path)object, (OutputMode)((Object)object2), t.a(t3));
        return builder2;
    }
}

