/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class FileCacheByPath {
    private final File directory;

    public FileCacheByPath(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)(directory.getAbsolutePath() + "!.isDirectory()"));
        this.directory = directory;
    }

    public void add(File f2) throws IOException {
        Preconditions.checkArgument((boolean)f2.isFile(), (Object)"!f.isFile()");
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        String k2 = FileCacheByPath.key(f2);
        Files.copy((File)f2, (File)new File(this.directory, k2));
    }

    public File get(File f2) {
        File file = new File(this.directory, FileCacheByPath.key(f2));
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public void remove(File f2) throws IOException {
        File toRemove = new File(this.directory, FileCacheByPath.key(f2));
        if (toRemove.exists()) {
            FileUtils.delete((File)toRemove);
        }
    }

    private static String key(File f2) {
        String absolutePath = f2.getAbsolutePath();
        byte[] sha1Sum = Hashing.sha1().hashString((CharSequence)absolutePath, Charsets.UTF_8).asBytes();
        return new String(Base64.encodeBase64((byte[])sha1Sum), Charsets.US_ASCII).replaceAll("/", "_");
    }

    public void clear() throws IOException {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return;
        }
        for (File f2 : files) {
            if (!f2.isFile()) continue;
            FileUtils.delete((File)f2);
        }
    }
}

