/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public final class NameAnonymizer {
    static final long NO_VARIANT_SPECIFIED = 0L;
    final LoadingCache<String, Project> mProjects = CacheBuilder.newBuilder().build((CacheLoader)new ProjectCacheLoader());

    public long anonymizeProjectPath(String projectPath) {
        Preconditions.checkArgument((boolean)projectPath.startsWith(":"), (Object)"Project path should be absolute");
        try {
            return ((Project)this.mProjects.get((Object)projectPath)).mId;
        }
        catch (ExecutionException e2) {
            return 0L;
        }
    }

    public long anonymizeVariant(String projectName, String variantName) {
        if (variantName == null) {
            return 0L;
        }
        try {
            return (Long)((Project)this.mProjects.get((Object)projectName)).mVariantIds.get((Object)variantName);
        }
        catch (ExecutionException e2) {
            return 0L;
        }
    }

    Map<Long, Pair<String, Map<Long, String>>> createDeanonymizer() {
        return this.mProjects.asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((Project)entry.getValue()).mId, entry -> Pair.of(entry.getKey(), (Object)HashBiMap.create((Map)((Project)entry.getValue()).mVariantIds.asMap()).inverse())));
    }

    private static class VariantIdCacheLoader
    extends CacheLoader<String, Long> {
        private final AtomicLong nextVariantId = new AtomicLong(0L);

        private VariantIdCacheLoader() {
        }

        public Long load(String key) throws Exception {
            return this.nextVariantId.incrementAndGet();
        }
    }

    private static class Project {
        final long mId;
        final LoadingCache<String, Long> mVariantIds = CacheBuilder.newBuilder().build((CacheLoader)new VariantIdCacheLoader());

        Project(long id2) {
            this.mId = id2;
        }
    }

    private static class ProjectCacheLoader
    extends CacheLoader<String, Project> {
        private final AtomicLong nextProjectId = new AtomicLong(0L);

        private ProjectCacheLoader() {
        }

        public Project load(String key) throws Exception {
            return new Project(this.nextProjectId.incrementAndGet());
        }
    }
}

