/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Iterator;

public class ClassInitializationAnalysis {
    private static final ClassInitializationAnalysis TRIVIAL = new ClassInitializationAnalysis(){

        @Override
        public boolean isClassDefinitelyLoadedBeforeInstruction(DexType type, Instruction instruction) {
            return false;
        }
    };
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final IRCode code;
    private final DexItemFactory dexItemFactory;
    private DominatorTree dominatorTree = null;
    private int markingColor = -1;

    private ClassInitializationAnalysis() {
        this.appView = null;
        this.code = null;
        this.dexItemFactory = null;
    }

    public ClassInitializationAnalysis(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, IRCode code) {
        assert (appView != null);
        assert (code != null);
        this.appView = appView;
        this.code = code;
        this.dexItemFactory = appView.dexItemFactory();
    }

    public static ClassInitializationAnalysis trivial() {
        return TRIVIAL;
    }

    public boolean isClassDefinitelyLoadedBeforeInstruction(DexType type, Instruction instruction) {
        Instruction previous;
        BasicBlock block = instruction.getBlock();
        Iterator<Object> iterator2 = block.getInstructions().iterator();
        while (iterator2.hasNext() && (previous = (Instruction)iterator2.next()) != instruction) {
            if (!previous.definitelyTriggersClassInitialization(type, this.appView, Query.DIRECTLY_OR_INDIRECTLY, AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW)) continue;
            return true;
        }
        if (this.dominatorTree == null) {
            this.dominatorTree = new DominatorTree(this.code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        }
        block1: for (BasicBlock dominator : this.dominatorTree.dominatorBlocks(block, DominatorTree.Inclusive.NO)) {
            AnalysisAssumption assumption = this.getAssumptionForDominator(dominator, block);
            InstructionIterator instructionIterator = dominator.iterator();
            while (instructionIterator.hasNext()) {
                Instruction previous2 = (Instruction)instructionIterator.next();
                if (previous2.definitelyTriggersClassInitialization(type, this.appView, Query.DIRECTLY_OR_INDIRECTLY, assumption)) {
                    return true;
                }
                if (!dominator.hasCatchHandlers() || !previous2.instructionTypeCanThrow()) continue;
                assert (Streams.stream(instructionIterator).noneMatch(Instruction::instructionTypeCanThrow));
                continue block1;
            }
        }
        return false;
    }

    private AnalysisAssumption getAssumptionForDominator(BasicBlock dominator, BasicBlock block) {
        if (!dominator.hasCatchHandlers()) {
            return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
        }
        Instruction exceptionalExit = dominator.exceptionalExit();
        if (exceptionalExit == null) {
            return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
        }
        if (this.markingColor < 0) {
            this.markingColor = this.code.reserveMarkingColor();
            this.code.markTransitivePredecessors(block, this.markingColor);
        }
        for (CatchHandlers.CatchHandler<BasicBlock> catchHandler : dominator.getCatchHandlers()) {
            if (!((BasicBlock)catchHandler.target).isMarked(this.markingColor)) continue;
            DexType guard = catchHandler.guard;
            if (guard == DexItemFactory.catchAllType) {
                return AnalysisAssumption.NONE;
            }
            if ((exceptionalExit.isInstanceGet() || exceptionalExit.isInstancePut() || exceptionalExit.isInvokeMethodWithReceiver()) && !this.dexItemFactory.npeType.isSubtypeOf(guard, this.appView.appInfo()) || (exceptionalExit.isStaticGet() || exceptionalExit.isStaticPut() || exceptionalExit.isInvokeStatic()) && !this.dexItemFactory.exceptionInInitializerErrorType.isSubtypeOf(guard, this.appView.appInfo())) continue;
            return AnalysisAssumption.NONE;
        }
        return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
    }

    public void notifyCodeHasChanged() {
        this.dominatorTree = null;
        this.returnMarkingColor();
    }

    public void finish() {
        this.returnMarkingColor();
    }

    private void returnMarkingColor() {
        if (this.markingColor >= 0) {
            this.code.returnMarkingColor(this.markingColor);
            this.markingColor = -1;
        }
    }

    public static class InstructionUtils {
        public static boolean forInstanceGet(InstanceGet instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forInstanceGetOrPut(instruction, type, appView, mode, assumption);
        }

        public static boolean forInstancePut(InstancePut instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forInstanceGetOrPut(instruction, type, appView, mode, assumption);
        }

        private static boolean forInstanceGetOrPut(FieldInstruction instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            assert (instruction.isInstanceGet() || instruction.isInstancePut());
            if (assumption == AnalysisAssumption.NONE) {
                Value object;
                Value value = object = instruction.isInstanceGet() ? instruction.asInstanceGet().object() : instruction.asInstancePut().object();
                if (object.getTypeLattice().isNullable()) {
                    return false;
                }
            }
            return InstructionUtils.isTypeInitializedBy(type, instruction.getField().clazz, appView, mode);
        }

        public static boolean forInvokeDirect(InvokeDirect instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            return InstructionUtils.isTypeInitializedBy(type, instruction.getInvokedMethod().holder, appView, mode);
        }

        public static boolean forInvokeStatic(InvokeStatic instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            return InstructionUtils.isTypeInitializedBy(type, instruction.getInvokedMethod().holder, appView, mode);
        }

        public static boolean forInvokeSuper(InvokeSuper instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            DexMethod method = instruction.getInvokedMethod();
            DexClass enclosingClass = appView.appInfo().definitionFor(method.holder);
            if (enclosingClass == null) {
                return false;
            }
            DexType superType = enclosingClass.superType;
            if (superType == null) {
                return false;
            }
            AppInfo.ResolutionResult resolutionResult = appView.appInfo().resolveMethod(superType, method);
            if (!resolutionResult.hasSingleTarget()) {
                return false;
            }
            DexType holder = resolutionResult.asSingleTarget().method.holder;
            return holder.isSubtypeOf(type, appView.appInfo());
        }

        public static boolean forInvokeVirtual(InvokeVirtual instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getTypeLattice().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            DexMethod method = instruction.getInvokedMethod();
            AppInfo.ResolutionResult resolutionResult = appView.appInfo().resolveMethod(method.holder, method);
            if (!resolutionResult.hasSingleTarget()) {
                return false;
            }
            DexType holder = resolutionResult.asSingleTarget().method.holder;
            return holder.isSubtypeOf(type, appView.appInfo());
        }

        public static boolean forNewInstance(NewInstance instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.isTypeInitializedBy(type, instruction.clazz, appView, mode);
        }

        public static boolean forStaticGet(StaticGet instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forStaticGetOrPut(instruction, type, appView, mode, assumption);
        }

        public static boolean forStaticPut(StaticPut instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forStaticGetOrPut(instruction, type, appView, mode, assumption);
        }

        private static boolean forStaticGetOrPut(FieldInstruction instruction, DexType type, AppView<? extends AppInfoWithSubtyping> appView, Query mode, AnalysisAssumption assumption) {
            assert (instruction.isStaticGet() || instruction.isStaticPut());
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            return InstructionUtils.isTypeInitializedBy(type, instruction.getField().clazz, appView, mode);
        }

        private static boolean isTypeInitializedBy(DexType typeToBeInitialized, DexType typeKnownToBeInitialized, AppView<? extends AppInfoWithSubtyping> appView, Query mode) {
            if (mode == Query.DIRECTLY) {
                return typeKnownToBeInitialized == typeToBeInitialized;
            }
            return typeKnownToBeInitialized.isSubtypeOf(typeToBeInitialized, appView.appInfo());
        }
    }

    public static enum Query {
        DIRECTLY,
        DIRECTLY_OR_INDIRECTLY;

    }

    public static enum AnalysisAssumption {
        INSTRUCTION_DOES_NOT_THROW,
        NONE;

    }
}

