/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.code.Format22c;
import com.android.tools.r8.code.Iput;
import com.android.tools.r8.code.IputBoolean;
import com.android.tools.r8.code.IputByte;
import com.android.tools.r8.code.IputChar;
import com.android.tools.r8.code.IputObject;
import com.android.tools.r8.code.IputShort;
import com.android.tools.r8.code.IputWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Arrays;

public class InstancePut
extends FieldInstruction {
    public InstancePut(DexField field, Value object, Value value) {
        super(field, null, Arrays.asList(object, value));
        assert (this.object().verifyCompatible(ValueType.OBJECT));
        assert (this.value().verifyCompatible(ValueType.fromDexType(field.type)));
    }

    public Value object() {
        return (Value)this.inValues.get(0);
    }

    public Value value() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int valueRegister = builder.allocatedRegister(this.value(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Iput(valueRegister, objectRegister, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new IputWide(valueRegister, objectRegister, field);
                break;
            }
            case OBJECT: {
                instruction = new IputObject(valueRegister, objectRegister, field);
                break;
            }
            case BOOLEAN: {
                instruction = new IputBoolean(valueRegister, objectRegister, field);
                break;
            }
            case BYTE: {
                instruction = new IputByte(valueRegister, objectRegister, field);
                break;
            }
            case CHAR: {
                instruction = new IputChar(valueRegister, objectRegister, field);
                break;
            }
            case SHORT: {
                instruction = new IputShort(valueRegister, objectRegister, field);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.getType()));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInstancePut()) {
            return false;
        }
        InstancePut o = other.asInstancePut();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "InstancePut instructions define no values.";
        return 0;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInstancePut(this.getField(), invocationContext);
    }

    @Override
    public boolean isInstancePut() {
        return true;
    }

    @Override
    public InstancePut asInstancePut() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(181, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.object() == value;
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, AppView<? extends AppInfoWithSubtyping> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInstancePut(this, clazz, appView, mode, assumption);
    }
}

