/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeStaticRange;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InvokeStatic
extends InvokeMethod {
    private final boolean itf;

    public InvokeStatic(DexMethod target, Value result, List<Value> arguments) {
        this(target, result, arguments, false);
        assert (target.asDexReference().asDexMethod().proto.parameters.size() == arguments.size());
    }

    public InvokeStatic(DexMethod target, Value result, List<Value> arguments, boolean itf) {
        super(target, result, arguments);
        this.itf = itf;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.STATIC;
    }

    @Override
    protected String getTypeString() {
        return "Static";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeStaticRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeStatic(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeStatic() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeStatic() {
        return true;
    }

    @Override
    public InvokeStatic asInvokeStatic() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(Enqueuer.AppInfoWithLiveness appInfo, DexType invocationContext) {
        DexMethod method = this.getInvokedMethod();
        return appInfo.lookupStaticTarget(method);
    }

    @Override
    public Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping appInfo, DexType invocationContext) {
        DexEncodedMethod target = appInfo.lookupStaticTarget(this.getInvokedMethod());
        return target == null ? Collections.emptyList() : Collections.singletonList(target);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeStatic(this.getInvokedMethod(), invocationContext);
    }

    @Override
    public Inliner.InlineAction computeInlining(InliningOracle decider, DexType invocationContext, ClassInitializationAnalysis classInitializationAnalysis) {
        return decider.computeForInvokeStatic(this, invocationContext, classInitializationAnalysis);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(184, this.getInvokedMethod(), this.itf));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, AppView<? extends AppInfoWithSubtyping> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeStatic(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<? extends AppInfo> appView, DexType context) {
        if (appView == null || !appView.enableWholeProgramOptimizations()) {
            return true;
        }
        if (appView.options().debug) {
            return true;
        }
        if (appView.appInfo().hasLiveness()) {
            boolean targetMayHaveSideEffects;
            Enqueuer.AppInfoWithLiveness appInfoWithLiveness = appView.appInfo().withLiveness();
            DexEncodedMethod target = this.lookupSingleTarget(appInfoWithLiveness, context);
            if (target == null) {
                return true;
            }
            if (!MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appInfoWithLiveness, context, target.method.holder, target.accessFlags)) {
                return true;
            }
            boolean bl = targetMayHaveSideEffects = target.getOptimizationInfo().mayHaveSideEffects() && !appInfoWithLiveness.noSideEffects.containsKey(target.method);
            if (targetMayHaveSideEffects) {
                return true;
            }
            return target.method.holder.classInitializationMayHaveSideEffects(appView.appInfo(), type -> context.isSubtypeOf((DexType)type, (AppInfo)appView.appInfo()));
        }
        return true;
    }

    @Override
    public boolean canBeDeadCode(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, AppInfo appInfo, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }
}

