/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.code.Format21c;
import com.android.tools.r8.code.Sput;
import com.android.tools.r8.code.SputBoolean;
import com.android.tools.r8.code.SputByte;
import com.android.tools.r8.code.SputChar;
import com.android.tools.r8.code.SputObject;
import com.android.tools.r8.code.SputShort;
import com.android.tools.r8.code.SputWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class StaticPut
extends FieldInstruction {
    public StaticPut(Value source, DexField field) {
        super(field, null, source);
    }

    public Value inValue() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format21c instruction;
        int src = builder.allocatedRegister(this.inValue(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Sput(src, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new SputWide(src, field);
                break;
            }
            case OBJECT: {
                instruction = new SputObject(src, field);
                break;
            }
            case BOOLEAN: {
                instruction = new SputBoolean(src, field);
                break;
            }
            case BYTE: {
                instruction = new SputByte(src, field);
                break;
            }
            case CHAR: {
                instruction = new SputChar(src, field);
                break;
            }
            case SHORT: {
                instruction = new SputShort(src, field);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.getType()));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "StaticPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isStaticPut()) {
            return false;
        }
        StaticPut o = other.asStaticPut();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forStaticPut(this.getField(), invocationContext);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public boolean isStaticPut() {
        return true;
    }

    @Override
    public StaticPut asStaticPut() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(179, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, AppView<? extends AppInfoWithSubtyping> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forStaticPut(this, clazz, appView, mode, assumption);
    }
}

