/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public abstract class MemberPoolCollection<T extends Descriptor> {
    final Equivalence<T> equivalence;
    final DexApplication application;
    final Map<DexClass, MemberPool<T>> memberPools = new ConcurrentHashMap<DexClass, MemberPool<T>>();

    MemberPoolCollection(DexApplication application, Equivalence<T> equivalence) {
        this.application = application;
        this.equivalence = equivalence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAll(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building member pool collection");
        try {
            ArrayList futures = new ArrayList();
            List<DexProgramClass> classes = this.application.classes();
            this.submitAll(classes, futures, executorService);
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberPool<T> buildForHierarchy(DexClass clazz, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building member pool collection");
        try {
            ArrayList futures = new ArrayList();
            this.submitAll(this.getAllSuperTypesInclusive(clazz, this.memberPools::containsKey), futures, executorService);
            this.submitAll(this.getAllSubTypesExclusive(clazz, this.memberPools::containsKey), futures, executorService);
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
        return this.get(clazz);
    }

    public boolean hasPool(DexClass clazz) {
        return this.memberPools.containsKey(clazz);
    }

    public MemberPool<T> get(DexClass clazz) {
        assert (this.hasPool(clazz));
        return this.memberPools.get(clazz);
    }

    public boolean markIfNotSeen(DexClass clazz, T reference) {
        Equivalence.Wrapper<T> key;
        MemberPool<T> memberPool = this.get(clazz);
        if (memberPool.hasSeen(key = this.equivalence.wrap(reference))) {
            return true;
        }
        memberPool.seen(key);
        return false;
    }

    private void submitAll(Iterable<? extends DexClass> classes, List<Future<?>> futures, ExecutorService executorService) {
        for (DexClass dexClass : classes) {
            futures.add(executorService.submit(this.computeMemberPoolForClass(dexClass)));
        }
    }

    abstract Runnable computeMemberPoolForClass(DexClass var1);

    private Set<DexClass> getAllSuperTypesInclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> superTypes = new HashSet<DexClass>();
        ArrayDeque<DexClass> worklist = new ArrayDeque<DexClass>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !superTypes.add(clazz)) continue;
            if (clazz.superType != null) {
                MemberPoolCollection.addNonNull(worklist, this.application.definitionFor(clazz.superType));
            }
            for (DexType interfaceType : clazz.interfaces.values) {
                MemberPoolCollection.addNonNull(worklist, this.application.definitionFor(interfaceType));
            }
        }
        return superTypes;
    }

    private Set<DexClass> getAllSubTypesExclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> subTypes = new HashSet<DexClass>();
        ArrayDeque worklist = new ArrayDeque();
        subject.type.forAllExtendsSubtypes(type -> MemberPoolCollection.addNonNull(worklist, this.application.definitionFor((DexType)type)));
        subject.type.forAllImplementsSubtypes(type -> MemberPoolCollection.addNonNull(worklist, this.application.definitionFor((DexType)type)));
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !subTypes.add(clazz)) continue;
            clazz.type.forAllExtendsSubtypes(type -> MemberPoolCollection.addNonNull(worklist, this.application.definitionFor((DexType)type)));
            clazz.type.forAllImplementsSubtypes(type -> MemberPoolCollection.addNonNull(worklist, this.application.definitionFor((DexType)type)));
        }
        return subTypes;
    }

    private static <T> void addNonNull(Collection<T> collection, T item) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static class MemberPool<T> {
        private Equivalence<T> equivalence;
        private MemberPool<T> superType;
        private final Set<MemberPool<T>> interfaces = new HashSet<MemberPool<T>>();
        private final Set<MemberPool<T>> subTypes = new HashSet<MemberPool<T>>();
        private final Set<Equivalence.Wrapper<T>> memberPool = new HashSet<Equivalence.Wrapper<T>>();

        MemberPool(Equivalence<T> equivalence) {
            this.equivalence = equivalence;
        }

        synchronized void linkSupertype(MemberPool<T> superType) {
            assert (this.superType == null);
            this.superType = superType;
        }

        synchronized void linkSubtype(MemberPool<T> subType) {
            boolean added = this.subTypes.add(subType);
            assert (added);
        }

        synchronized void linkInterface(MemberPool<T> itf) {
            boolean added = this.interfaces.add(itf);
            assert (added);
        }

        public void seen(T descriptor) {
            this.seen(this.equivalence.wrap(descriptor));
        }

        public synchronized void seen(Equivalence.Wrapper<T> descriptor) {
            boolean added = this.memberPool.add(descriptor);
            assert (added);
        }

        public boolean hasSeen(T descriptor) {
            return this.hasSeen(this.equivalence.wrap(descriptor));
        }

        public boolean hasSeen(Equivalence.Wrapper<T> descriptor) {
            return this.hasSeenUpwardRecursive(descriptor) || this.hasSeenDownwardRecursive(descriptor);
        }

        public boolean hasSeenDirectly(T descriptor) {
            return this.hasSeenDirectly(this.equivalence.wrap(descriptor));
        }

        public boolean hasSeenDirectly(Equivalence.Wrapper<T> descriptor) {
            return this.memberPool.contains(descriptor);
        }

        private boolean hasSeenUpwardRecursive(Equivalence.Wrapper<T> descriptor) {
            return this.memberPool.contains(descriptor) || this.superType != null && super.hasSeenUpwardRecursive(descriptor) || this.interfaces.stream().anyMatch(itf -> itf.hasSeenUpwardRecursive(descriptor));
        }

        private boolean hasSeenDownwardRecursive(Equivalence.Wrapper<T> reference) {
            return this.memberPool.contains(reference) || this.subTypes.stream().anyMatch(subType -> subType.hasSeenDownwardRecursive(reference));
        }
    }
}

