/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.optimize.PublicizerLense;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.Timing;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class ClassAndMemberPublicizer {
    private final DexApplication application;
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final RootSetBuilder.RootSet rootSet;
    private final MethodPoolCollection methodPoolCollection;
    private final PublicizerLense.PublicizedLenseBuilder lenseBuilder = PublicizerLense.createBuilder();

    private ClassAndMemberPublicizer(DexApplication application, AppView<? extends Enqueuer.AppInfoWithLiveness> appView, RootSetBuilder.RootSet rootSet) {
        this.application = application;
        this.appView = appView;
        this.methodPoolCollection = new MethodPoolCollection(application);
        this.rootSet = rootSet;
    }

    public static GraphLense run(ExecutorService executorService, Timing timing, DexApplication application, AppView<? extends Enqueuer.AppInfoWithLiveness> appView, RootSetBuilder.RootSet rootSet) throws ExecutionException {
        return new ClassAndMemberPublicizer(application, appView, rootSet).run(executorService, timing);
    }

    private GraphLense run(ExecutorService executorService, Timing timing) throws ExecutionException {
        this.methodPoolCollection.buildAll(executorService, timing);
        timing.begin("Phase 2: promoteToPublic");
        DexType.forAllInterfaces(this.appView.dexItemFactory(), this::publicizeType);
        this.publicizeType(this.appView.dexItemFactory().objectType);
        timing.end();
        return this.lenseBuilder.build(this.appView);
    }

    private void publicizeType(DexType type) {
        DexClass clazz = this.application.definitionFor(type);
        if (clazz != null && clazz.isProgramClass()) {
            clazz.accessFlags.promoteToPublic();
            clazz.forEachField(field -> field.accessFlags.promoteToPublic());
            LinkedHashSet<DexEncodedMethod> privateInstanceEncodedMethods = new LinkedHashSet<DexEncodedMethod>();
            clazz.forEachMethod(encodedMethod -> {
                if (this.publicizeMethod(clazz, (DexEncodedMethod)encodedMethod)) {
                    privateInstanceEncodedMethods.add((DexEncodedMethod)encodedMethod);
                }
            });
            if (!privateInstanceEncodedMethods.isEmpty()) {
                clazz.virtualizeMethods(privateInstanceEncodedMethods);
            }
        }
        type.forAllExtendsSubtypes(this::publicizeType);
    }

    private boolean publicizeMethod(DexClass holder, DexEncodedMethod encodedMethod) {
        MethodAccessFlags accessFlags = encodedMethod.accessFlags;
        if (accessFlags.isPublic()) {
            return false;
        }
        if (this.appView.dexItemFactory().isClassConstructor(encodedMethod.method)) {
            return false;
        }
        if (!accessFlags.isPrivate()) {
            accessFlags.promoteToPublic();
            return false;
        }
        assert (accessFlags.isPrivate());
        if (this.appView.dexItemFactory().isConstructor(encodedMethod.method)) {
            accessFlags.promoteToPublic();
            return false;
        }
        if (!accessFlags.isStatic()) {
            if (this.appView.appInfo().isPinned(encodedMethod.method)) {
                return false;
            }
            if (holder.isInterface() || accessFlags.isSynthetic()) {
                return false;
            }
            boolean wasSeen = this.methodPoolCollection.markIfNotSeen(holder, encodedMethod.method);
            if (wasSeen) {
                if (this.rootSet.noObfuscation.contains(encodedMethod.method)) {
                    return false;
                }
                return false;
            }
            this.lenseBuilder.add(encodedMethod.method);
            accessFlags.promoteToFinal();
            accessFlags.promoteToPublic();
            encodedMethod.method.setSingleVirtualMethodCache(encodedMethod.method.getHolder(), encodedMethod);
            return true;
        }
        accessFlags.promoteToPublic();
        return false;
    }
}

