/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.dexsplitter.DexSplitter;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Keep
public final class FeatureClassMapping {
    HashMap<String, String> parsedRules = new HashMap();
    HashMap<String, String> parseNonClassRules = new HashMap();
    boolean usesOnlyExactMappings = true;
    HashSet<FeaturePredicate> mappings = new HashSet();
    Path mappingFile;
    String baseName = "base";
    static final String DEFAULT_BASE_NAME = "base";
    static final String COMMENT = "#";
    static final String SEPARATOR = ":";

    public String getBaseName() {
        return this.baseName;
    }

    public static FeatureClassMapping fromSpecification(Path file) throws FeatureMappingException {
        return FeatureClassMapping.fromSpecification(file, new DiagnosticsHandler(){});
    }

    public static FeatureClassMapping fromSpecification(Path file, DiagnosticsHandler reporter) throws FeatureMappingException {
        FeatureClassMapping mapping = new FeatureClassMapping();
        List<String> lines = null;
        try {
            lines = FileUtils.readAllLines(file);
        }
        catch (IOException e) {
            reporter.error(new ExceptionDiagnostic(e, new SpecificationOrigin(file)));
            throw new AbortException();
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            mapping.parseAndAdd(line, i);
        }
        return mapping;
    }

    private FeatureClassMapping() {
    }

    public void addBaseMapping(String clazz) throws FeatureMappingException {
        this.addMapping(clazz, this.baseName);
    }

    public void addBaseNonClassMapping(String name) {
        this.addNonClassMapping(name, this.baseName);
    }

    public void addMapping(String clazz, String feature) throws FeatureMappingException {
        this.addRule(clazz, feature, 0);
    }

    public void addNonClassMapping(String name, String feature) {
        this.parseNonClassRules.put(name, this.parseNonClassRules.containsKey(name) ? this.baseName : feature);
    }

    FeatureClassMapping(List<String> lines) throws FeatureMappingException {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.parseAndAdd(line, i);
        }
    }

    public String featureForClass(String clazz) {
        if (this.usesOnlyExactMappings) {
            return this.parsedRules.getOrDefault(clazz, this.baseName);
        }
        FeaturePredicate bestMatch = null;
        for (FeaturePredicate mapping : this.mappings) {
            if (!mapping.match(clazz) || bestMatch != null && bestMatch.predicate.length() >= mapping.predicate.length()) continue;
            bestMatch = mapping;
        }
        if (bestMatch == null) {
            return this.baseName;
        }
        return bestMatch.feature;
    }

    public String featureForNonClass(String nonClass) {
        return this.parseNonClassRules.getOrDefault(nonClass, this.baseName);
    }

    private void parseAndAdd(String line, int lineNumber) throws FeatureMappingException {
        String[] values2;
        if (line.startsWith(COMMENT)) {
            return;
        }
        if (line.isEmpty()) {
            return;
        }
        if (!line.contains(SEPARATOR)) {
            this.error("Mapping lines must contain a :", lineNumber);
        }
        if ((values2 = line.split(SEPARATOR)).length != 2) {
            this.error("Mapping lines can only contain one :", lineNumber);
        }
        String predicate = values2[0];
        String feature = values2[1];
        this.addRule(predicate, feature, lineNumber);
    }

    private void addRule(String predicate, String feature, int lineNumber) throws FeatureMappingException {
        if (this.parsedRules.containsKey(predicate)) {
            if (!this.parsedRules.get(predicate).equals(feature)) {
                this.error("Redefinition of predicate " + predicate + "not allowed", lineNumber);
            }
            return;
        }
        this.parsedRules.put(predicate, feature);
        FeaturePredicate featurePredicate = new FeaturePredicate(predicate, feature);
        this.mappings.add(featurePredicate);
        this.usesOnlyExactMappings &= featurePredicate.isExactmapping();
    }

    private void error(String error, int line) throws FeatureMappingException {
        throw new FeatureMappingException("Invalid mappings specification: " + error + "\n in file " + this.mappingFile + SEPARATOR + line);
    }

    private static class FeaturePredicate {
        private static Pattern identifier = Pattern.compile("[A-Za-z_\\-][A-Za-z0-9_$\\-]*");
        final String predicate;
        final String feature;
        final boolean isCatchAll;
        final boolean isWildcard;

        FeaturePredicate(String predicate, String feature) throws FeatureMappingException {
            this.isWildcard = predicate.endsWith(".*");
            this.isCatchAll = predicate.equals("*");
            if (this.isCatchAll) {
                this.predicate = "";
            } else if (this.isWildcard) {
                String packageName = predicate.substring(0, predicate.length() - 2);
                if (!DescriptorUtils.isValidJavaType(packageName)) {
                    throw new FeatureMappingException(packageName + " is not a valid identifier");
                }
                this.predicate = predicate.substring(0, predicate.length() - 1);
            } else {
                if (!DescriptorUtils.isValidJavaType(predicate)) {
                    throw new FeatureMappingException(predicate + " is not a valid identifier");
                }
                this.predicate = predicate;
            }
            this.feature = feature;
        }

        boolean match(String className) {
            if (this.isCatchAll) {
                return true;
            }
            if (this.isWildcard) {
                return className.startsWith(this.predicate);
            }
            return className.equals(this.predicate);
        }

        boolean isExactmapping() {
            return !this.isWildcard && !this.isCatchAll;
        }
    }

    @Keep
    public static class FeatureMappingException
    extends Exception {
        FeatureMappingException(String message) {
            super(message);
        }
    }

    public static class Internal {
        private static List<String> getClassFileDescriptors(String jar, DiagnosticsHandler reporter) {
            Path jarPath = Paths.get(jar, new String[0]);
            try {
                return new ArchiveClassFileProvider(jarPath).getClassDescriptors().stream().map(DescriptorUtils::descriptorToJavaType).collect(Collectors.toList());
            }
            catch (IOException e) {
                reporter.error(new ExceptionDiagnostic(e, new JarFileOrigin(jarPath)));
                throw new AbortException();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static List<String> getNonClassFiles(String jar, DiagnosticsHandler reporter) {
            try (ZipFile zipfile = new ZipFile(jar, StandardCharsets.UTF_8);){
                List<String> list = zipfile.stream().filter(entry -> !ZipUtils.isClassFile(entry.getName())).map(ZipEntry::getName).collect(Collectors.toList());
                return list;
            }
            catch (IOException e) {
                reporter.error(new ExceptionDiagnostic(e, new JarFileOrigin(Paths.get(jar, new String[0]))));
                throw new AbortException();
            }
        }

        public static FeatureClassMapping fromJarFiles(List<DexSplitter.FeatureJar> featureJars, List<String> baseJars, String baseName, DiagnosticsHandler reporter) throws FeatureMappingException {
            FeatureClassMapping mapping = new FeatureClassMapping();
            if (baseName != null) {
                mapping.baseName = baseName;
            }
            for (DexSplitter.FeatureJar featureJar : featureJars) {
                for (String javaType : Internal.getClassFileDescriptors(featureJar.getJar(), reporter)) {
                    mapping.addMapping(javaType, featureJar.getOutputName());
                }
                for (String nonClass : Internal.getNonClassFiles(featureJar.getJar(), reporter)) {
                    mapping.addNonClassMapping(nonClass, featureJar.getOutputName());
                }
            }
            for (String baseJar : baseJars) {
                for (String javaType : Internal.getClassFileDescriptors(baseJar, reporter)) {
                    mapping.addBaseMapping(javaType);
                }
                for (String nonClass : Internal.getNonClassFiles(baseJar, reporter)) {
                    mapping.addBaseNonClassMapping(nonClass);
                }
            }
            assert (mapping.usesOnlyExactMappings);
            return mapping;
        }
    }

    private static class JarFileOrigin
    extends PathOrigin {
        public JarFileOrigin(Path path) {
            super(path);
        }

        @Override
        public String part() {
            return "jar file '" + super.part() + "'";
        }
    }

    private static class SpecificationOrigin
    extends PathOrigin {
        public SpecificationOrigin(Path path) {
            super(path);
        }

        @Override
        public String part() {
            return "specification file '" + super.part() + "'";
        }
    }
}

