/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.util.IntList;

public class BasicRegisterMapper
extends RegisterMapper {
    private final IntList oldToNew;
    private int runningCountNewRegisters;

    public BasicRegisterMapper(int countOldRegisters) {
        this.oldToNew = new IntList(countOldRegisters);
    }

    @Override
    public int getNewRegisterCount() {
        return this.runningCountNewRegisters;
    }

    @Override
    public RegisterSpec map(RegisterSpec registerSpec) {
        int newReg;
        if (registerSpec == null) {
            return null;
        }
        try {
            newReg = this.oldToNew.get(registerSpec.getReg());
        }
        catch (IndexOutOfBoundsException ex) {
            newReg = -1;
        }
        if (newReg < 0) {
            throw new RuntimeException("no mapping specified for register");
        }
        return registerSpec.withReg(newReg);
    }

    public int oldToNew(int oldReg) {
        if (oldReg >= this.oldToNew.size()) {
            return -1;
        }
        return this.oldToNew.get(oldReg);
    }

    public String toHuman() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Old\tNew\n");
        int sz = this.oldToNew.size();
        for (int i2 = 0; i2 < sz; ++i2) {
            sb2.append(i2);
            sb2.append('\t');
            sb2.append(this.oldToNew.get(i2));
            sb2.append('\n');
        }
        sb2.append("new reg count:");
        sb2.append(this.runningCountNewRegisters);
        sb2.append('\n');
        return sb2.toString();
    }

    public void addMapping(int oldReg, int newReg, int category) {
        if (oldReg >= this.oldToNew.size()) {
            for (int i2 = oldReg - this.oldToNew.size(); i2 >= 0; --i2) {
                this.oldToNew.add(-1);
            }
        }
        this.oldToNew.set(oldReg, newReg);
        if (this.runningCountNewRegisters < newReg + category) {
            this.runningCountNewRegisters = newReg + category;
        }
    }
}

