/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.DirectoryClassFileProvider;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.a.a.a.b.Ga;
import com.android.tools.r8.a.a.a.b.ea;
import com.android.tools.r8.a.a.a.b.ga;
import com.android.tools.r8.a.a.a.b.x;
import com.android.tools.r8.c;
import com.android.tools.r8.f;
import com.android.tools.r8.o;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.C;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class D8CommandParser
extends c {
    private static final Set<String> a;
    static final String b;

    public static D8Command.Builder a(String[] stringArray, Origin origin) {
        return D8CommandParser.a(stringArray, origin, D8Command.builder());
    }

    public static D8Command.Builder a(String[] stringArray, Origin origin, DiagnosticsHandler diagnosticsHandler) {
        return D8CommandParser.a(stringArray, origin, D8Command.builder(diagnosticsHandler));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static D8Command.Builder a(String[] stringArray, Origin origin, D8Command.Builder builder) {
        void var0_2;
        void var2_6;
        Object var0_1 = null;
        Path path = null;
        OutputMode outputMode = null;
        boolean bl = false;
        OrderedClassFileResourceProvider.Builder builder2 = OrderedClassFileResourceProvider.builder();
        String[] stringArray2 = C.a(stringArray, (BaseCommand.Builder)var2_6);
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            void var1_5;
            Object object = stringArray2[i2].trim();
            String string = null;
            if (a.contains(object)) {
                if (++i2 < stringArray2.length) {
                    string = stringArray2[i2];
                } else {
                    var2_6.error(new StringDiagnostic(o.a(o.a("Missing parameter for "), stringArray2[i2 - 1], "."), (Origin)var1_5));
                    break;
                }
            }
            if (((String)object).length() == 0) continue;
            if (((String)object).equals("--help")) {
                var2_6.setPrintHelp(true);
                continue;
            }
            if (((String)object).equals("--version")) {
                var2_6.setPrintVersion(true);
                continue;
            }
            if (((String)object).equals("--debug")) {
                if (var0_2 == CompilationMode.RELEASE) {
                    var2_6.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", (Origin)var1_5));
                    continue;
                }
                CompilationMode compilationMode = CompilationMode.DEBUG;
                continue;
            }
            if (((String)object).equals("--release")) {
                if (var0_2 == CompilationMode.DEBUG) {
                    var2_6.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", (Origin)var1_5));
                    continue;
                }
                CompilationMode compilationMode = CompilationMode.RELEASE;
                continue;
            }
            if (((String)object).equals("--file-per-class")) {
                outputMode = OutputMode.DexFilePerClass;
                continue;
            }
            if (((String)object).equals("--output")) {
                if (path != null) {
                    var2_6.error(new StringDiagnostic(o.a("Cannot output both to '").append(path.toString()).append("' and '").append(string).append("'").toString(), (Origin)var1_5));
                    continue;
                }
                path = Paths.get(string, new String[0]);
                continue;
            }
            if (((String)object).equals("--lib")) {
                var2_6.addLibraryFiles(Paths.get(string, new String[0]));
                continue;
            }
            if (((String)object).equals("--classpath")) {
                OrderedClassFileResourceProvider.Builder builder3;
                object = Paths.get(string, new String[0]);
                if (!Files.exists((Path)object, new LinkOption[0])) throw new NoSuchFileException(object.toString());
                string = object.getFileName().toString().toLowerCase();
                boolean bl2 = string.endsWith(".apk") || string.endsWith(".jar") || string.endsWith(".zip");
                if (bl2) {
                    builder3 = builder2.addClassFileResourceProvider(new ArchiveClassFileProvider((Path)object));
                    continue;
                }
                if (Files.isDirectory((Path)object, new LinkOption[0])) {
                    builder3 = builder2.addClassFileResourceProvider(DirectoryClassFileProvider.fromDirectory((Path)object));
                    continue;
                }
                void v2 = var2_6;
                try {
                    v2.error(new StringDiagnostic("Unsupported classpath file type", new PathOrigin((Path)object)));
                }
                catch (IOException iOException) {
                    var2_6.error(new ExceptionDiagnostic(iOException, new PathOrigin((Path)object)));
                }
                continue;
            }
            if (((String)object).equals("--main-dex-list")) {
                var2_6.addMainDexListFiles(Paths.get(string, new String[0]));
                continue;
            }
            if (((String)object).equals("--main-dex-list-output")) {
                var2_6.setMainDexListOutputPath(Paths.get(string, new String[0]));
                continue;
            }
            if (((String)object).equals("--optimize-multidex-for-linearalloc")) {
                var2_6.setOptimizeMultidexForLinearAlloc(true);
                continue;
            }
            if (((String)object).equals("--min-api")) {
                if (bl) {
                    var2_6.error(new StringDiagnostic("Cannot set multiple --min-api options", (Origin)var1_5));
                    continue;
                }
                c.a((BaseCompilerCommand.Builder)var2_6, string, (Origin)var1_5);
                bl = true;
                continue;
            }
            if (((String)object).equals("--intermediate")) {
                var2_6.setIntermediate(true);
                continue;
            }
            if (((String)object).equals("--no-desugaring")) {
                var2_6.setDisableDesugaring(true);
                continue;
            }
            if (((String)object).startsWith("--")) {
                var2_6.error(new StringDiagnostic(o.a("Unknown option: ", (String)object), (Origin)var1_5));
                continue;
            }
            var2_6.addProgramFiles(Paths.get((String)object, new String[0]));
        }
        if (!builder2.a()) {
            var2_6.addClasspathResourceProvider(builder2.build());
        }
        if (var0_2 != null) {
            var2_6.setMode((CompilationMode)var0_2);
        }
        if (outputMode == null) {
            outputMode = OutputMode.DexIndexed;
        }
        if (path != null) return (D8Command.Builder)var2_6.setOutput(path, outputMode);
        path = Paths.get(".", new String[0]);
        return (D8Command.Builder)var2_6.setOutput(path, outputMode);
    }

    static {
        String[] stringArray = new String[]{};
        a = Ga.a("--output", "--lib", "--classpath", "--min-api", "--main-dex-list", "--main-dex-list-output", stringArray);
        b = String.join((CharSequence)"\n", Arrays.asList("Usage: d8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --debug                 # Compile with debugging information (default).", "  --release               # Compile without debugging information.", "  --output <file>         # Output result in <outfile>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file>            # Add <file> as a library resource.", "  --classpath <file>      # Add <file> as a classpath resource.", o.a("  --min-api <number>      # Minimum Android API level compatibility, default: ").append(AndroidApiLevel.B.getLevel()).append(".").toString(), "  --intermediate          # Compile an intermediate result intended for later", "                          # merging.", "  --file-per-class        # Produce a separate dex file per input class", "  --no-desugaring         # Force disable desugaring.", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>", "                          # Output resulting main dex list in <file>.", "  --version               # Print the version of d8.", "  --help                  # Print this message."));
    }

    static class OrderedClassFileResourceProvider
    implements ClassFileResourceProvider {
        final List<ClassFileResourceProvider> providers;
        final Set<String> a = x.d();

        private OrderedClassFileResourceProvider(ga<ClassFileResourceProvider> ga2) {
            this.providers = ga2;
            this.providers.forEach(classFileResourceProvider -> this.a.addAll(classFileResourceProvider.getClassDescriptors()));
        }

        static Builder builder() {
            return new Builder();
        }

        /* synthetic */ OrderedClassFileResourceProvider(ga ga2, f f2) {
            this(ga2);
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.a;
        }

        @Override
        public ProgramResource getProgramResource(String string) {
            for (ClassFileResourceProvider classFileResourceProvider : ((OrderedClassFileResourceProvider)this).providers) {
                if (!classFileResourceProvider.getClassDescriptors().contains(string)) continue;
                return classFileResourceProvider.getProgramResource(string);
            }
            return null;
        }

        static class Builder {
            private final ea<ClassFileResourceProvider> a = ga.g();
            boolean b = true;

            Builder() {
            }

            OrderedClassFileResourceProvider build() {
                return new OrderedClassFileResourceProvider(this.a.a(), null);
            }

            Builder addClassFileResourceProvider(ClassFileResourceProvider classFileResourceProvider) {
                Builder builder = this;
                builder.a.a((Object)classFileResourceProvider);
                builder.b = false;
                return builder;
            }

            boolean a() {
                return this.b;
            }
        }
    }
}

