/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

public final class Bits {
    private Bits() {
    }

    public static int[] makeBitSet(int max) {
        int size = max + 31 >> 5;
        return new int[size];
    }

    public static int getMax(int[] bits) {
        return bits.length * 32;
    }

    public static boolean get(int[] bits, int idx) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        return (bits[arrayIdx] & bit) != 0;
    }

    public static void set(int[] bits, int idx, boolean value) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        if (value) {
            int n2 = arrayIdx;
            bits[n2] = bits[n2] | bit;
        } else {
            int n3 = arrayIdx;
            bits[n3] = bits[n3] & ~bit;
        }
    }

    public static void set(int[] bits, int idx) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        int n2 = arrayIdx;
        bits[n2] = bits[n2] | bit;
    }

    public static void clear(int[] bits, int idx) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        int n2 = arrayIdx;
        bits[n2] = bits[n2] & ~bit;
    }

    public static boolean isEmpty(int[] bits) {
        int len = bits.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (bits[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static int bitCount(int[] bits) {
        int len = bits.length;
        int count = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            count += Integer.bitCount(bits[i2]);
        }
        return count;
    }

    public static boolean anyInRange(int[] bits, int start, int end) {
        int idx = Bits.findFirst(bits, start);
        return idx >= 0 && idx < end;
    }

    public static int findFirst(int[] bits, int idx) {
        int len = bits.length;
        int minBit = idx & 0x1F;
        for (int arrayIdx = idx >> 5; arrayIdx < len; ++arrayIdx) {
            int bitIdx;
            int word = bits[arrayIdx];
            if (word != 0 && (bitIdx = Bits.findFirst(word, minBit)) >= 0) {
                return (arrayIdx << 5) + bitIdx;
            }
            minBit = 0;
        }
        return -1;
    }

    public static int findFirst(int value, int idx) {
        int result = Integer.numberOfTrailingZeros(value &= ~((1 << idx) - 1));
        return result == 32 ? -1 : result;
    }

    public static void or(int[] a2, int[] b2) {
        for (int i2 = 0; i2 < b2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] | b2[i2];
        }
    }

    public static String toHuman(int[] bits) {
        StringBuilder sb2 = new StringBuilder();
        boolean needsComma = false;
        sb2.append('{');
        int bitsLength = 32 * bits.length;
        for (int i2 = 0; i2 < bitsLength; ++i2) {
            if (!Bits.get(bits, i2)) continue;
            if (needsComma) {
                sb2.append(',');
            }
            needsComma = true;
            sb2.append(i2);
        }
        sb2.append('}');
        return sb2.toString();
    }
}

