/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.Bits;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntSet;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;

public class BitIntSet
implements IntSet {
    int[] bits;

    public BitIntSet(int max) {
        this.bits = Bits.makeBitSet(max);
    }

    @Override
    public void add(int value) {
        this.ensureCapacity(value);
        Bits.set(this.bits, value, true);
    }

    private void ensureCapacity(int value) {
        if (value >= Bits.getMax(this.bits)) {
            int[] newBits = Bits.makeBitSet(Math.max(value + 1, 2 * Bits.getMax(this.bits)));
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    @Override
    public void remove(int value) {
        if (value < Bits.getMax(this.bits)) {
            Bits.set(this.bits, value, false);
        }
    }

    @Override
    public boolean has(int value) {
        return value < Bits.getMax(this.bits) && Bits.get(this.bits, value);
    }

    @Override
    public void merge(IntSet other) {
        if (other instanceof BitIntSet) {
            BitIntSet o2 = (BitIntSet)other;
            this.ensureCapacity(Bits.getMax(o2.bits) + 1);
            Bits.or(this.bits, o2.bits);
        } else if (other instanceof ListIntSet) {
            ListIntSet o3 = (ListIntSet)other;
            int sz = o3.ints.size();
            if (sz > 0) {
                this.ensureCapacity(o3.ints.get(sz - 1));
            }
            for (int i2 = 0; i2 < o3.ints.size(); ++i2) {
                Bits.set(this.bits, o3.ints.get(i2), true);
            }
        } else {
            IntIterator iter = other.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    @Override
    public int elements() {
        return Bits.bitCount(this.bits);
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int idx;
            {
                this.idx = Bits.findFirst(BitIntSet.this.bits, 0);
            }

            @Override
            public boolean hasNext() {
                return this.idx >= 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int ret = this.idx;
                this.idx = Bits.findFirst(BitIntSet.this.bits, this.idx + 1);
                return ret;
            }
        };
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append('{');
        boolean first = true;
        int i2 = Bits.findFirst(this.bits, 0);
        while (i2 >= 0) {
            if (!first) {
                sb2.append(", ");
            }
            first = false;
            sb2.append(i2);
            i2 = Bits.findFirst(this.bits, i2 + 1);
        }
        sb2.append('}');
        return sb2.toString();
    }
}

