/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.Hex;
import java.util.ArrayList;
import java.util.List;

public final class PhiInsn
extends SsaInsn {
    private final int ropResultReg;
    private final ArrayList<Operand> operands = new ArrayList();
    private RegisterSpecList sources;

    public PhiInsn(RegisterSpec resultReg, SsaBasicBlock block) {
        super(resultReg, block);
        this.ropResultReg = resultReg.getReg();
    }

    public PhiInsn(int resultReg, SsaBasicBlock block) {
        super(RegisterSpec.make(resultReg, Type.VOID), block);
        this.ropResultReg = resultReg;
    }

    @Override
    public PhiInsn clone() {
        throw new UnsupportedOperationException("can't clone phi");
    }

    public void updateSourcesToDefinitions(SsaMethod ssaMeth) {
        for (Operand o2 : this.operands) {
            RegisterSpec def = ssaMeth.getDefinitionForRegister(o2.regSpec.getReg()).getResult();
            o2.regSpec = o2.regSpec.withType(def.getType());
        }
        this.sources = null;
    }

    public void changeResultType(TypeBearer type, LocalItem local) {
        this.setResult(RegisterSpec.makeLocalOptional(this.getResult().getReg(), type, local));
    }

    public int getRopResultReg() {
        return this.ropResultReg;
    }

    public void addPhiOperand(RegisterSpec registerSpec, SsaBasicBlock predBlock) {
        this.operands.add(new Operand(registerSpec, predBlock.getIndex(), predBlock.getRopLabel()));
        this.sources = null;
    }

    public void removePhiRegister(RegisterSpec registerSpec) {
        ArrayList<Operand> operandsToRemove = new ArrayList<Operand>();
        for (Operand o2 : this.operands) {
            if (o2.regSpec.getReg() != registerSpec.getReg()) continue;
            operandsToRemove.add(o2);
        }
        this.operands.removeAll(operandsToRemove);
        this.sources = null;
    }

    public int predBlockIndexForSourcesIndex(int sourcesIndex) {
        return this.operands.get((int)sourcesIndex).blockIndex;
    }

    @Override
    public Rop getOpcode() {
        return null;
    }

    @Override
    public Insn getOriginalRopInsn() {
        return null;
    }

    @Override
    public boolean canThrow() {
        return false;
    }

    @Override
    public RegisterSpecList getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        if (this.operands.size() == 0) {
            return RegisterSpecList.EMPTY;
        }
        int szSources = this.operands.size();
        this.sources = new RegisterSpecList(szSources);
        for (int i2 = 0; i2 < szSources; ++i2) {
            Operand o2 = this.operands.get(i2);
            this.sources.set(i2, o2.regSpec);
        }
        this.sources.setImmutable();
        return this.sources;
    }

    @Override
    public boolean isRegASource(int reg) {
        for (Operand o2 : this.operands) {
            if (o2.regSpec.getReg() != reg) continue;
            return true;
        }
        return false;
    }

    public boolean areAllOperandsEqual() {
        if (this.operands.size() == 0) {
            return true;
        }
        int firstReg = this.operands.get((int)0).regSpec.getReg();
        for (Operand o2 : this.operands) {
            if (firstReg == o2.regSpec.getReg()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void mapSourceRegisters(RegisterMapper mapper) {
        for (Operand o2 : this.operands) {
            RegisterSpec old = o2.regSpec;
            o2.regSpec = mapper.map(old);
            if (old == o2.regSpec) continue;
            this.getBlock().getParent().onSourceChanged(this, old, o2.regSpec);
        }
        this.sources = null;
    }

    @Override
    public Insn toRopInsn() {
        throw new IllegalArgumentException("Cannot convert phi insns to rop form");
    }

    public List<SsaBasicBlock> predBlocksForReg(int reg, SsaMethod ssaMeth) {
        ArrayList<SsaBasicBlock> ret = new ArrayList<SsaBasicBlock>();
        for (Operand o2 : this.operands) {
            if (o2.regSpec.getReg() != reg) continue;
            ret.add(ssaMeth.getBlocks().get(o2.blockIndex));
        }
        return ret;
    }

    @Override
    public boolean isPhiOrMove() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        return Optimizer.getPreserveLocals() && this.getLocalAssignment() != null;
    }

    @Override
    public void accept(SsaInsn.Visitor v2) {
        v2.visitPhiInsn(this);
    }

    @Override
    public String toHuman() {
        return this.toHumanWithInline(null);
    }

    protected final String toHumanWithInline(String extra) {
        RegisterSpec result;
        StringBuilder sb2 = new StringBuilder(80);
        sb2.append(SourcePosition.NO_INFO);
        sb2.append(": phi");
        if (extra != null) {
            sb2.append("(");
            sb2.append(extra);
            sb2.append(")");
        }
        if ((result = this.getResult()) == null) {
            sb2.append(" .");
        } else {
            sb2.append(" ");
            sb2.append(result.toHuman());
        }
        sb2.append(" <-");
        int sz = this.getSources().size();
        if (sz == 0) {
            sb2.append(" .");
        } else {
            for (int i2 = 0; i2 < sz; ++i2) {
                sb2.append(" ");
                sb2.append(this.sources.get(i2).toHuman() + "[b=" + Hex.u2(this.operands.get((int)i2).ropLabel) + "]");
            }
        }
        return sb2.toString();
    }

    public static interface Visitor {
        public void visitPhiInsn(PhiInsn var1);
    }

    private static class Operand {
        public RegisterSpec regSpec;
        public final int blockIndex;
        public final int ropLabel;

        public Operand(RegisterSpec regSpec, int blockIndex, int ropLabel) {
            this.regSpec = regSpec;
            this.blockIndex = blockIndex;
            this.ropLabel = ropLabel;
        }
    }
}

