/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.ssa.Dominators;
import com.android.dx.ssa.SetFactory;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.IntSet;
import java.util.ArrayList;
import java.util.BitSet;

public class DomFront {
    private static final boolean DEBUG = false;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> nodes;
    private final DomInfo[] domInfos;

    public DomFront(SsaMethod meth) {
        this.meth = meth;
        this.nodes = meth.getBlocks();
        int szNodes = this.nodes.size();
        this.domInfos = new DomInfo[szNodes];
        for (int i2 = 0; i2 < szNodes; ++i2) {
            this.domInfos[i2] = new DomInfo();
        }
    }

    public DomInfo[] run() {
        int szNodes = this.nodes.size();
        Dominators methDom = Dominators.make(this.meth, this.domInfos, false);
        this.buildDomTree();
        for (int i2 = 0; i2 < szNodes; ++i2) {
            this.domInfos[i2].dominanceFrontiers = SetFactory.makeDomFrontSet(szNodes);
        }
        this.calcDomFronts();
        return this.domInfos;
    }

    private void debugPrintDomChildren() {
        int szNodes = this.nodes.size();
        for (int i2 = 0; i2 < szNodes; ++i2) {
            SsaBasicBlock node = this.nodes.get(i2);
            StringBuffer sb2 = new StringBuffer();
            sb2.append('{');
            boolean comma = false;
            for (SsaBasicBlock child : node.getDomChildren()) {
                if (comma) {
                    sb2.append(',');
                }
                sb2.append(child);
                comma = true;
            }
            sb2.append('}');
            System.out.println("domChildren[" + node + "]: " + sb2);
        }
    }

    private void buildDomTree() {
        int szNodes = this.nodes.size();
        for (int i2 = 0; i2 < szNodes; ++i2) {
            DomInfo info = this.domInfos[i2];
            if (info.idom == -1) continue;
            SsaBasicBlock domParent = this.nodes.get(info.idom);
            domParent.addDomChild(this.nodes.get(i2));
        }
    }

    private void calcDomFronts() {
        int szNodes = this.nodes.size();
        for (int b2 = 0; b2 < szNodes; ++b2) {
            SsaBasicBlock nb2 = this.nodes.get(b2);
            DomInfo nbInfo = this.domInfos[b2];
            BitSet pred = nb2.getPredecessors();
            if (pred.cardinality() <= 1) continue;
            int i2 = pred.nextSetBit(0);
            while (i2 >= 0) {
                int runnerIndex = i2;
                while (runnerIndex != nbInfo.idom && runnerIndex != -1) {
                    DomInfo runnerInfo = this.domInfos[runnerIndex];
                    if (runnerInfo.dominanceFrontiers.has(b2)) break;
                    runnerInfo.dominanceFrontiers.add(b2);
                    runnerIndex = runnerInfo.idom;
                }
                i2 = pred.nextSetBit(i2 + 1);
            }
        }
    }

    public static class DomInfo {
        public IntSet dominanceFrontiers;
        public int idom = -1;
    }
}

