/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexMergingStrategy;
import com.android.dex.Dex;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class NaiveDexMergingStrategy
implements DexMergingStrategy {
    @VisibleForTesting
    static final int MAX_NUMBER_OF_IDS_IN_DEX = 65536;
    private final List<Dex> currentDexesToMerge = Lists.newArrayList();
    private int currentMethodIdsUsed = 0;
    private int currentFieldIdsUsed = 0;

    @Override
    public boolean tryToAddForMerging(Dex dexFile) {
        int dexMethodIds = dexFile.getTableOfContents().methodIds.size;
        int dexFieldIds = dexFile.getTableOfContents().fieldIds.size;
        if (dexMethodIds + this.currentMethodIdsUsed > 65536) {
            return false;
        }
        if (dexFieldIds + this.currentFieldIdsUsed > 65536) {
            return false;
        }
        this.currentMethodIdsUsed += dexMethodIds;
        this.currentFieldIdsUsed += dexFieldIds;
        this.currentDexesToMerge.add(dexFile);
        return true;
    }

    @Override
    public void startNewDex() {
        this.currentMethodIdsUsed = 0;
        this.currentFieldIdsUsed = 0;
        this.currentDexesToMerge.clear();
    }

    @Override
    public ImmutableList<Dex> getAllDexToMerge() {
        return ImmutableList.copyOf(this.currentDexesToMerge);
    }
}

