/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.rop.cst.CstType;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.Hex;

public final class CatchHandlerList
extends FixedSizeList
implements Comparable<CatchHandlerList> {
    public static final CatchHandlerList EMPTY = new CatchHandlerList(0);

    public CatchHandlerList(int size) {
        super(size);
    }

    public Entry get(int n2) {
        return (Entry)this.get0(n2);
    }

    @Override
    public String toHuman() {
        return this.toHuman("", "");
    }

    public String toHuman(String prefix, String header) {
        StringBuilder sb2 = new StringBuilder(100);
        int size = this.size();
        sb2.append(prefix);
        sb2.append(header);
        sb2.append("catch ");
        for (int i2 = 0; i2 < size; ++i2) {
            Entry entry = this.get(i2);
            if (i2 != 0) {
                sb2.append(",\n");
                sb2.append(prefix);
                sb2.append("  ");
            }
            if (i2 == size - 1 && this.catchesAll()) {
                sb2.append("<any>");
            } else {
                sb2.append(entry.getExceptionType().toHuman());
            }
            sb2.append(" -> ");
            sb2.append(Hex.u2or4(entry.getHandler()));
        }
        return sb2.toString();
    }

    public boolean catchesAll() {
        int size = this.size();
        if (size == 0) {
            return false;
        }
        Entry last = this.get(size - 1);
        return last.getExceptionType().equals(CstType.OBJECT);
    }

    public void set(int n2, CstType exceptionType, int handler) {
        this.set0(n2, new Entry(exceptionType, handler));
    }

    public void set(int n2, Entry entry) {
        this.set0(n2, entry);
    }

    @Override
    public int compareTo(CatchHandlerList other) {
        if (this == other) {
            return 0;
        }
        int thisSize = this.size();
        int otherSize = other.size();
        int checkSize = Math.min(thisSize, otherSize);
        for (int i2 = 0; i2 < checkSize; ++i2) {
            Entry otherEntry;
            Entry thisEntry = this.get(i2);
            int compare = thisEntry.compareTo(otherEntry = other.get(i2));
            if (compare == 0) continue;
            return compare;
        }
        if (thisSize < otherSize) {
            return -1;
        }
        if (thisSize > otherSize) {
            return 1;
        }
        return 0;
    }

    public static class Entry
    implements Comparable<Entry> {
        private final CstType exceptionType;
        private final int handler;

        public Entry(CstType exceptionType, int handler) {
            if (handler < 0) {
                throw new IllegalArgumentException("handler < 0");
            }
            if (exceptionType == null) {
                throw new NullPointerException("exceptionType == null");
            }
            this.handler = handler;
            this.exceptionType = exceptionType;
        }

        public int hashCode() {
            return this.handler * 31 + this.exceptionType.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                return this.compareTo((Entry)other) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(Entry other) {
            if (this.handler < other.handler) {
                return -1;
            }
            if (this.handler > other.handler) {
                return 1;
            }
            return this.exceptionType.compareTo(other.exceptionType);
        }

        public CstType getExceptionType() {
            return this.exceptionType;
        }

        public int getHandler() {
            return this.handler;
        }
    }
}

