/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class ArrayUtils {
    public static <T> T[] copyWithSparseChanges(Class<T[]> TArray, T[] TArray2, Map<Integer, T> map) {
        TArray = TArray.cast(Array.newInstance(TArray.getComponentType(), TArray2.length));
        int n2 = 0;
        for (Map.Entry<Integer, T> entry : map.entrySet()) {
            int n3 = entry.getKey();
            System.arraycopy(TArray2, n2, TArray, n2, n3 - n2);
            TArray[n3] = entry.getValue();
            n2 = n3 + 1;
        }
        if (n2 < TArray2.length) {
            System.arraycopy(TArray2, n2, TArray, n2, TArray2.length - n2);
        }
        return TArray;
    }

    public static <T> T[] filter(Class<T[]> clazz, T[] TArray, Predicate<T> predicate) {
        ArrayList arrayList = null;
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            ArrayList arrayList2;
            T t2 = TArray[i2];
            if (predicate.test(t2)) {
                if (arrayList == null) continue;
                arrayList.add(t2);
                continue;
            }
            if (arrayList != null) continue;
            arrayList = arrayList2;
            arrayList2 = new ArrayList(TArray.length);
            for (int i3 = 0; i3 < i2; ++i3) {
                arrayList.add(TArray[i3]);
            }
        }
        if (arrayList == null) {
            return TArray;
        }
        Class<T[]> clazz2 = clazz;
        return arrayList.toArray(clazz2.cast(Array.newInstance(clazz2.getComponentType(), arrayList.size())));
    }

    public static <T> T[] map(Class<T[]> clazz, T[] TArray, Function<T, T> function) {
        ArrayList arrayList = null;
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            T t2 = TArray[i2];
            T t3 = function.apply(t2);
            if (t3 == t2) {
                if (arrayList == null) continue;
                arrayList.add(t2);
                continue;
            }
            if (arrayList == null) {
                ArrayList arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList(TArray.length);
                for (int i3 = 0; i3 < i2; ++i3) {
                    arrayList.add(TArray[i3]);
                }
            }
            if (t3 == null) continue;
            arrayList.add(t3);
        }
        if (arrayList == null) {
            return TArray;
        }
        Class<T[]> clazz2 = clazz;
        return arrayList.toArray(clazz2.cast(Array.newInstance(clazz2.getComponentType(), arrayList.size())));
    }
}

