/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.util.IntList;
import java.util.BitSet;

public class IdenticalBlockCombiner {
    private final RopMethod ropMethod;
    private final BasicBlockList blocks;
    private final BasicBlockList newBlocks;

    public IdenticalBlockCombiner(RopMethod rm) {
        this.ropMethod = rm;
        this.blocks = this.ropMethod.getBlocks();
        this.newBlocks = this.blocks.getMutableCopy();
    }

    public RopMethod process() {
        int szBlocks = this.blocks.size();
        BitSet toDelete = new BitSet(this.blocks.getMaxLabel());
        for (int bindex = 0; bindex < szBlocks; ++bindex) {
            BasicBlock b3 = this.blocks.get(bindex);
            if (toDelete.get(b3.getLabel())) continue;
            IntList preds = this.ropMethod.labelToPredecessors(b3.getLabel());
            int szPreds = preds.size();
            for (int i3 = 0; i3 < szPreds; ++i3) {
                int iLabel = preds.get(i3);
                BasicBlock iBlock = this.blocks.labelToBlock(iLabel);
                if (toDelete.get(iLabel) || iBlock.getSuccessors().size() > 1 || iBlock.getFirstInsn().getOpcode().getOpcode() == 55) continue;
                IntList toCombine = new IntList();
                for (int j3 = i3 + 1; j3 < szPreds; ++j3) {
                    int jLabel = preds.get(j3);
                    BasicBlock jBlock = this.blocks.labelToBlock(jLabel);
                    if (jBlock.getSuccessors().size() != 1 || !IdenticalBlockCombiner.compareInsns(iBlock, jBlock)) continue;
                    toCombine.add(jLabel);
                    toDelete.set(jLabel);
                }
                this.combineBlocks(iLabel, toCombine);
            }
        }
        for (int i4 = szBlocks - 1; i4 >= 0; --i4) {
            if (!toDelete.get(this.newBlocks.get(i4).getLabel())) continue;
            this.newBlocks.set(i4, null);
        }
        this.newBlocks.shrinkToFit();
        this.newBlocks.setImmutable();
        return new RopMethod(this.newBlocks, this.ropMethod.getFirstLabel());
    }

    private static boolean compareInsns(BasicBlock a3, BasicBlock b3) {
        return a3.getInsns().contentEquals(b3.getInsns());
    }

    private void combineBlocks(int alphaLabel, IntList betaLabels) {
        int szBetas = betaLabels.size();
        for (int i3 = 0; i3 < szBetas; ++i3) {
            int betaLabel = betaLabels.get(i3);
            BasicBlock bb = this.blocks.labelToBlock(betaLabel);
            IntList preds = this.ropMethod.labelToPredecessors(bb.getLabel());
            int szPreds = preds.size();
            for (int j3 = 0; j3 < szPreds; ++j3) {
                BasicBlock predBlock = this.newBlocks.labelToBlock(preds.get(j3));
                this.replaceSucc(predBlock, betaLabel, alphaLabel);
            }
        }
    }

    private void replaceSucc(BasicBlock block, int oldLabel, int newLabel) {
        IntList newSuccessors = block.getSuccessors().mutableCopy();
        newSuccessors.set(newSuccessors.indexOf(oldLabel), newLabel);
        int newPrimarySuccessor = block.getPrimarySuccessor();
        if (newPrimarySuccessor == oldLabel) {
            newPrimarySuccessor = newLabel;
        }
        newSuccessors.setImmutable();
        BasicBlock newBB = new BasicBlock(block.getLabel(), block.getInsns(), newSuccessors, newPrimarySuccessor);
        this.newBlocks.set(this.newBlocks.indexOfLabel(block.getLabel()), newBB);
    }
}

