/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.IncrementalFileMergerState;
import com.android.builder.merge.OpenableCloseable;
import com.android.ide.common.resources.FileStatus;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public final class IncrementalFileMerger {
    private IncrementalFileMerger() {
    }

    public static IncrementalFileMergerState merge(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output2, IncrementalFileMergerState state) {
        IncrementalFileMergerState.Builder newState = new IncrementalFileMergerState.Builder(state);
        newState.setInputNames((List<String>)IncrementalFileMerger.getInputNames(inputs));
        List inputNames = inputs.stream().map(IncrementalFileMergerInput::getName).collect(Collectors.toList());
        output2.open();
        inputs.forEach(OpenableCloseable::open);
        if (inputNames.equals(state.getInputNames())) {
            IncrementalFileMerger.mergeNoChangedInputs(inputs, output2, state, newState);
        } else {
            IncrementalFileMerger.mergeChangedInputs(inputs, output2, state, newState);
        }
        inputs.forEach(OpenableCloseable::close);
        output2.close();
        return newState.build();
    }

    private static void mergeNoChangedInputs(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output2, IncrementalFileMergerState state, IncrementalFileMergerState.Builder newState) {
        HashSet impactedPaths = new HashSet();
        inputs.forEach(i3 -> impactedPaths.addAll(i3.getUpdatedPaths()));
        for (String path : impactedPaths) {
            ImmutableList<String> prevInputNames = state.inputsFor(path);
            List<IncrementalFileMergerInput> inputsForFile = IncrementalFileMerger.getInputsForFile(path, inputs, state);
            IncrementalFileMerger.updateChangedFile(inputsForFile, prevInputNames, output2, path, newState);
        }
    }

    private static void mergeChangedInputs(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output2, IncrementalFileMergerState state, IncrementalFileMergerState.Builder newState) {
        ArrayList<String> allNames = new ArrayList<String>((Collection<String>)state.getInputNames());
        List<String> newInputNameList = inputs.stream().map(IncrementalFileMergerInput::getName).peek(n3 -> {
            if (!allNames.contains(n3)) {
                allNames.add((String)n3);
            }
        }).collect(Collectors.toList());
        newState.setInputNames(allNames);
        HashSet maybeImpactedPaths = new HashSet();
        state.getInputNames().forEach(n3 -> maybeImpactedPaths.addAll(state.filesOf((String)n3)));
        inputs.forEach(i3 -> maybeImpactedPaths.addAll(i3.getUpdatedPaths()));
        for (String path : maybeImpactedPaths) {
            ImmutableList<String> prevInputNames = state.inputsFor(path);
            List<IncrementalFileMergerInput> inputsForFile = IncrementalFileMerger.getInputsForFile(path, inputs, state);
            boolean changed = false;
            if (prevInputNames.size() != inputsForFile.size()) {
                changed = true;
            }
            for (int i4 = 0; !changed && i4 < prevInputNames.size(); ++i4) {
                if (((String)prevInputNames.get(i4)).equals(inputsForFile.get(i4).getName())) continue;
                changed = true;
            }
            if (!changed && inputsForFile.stream().anyMatch(i3 -> i3.getFileStatus(path) != null)) {
                changed = true;
            }
            if (!changed) continue;
            IncrementalFileMerger.updateChangedFile(inputsForFile, prevInputNames, output2, path, newState);
        }
        newState.setInputNames(newInputNameList);
    }

    private static void updateChangedFile(List<IncrementalFileMergerInput> inputsForFile, ImmutableList<String> prevInputNames, IncrementalFileMergerOutput output2, String path, IncrementalFileMergerState.Builder newState) {
        if (inputsForFile.isEmpty()) {
            output2.remove(path);
            newState.remove(path);
        } else if (prevInputNames.isEmpty()) {
            output2.create(path, (List<IncrementalFileMergerInput>)ImmutableList.copyOf(inputsForFile));
            newState.set(path, (List<String>)IncrementalFileMerger.getInputNames(inputsForFile));
        } else {
            output2.update(path, (List<String>)prevInputNames, (List<IncrementalFileMergerInput>)ImmutableList.copyOf(inputsForFile));
            newState.set(path, (List<String>)IncrementalFileMerger.getInputNames(inputsForFile));
        }
    }

    private static List<IncrementalFileMergerInput> getInputsForFile(String path, List<IncrementalFileMergerInput> inputs, IncrementalFileMergerState state) {
        ImmutableList<String> prevInputNames = state.inputsFor(path);
        return inputs.stream().filter(i3 -> {
            FileStatus status = i3.getFileStatus(path);
            if (status == null) {
                return prevInputNames.contains(i3.getName());
            }
            return status != FileStatus.REMOVED;
        }).collect(Collectors.toList());
    }

    private static ImmutableList<String> getInputNames(List<IncrementalFileMergerInput> inputs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        inputs.forEach(i3 -> builder.add((Object)i3.getName()));
        return builder.build();
    }
}

