/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.merge.DuplicatePathInIncrementalInputException;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class LazyIncrementalFileMergerInputs {
    private LazyIncrementalFileMergerInputs() {
    }

    public static LazyIncrementalFileMergerInput fromNew(String name, Set<File> base) {
        ImmutableSet baseI = ImmutableSet.copyOf(base);
        CachedSupplier all = new CachedSupplier(() -> LazyIncrementalFileMergerInputs.load((Set<File>)baseI));
        CachedSupplier upd = new CachedSupplier(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ((Set)all.get()).forEach(rf -> builder.put(rf, (Object)FileStatus.NEW));
            return builder.build();
        });
        return new LazyIncrementalFileMergerInput(name, (CachedSupplier<Map<RelativeFile, FileStatus>>)upd, (CachedSupplier<Set<RelativeFile>>)all);
    }

    private static ImmutableSet<RelativeFile> load(Set<File> base) {
        HashSet<String> paths = new HashSet<String>();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File b3 : base) {
            Set<RelativeFile> files;
            if (b3.isFile()) {
                try {
                    files = RelativeFiles.fromZip(new ZipCentralDirectory(b3));
                }
                catch (IOException e3) {
                    throw new UncheckedIOException(e3);
                }
            } else if (b3.isDirectory()) {
                files = RelativeFiles.fromDirectory(b3);
            } else {
                throw new AssertionError();
            }
            for (RelativeFile rf : files) {
                String p3 = rf.getRelativePath();
                if (paths.add(p3)) continue;
                throw new DuplicatePathInIncrementalInputException("Duplicate relative path '" + p3 + "'");
            }
            builder.addAll(files);
        }
        return builder.build();
    }

    public static LazyIncrementalFileMergerInput fromUpdates(String name, Set<File> base, Map<File, FileStatus> updates, FileCacheByPath cache, IncrementalRelativeFileSets.FileDeletionPolicy fileDeletionPolicy) {
        CachedSupplier all = new CachedSupplier(() -> LazyIncrementalFileMergerInputs.load(base));
        CachedSupplier upd = new CachedSupplier(() -> {
            try {
                HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
                ImmutableMap<RelativeFile, FileStatus> incrementalUpdates = IncrementalRelativeFileSets.makeFromBaseFiles(base, updates, cache, cacheUpdates, fileDeletionPolicy);
                cacheUpdates.forEach(Runnable::run);
                return incrementalUpdates;
            }
            catch (IOException e3) {
                throw new UncheckedIOException(e3);
            }
        });
        return new LazyIncrementalFileMergerInput(name, (CachedSupplier<Map<RelativeFile, FileStatus>>)upd, (CachedSupplier<Set<RelativeFile>>)all);
    }
}

