/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.aar;

import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/builder/aar/AarExtractor;", "", "()V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "choosePathInOutput", "", "entryName", "extract", "", "aar", "Ljava/io/File;", "outputDir", "builder"})
public final class AarExtractor {
    private final StringBuilder stringBuilder;

    private final String choosePathInOutput(String entryName) {
        String string;
        this.stringBuilder.setLength(5);
        if (Intrinsics.areEqual((Object)entryName, (Object)"classes.jar") || Intrinsics.areEqual((Object)entryName, (Object)"lint.jar")) {
            this.stringBuilder.append(entryName);
            String string2 = this.stringBuilder.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stringBuilder.toString()");
        } else if (StringsKt.startsWith$default((String)entryName, (String)"libs/", (boolean)false, (int)2, null)) {
            String string3 = entryName;
            int n2 = 5;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String pathWithinLibs = string5;
            if (Intrinsics.areEqual((Object)pathWithinLibs, (Object)"classes.jar")) {
                this.stringBuilder.append("libs/").append("classes-2.jar");
            } else if (Intrinsics.areEqual((Object)pathWithinLibs, (Object)"lint.jar")) {
                this.stringBuilder.append("libs/").append("lint-2.jar");
            } else {
                this.stringBuilder.append("libs/").append(pathWithinLibs);
            }
            String string6 = this.stringBuilder.toString();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"stringBuilder.toString()");
        } else {
            string = entryName;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull File aar, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)aar, (String)"aar");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Object object = aar;
        int n2 = 0;
        InputStream inputStream = new FileInputStream((File)object);
        object = inputStream;
        n2 = 8192;
        boolean bl = false;
        inputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n2);
        InputStream inputStream2 = inputStream;
        object = new ZipInputStream(inputStream2);
        n2 = 0;
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream = (ZipInputStream)object;
            boolean bl2 = false;
            while (zipInputStream.getNextEntry() != null) {
                ZipEntry entry;
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                String path = FileUtils.toSystemDependentPath((String)this.choosePathInOutput(string));
                File outputFile = new File(outputDir, path);
                if (!ZipEntryUtils.isValidZipEntryPath(outputFile, outputDir)) continue;
                Files.createParentDirs((File)outputFile);
                Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)zipInputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public AarExtractor() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder(60);
        AarExtractor aarExtractor = this;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder2;
        boolean bl3 = false;
        $this$apply.append("jars");
        $this$apply.append(File.separatorChar);
        aarExtractor.stringBuilder = stringBuilder = stringBuilder2;
    }
}

