/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"makeCompileCommand", "Lcom/google/common/collect/ImmutableList;", "", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "makeLinkCommand", "config", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "builder"})
@JvmName(name="AaptV2CommandBuilder")
public final class AaptV2CommandBuilder {
    @NotNull
    public static final ImmutableList<String> makeCompileCommand(@NotNull CompileResourceRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (request.isPseudoLocalize()) {
            parameters.add((Object)"--pseudo-localize");
        }
        if (!request.isPngCrunching()) {
            String string = request.getInputFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.inputFile.path");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            String lowerName = string4;
            if (StringsKt.endsWith$default((String)lowerName, (String)".png", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)lowerName, (String)".9.png", (boolean)false, (int)2, null)) {
                parameters.add((Object)"--no-crunch");
            }
        }
        if (request.getPartialRFile() != null) {
            Object[] objectArray = new String[2];
            objectArray[0] = "--output-text-symbols";
            File file = request.getPartialRFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = file.getAbsolutePath();
            parameters.add(objectArray);
        }
        parameters.add((Object)"--legacy");
        parameters.add((Object[])new String[]{"-o", request.getOutputDirectory().getAbsolutePath()});
        parameters.add((Object)request.getInputFile().getAbsolutePath());
        ImmutableList immutableList = parameters.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"parameters.build()");
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<String> makeLinkCommand(@NotNull AaptPackageConfig config) throws AaptException {
        Iterable<String> densityResSplits;
        List<String> additionalParameters;
        Object[] objectArray;
        File resourceOutputApk;
        ImmutableList.Builder builder;
        block57: {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            builder = ImmutableList.builder();
            if (config.getVerbose()) {
                builder.add((Object)"-v");
            }
            if (config.getGenerateProtos()) {
                builder.add((Object)"--proto-format");
            }
            builder.add((Object[])new String[]{"-I", (String)Preconditions.checkNotNull((Object)config.getAndroidJarPath())});
            Iterable $this$forEach$iv = (Iterable)config.getImports();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                Object[] objectArray2 = new String[2];
                objectArray2[0] = "-I";
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                objectArray2[1] = file2.getAbsolutePath();
                builder.add(objectArray2);
            }
            File manifestFile = config.getManifestFile();
            Preconditions.checkNotNull((Object)manifestFile);
            builder.add((Object[])new String[]{"--manifest", manifestFile.getAbsolutePath()});
            File file = config.getResourceOutputApk();
            if (file == null) {
                File tmpOutput;
                try {
                    tmpOutput = File.createTempFile("aapt-", "-out");
                    tmpOutput.deleteOnExit();
                }
                catch (IOException e4) {
                    throw (Throwable)new AaptException("No output apk defined and failed to create tmp file", e4);
                }
                file = tmpOutput;
            }
            File file3 = resourceOutputApk = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"resourceOutputApk");
            FileUtils.mkdirs((File)file3.getParentFile());
            builder.add((Object[])new String[]{"-o", resourceOutputApk.getAbsolutePath()});
            if (!config.getResourceDirs().isEmpty()) {
                try {
                    int n3;
                    if (config.isListResourceFiles()) {
                        File file4 = config.getIntermediateDir();
                        if (file4 == null) {
                            Intrinsics.throwNpe();
                        }
                        File resourceListFile = new File(file4, "resources-list-for-" + resourceOutputApk.getName() + ".txt");
                        FileUtils.deleteIfExists((File)resourceListFile);
                        Files.createDirectories(config.getIntermediateDir().toPath(), new FileAttribute[0]);
                        for (Object dir : config.getResourceDirs()) {
                            Closeable bl = new FileOutputStream(resourceListFile);
                            boolean bl2 = false;
                            Throwable throwable = null;
                            try {
                                FileOutputStream fos = (FileOutputStream)bl;
                                boolean bl3 = false;
                                Closeable closeable = new PrintWriter(fos);
                                n3 = 0;
                                objectArray = null;
                                try {
                                    void $this$filterTo$iv$iv;
                                    File[] $this$filter$iv;
                                    PrintWriter pw = (PrintWriter)closeable;
                                    boolean bl4 = false;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)((File)dir).listFiles(), (String)"dir.listFiles()");
                                    boolean $i$f$filter = false;
                                    Object object = $this$filter$iv;
                                    Collection destination$iv$iv22 = new ArrayList();
                                    boolean $i$f$filterTo22 = false;
                                    void var22_57 = $this$filterTo$iv$iv;
                                    int n4 = ((void)var22_57).length;
                                    for (int i3 = 0; i3 < n4; ++i3) {
                                        void element$iv$iv;
                                        void it = element$iv$iv = var22_57[i3];
                                        boolean bl5 = false;
                                        void v5 = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                                        if (!v5.isFile()) continue;
                                        destination$iv$iv22.add(element$iv$iv);
                                    }
                                    Iterable $this$sortedBy$iv = (List)destination$iv$iv22;
                                    boolean $i$f$sortedBy = false;
                                    object = $this$sortedBy$iv;
                                    boolean destination$iv$iv22 = false;
                                    Comparator $i$f$filterTo22 = new Comparator<T>(){

                                        public final int compare(T a4, T b4) {
                                            boolean bl = false;
                                            File it = (File)a4;
                                            boolean bl2 = false;
                                            File file = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                                            it = (File)b4;
                                            Comparable comparable = (Comparable)((Object)file.getPath());
                                            bl2 = false;
                                            File file2 = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                                            String string = file2.getPath();
                                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                                        }
                                    };
                                    Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)object, (Comparator)$i$f$filterTo22);
                                    boolean $i$f$forEach2 = false;
                                    for (Object element$iv : $this$forEach$iv2) {
                                        File it = (File)element$iv;
                                        boolean bl6 = false;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        File file5 = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"it");
                                        pw.print(stringBuilder.append(file5.getAbsolutePath()).append(" ").toString());
                                    }
                                    pw = Unit.INSTANCE;
                                }
                                catch (Throwable pw) {
                                    objectArray = pw;
                                    throw pw;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray);
                                }
                                fos = Unit.INSTANCE;
                            }
                            catch (Throwable fos) {
                                throwable = fos;
                                throw fos;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)bl, (Throwable)throwable);
                            }
                        }
                        builder.add((Object[])new String[]{"-R", "@" + resourceListFile.getAbsolutePath()});
                        break block57;
                    }
                    for (File dir : config.getResourceDirs()) {
                        Object $this$filterTo$iv$iv;
                        File[] $this$filter$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)dir.listFiles(), (String)"dir.listFiles()");
                        boolean $i$f$filter = false;
                        File[] fileArray = $this$filter$iv;
                        Collection destination$iv$iv32 = new ArrayList();
                        boolean $i$f$filterTo32 = false;
                        void bl3 = $this$filterTo$iv$iv;
                        int n5 = ((void)bl3).length;
                        for (n3 = 0; n3 < n5; ++n3) {
                            void element$iv$iv;
                            void it = element$iv$iv = bl3[n3];
                            boolean bl = false;
                            void v8 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                            if (!v8.isFile()) continue;
                            destination$iv$iv32.add(element$iv$iv);
                        }
                        Iterable $this$sortedBy$iv = (List)destination$iv$iv32;
                        boolean $i$f$sortedBy = false;
                        $this$filterTo$iv$iv = $this$sortedBy$iv;
                        boolean destination$iv$iv32 = false;
                        Comparator $i$f$filterTo32 = new Comparator<T>(){

                            public final int compare(T a4, T b4) {
                                boolean bl = false;
                                File it = (File)a4;
                                boolean bl2 = false;
                                File file = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                                it = (File)b4;
                                Comparable comparable = (Comparable)((Object)file.getPath());
                                bl2 = false;
                                File file2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                                String string = file2.getPath();
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                            }
                        };
                        Iterable $this$forEach$iv3 = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv, (Comparator)$i$f$filterTo32);
                        boolean $i$f$forEach3 = false;
                        $this$filterTo$iv$iv = $this$forEach$iv3.iterator();
                        while ($this$filterTo$iv$iv.hasNext()) {
                            Object element$iv = $this$filterTo$iv$iv.next();
                            File it = (File)element$iv;
                            boolean bl = false;
                            Object[] objectArray3 = new String[2];
                            objectArray3[0] = "-R";
                            File file6 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"it");
                            objectArray3[1] = file6.getAbsolutePath();
                            builder.add(objectArray3);
                        }
                    }
                }
                catch (IOException e5) {
                    throw (Throwable)new AaptException("Failed to walk paths " + Joiner.on((char)File.pathSeparatorChar).join((Iterable)config.getResourceDirs()), e5);
                }
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            builder.add((Object[])new String[]{"--java", config.getSourceOutputDir().getAbsolutePath()});
        }
        if (config.getProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()});
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard-main-dex", config.getMainDexListProguardOutputFile().getAbsolutePath()});
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                String splitter = File.pathSeparator;
                builder.add((Object[])new String[]{"--split", resourceOutputApk.toString() + "_" + split + splitter + split});
            }
        }
        if (!config.getVariantType().isTestComponent() && config.getCustomPackageForR() != null) {
            builder.add((Object[])new String[]{"--custom-package", config.getCustomPackageForR()});
        }
        boolean generateFinalIds = true;
        if (config.getVariantType().isAar()) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        builder.add((Object[])new String[]{"-0", "apk"});
        Collection<String> noCompressList = Objects.requireNonNull(config.getOptions()).getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                if (!Strings.isNullOrEmpty((String)noCompress)) {
                    builder.add((Object[])new String[]{"-0", noCompress});
                    continue;
                }
                builder.add((Object)"--no-compress");
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll((Iterable)additionalParameters);
        }
        ArrayList resourceConfigs = new ArrayList((Collection)config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        Iterable<String> iterable = densityResSplits = config.getSplits() != null ? AaptUtils.getDensityResConfigs((Iterable)config.getSplits()) : (Iterable<String>)ImmutableList.of();
        if ((preferredDensity != null || densityResSplits.iterator().hasNext()) && !densityResourceConfigs.isEmpty()) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle";
            objectArray = new Object[]{Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new AaptException(string4);
        }
        if (densityResourceConfigs.size() > 1) {
            throw (Throwable)new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.");
        }
        if (!otherResourceConfigs.isEmpty() && config.getSplits() != null) {
            Iterable<String> nonDensitySplits = AaptUtils.getNonDensityResConfigs((Iterable)config.getSplits());
            otherResourceConfigs.addAll(Lists.newArrayList(nonDensitySplits));
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.add((Object[])new String[]{"-c", joiner.join((Iterable)otherResourceConfigs)});
        }
        if (preferredDensity != null) {
            builder.add((Object[])new String[]{"--preferred-density", preferredDensity});
        }
        if (config.getSymbolOutputDir() != null) {
            File rDotTxt = new File(config.getSymbolOutputDir(), "R.txt");
            builder.add((Object[])new String[]{"--output-text-symbols", rDotTxt.getAbsolutePath()});
        }
        if (config.getPackageId() != null) {
            if (config.getAllowReservedPackageId()) {
                builder.add((Object)"--allow-reserved-package-id");
            }
            builder.add((Object[])new String[]{"--package-id", "0x" + Integer.toHexString(config.getPackageId())});
            for (File dependentFeature : config.getDependentFeatures()) {
                Object[] objectArray4 = new String[2];
                objectArray4[0] = "-I";
                File file = dependentFeature;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dependentFeature");
                objectArray4[1] = file.getAbsolutePath();
                builder.add(objectArray4);
            }
        } else if (!config.getDependentFeatures().isEmpty()) {
            throw (Throwable)new AaptException("Dependent features configured but no package ID was set.");
        }
        builder.add((Object)"--no-version-vectors");
        if (config.getUseConditionalKeepRules()) {
            builder.add((Object)"--proguard-conditional-keep-rules");
        }
        if (config.isStaticLibrary()) {
            builder.add((Object)"--static-lib");
            if (!config.getStaticLibraryDependencies().isEmpty()) {
                throw (Throwable)new AaptException("Static libraries to link against should be passed as imports");
            }
        } else {
            UnmodifiableIterator unmodifiableIterator = config.getStaticLibraryDependencies().iterator();
            while (unmodifiableIterator.hasNext()) {
                File file;
                File file7 = file = (File)unmodifiableIterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"file");
                builder.add((Object)file7.getAbsolutePath());
            }
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }
}

