/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.e;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.m.a.a.b.b0;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.a;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.shaking.f0;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GenerateMainDexListCommand
extends BaseCommand {
    static final String j = String.join((CharSequence)"\n", b0.a("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --lib <file>             # Add <file> as a library resource.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));
    private final List<ProguardConfigurationRule> e;
    private final StringConsumer f;
    private final GraphConsumer g;
    private final DexItemFactory h;
    private final Reporter i;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder parse(String[] stringArray) {
        Builder builder = GenerateMainDexListCommand.builder();
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string = stringArray[i3].trim();
            if (string.length() == 0) continue;
            if (string.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (string.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (string.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(stringArray[++i3], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(stringArray[++i3], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(stringArray[++i3], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(stringArray[++i3], new String[0]));
                continue;
            }
            if (string.startsWith("--")) {
                builder.a().error(new StringDiagnostic(com.android.tools.r8.e.a("Unknown option: ", string), a.e));
            }
            builder.addProgramFiles(Paths.get(string, new String[0]));
        }
        return builder;
    }

    private GenerateMainDexListCommand(DexItemFactory dexItemFactory, AndroidApp androidApp, List<ProguardConfigurationRule> list, StringConsumer stringConsumer, GraphConsumer graphConsumer, Reporter reporter) {
        super(androidApp);
        this.h = dexItemFactory;
        this.e = list;
        this.f = stringConsumer;
        this.g = graphConsumer;
        this.i = reporter;
    }

    private GenerateMainDexListCommand(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.h = new DexItemFactory();
        this.e = b0.e();
        this.f = null;
        this.g = null;
        this.i = new Reporter();
    }

    public StringConsumer getMainDexListConsumer() {
        return this.f;
    }

    Reporter a() {
        return this.i;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internalOptions;
        InternalOptions internalOptions2 = internalOptions;
        internalOptions2(this.h, this.i);
        internalOptions2.programConsumer = ClassFileConsumer.emptyConsumer();
        internalOptions2.E = this.e;
        internalOptions2.O = this.f;
        internalOptions.mainDexKeptGraphConsumer = this.g;
        internalOptions.minimalMainDex = internalOptions.debug;
        internalOptions.enableEnumValueOptimization = false;
        internalOptions.enableInlining = false;
        return internalOptions;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final DexItemFactory f = new DexItemFactory();
        private final List<ProguardConfigurationSource> g = new ArrayList<ProguardConfigurationSource>();
        private StringConsumer h = null;
        private GraphConsumer i = null;

        private Builder() {
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        public Builder addMainDexRulesFiles(Path ... pathArray) {
            Builder builder = this;
            builder.a(() -> {
                for (Path path : pathArray) {
                    this.g.add(new f0(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRulesFiles(List<Path> list) {
            Builder builder = this;
            builder.a(() -> {
                list = list.iterator();
                while (list.hasNext()) {
                    Path path = (Path)list.next();
                    this.g.add(new f0(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRules(List<String> list, Origin origin) {
            Builder builder = this;
            builder.a(() -> this.g.add(new ProguardConfigurationSourceStrings(list, Paths.get(".", new String[0]), origin)));
            return builder;
        }

        public Builder setMainDexListOutputPath(Path path) {
            this.h = new StringConsumer.FileConsumer(path);
            return this;
        }

        public Builder setMainDexListConsumer(StringConsumer stringConsumer) {
            this.h = stringConsumer;
            return this;
        }

        public Builder setMainDexKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.i = graphConsumer;
            return this;
        }

        @Override
        protected BaseCommand b() {
            GenerateMainDexListCommand generateMainDexListCommand;
            if (!this.isPrintHelp() && !this.isPrintVersion()) {
                GenerateMainDexListCommand generateMainDexListCommand2;
                List<Object> list;
                if (this.g.isEmpty()) {
                    list = b0.e();
                } else {
                    ProguardConfigurationParser proguardConfigurationParser = new ProguardConfigurationParser(this.f, this.a());
                    proguardConfigurationParser.a(this.g);
                    list = proguardConfigurationParser.getConfig().getRules();
                }
                generateMainDexListCommand = generateMainDexListCommand2;
                generateMainDexListCommand2 = new GenerateMainDexListCommand(this.f, this.getAppBuilder().build(), list, this.h, this.i, this.a());
            } else {
                GenerateMainDexListCommand generateMainDexListCommand3;
                generateMainDexListCommand = generateMainDexListCommand3;
                generateMainDexListCommand3 = new GenerateMainDexListCommand(this.isPrintHelp(), this.isPrintVersion());
            }
            return generateMainDexListCommand;
        }

        @Override
        BaseCommand.Builder c() {
            return this;
        }
    }
}

