/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.AaptV2CommandBuilder;
import com.android.ide.common.resources.CompileResourceRequest;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;

public class Aapt2DaemonUtil {
    public static final String DAEMON_MODE_COMMAND = "m";

    public static void requestCompile(Writer writer, CompileResourceRequest command) throws IOException {
        Aapt2DaemonUtil.request(writer, "c", AaptV2CommandBuilder.makeCompileCommand(command));
    }

    public static void requestLink(Writer writer, AaptPackageConfig command) throws IOException {
        ImmutableList<String> args;
        try {
            args = AaptV2CommandBuilder.makeLinkCommand(command);
        }
        catch (AaptException e4) {
            throw new IOException("Unable to make AAPT link command.", e4);
        }
        Aapt2DaemonUtil.request(writer, "l", args);
    }

    public static void requestShutdown(Writer writer) throws IOException {
        Aapt2DaemonUtil.request(writer, "quit", Collections.emptyList());
    }

    private static void request(Writer writer, String command, Iterable<String> args) throws IOException {
        writer.write(command);
        writer.write(10);
        for (String s3 : args) {
            writer.write(s3);
            writer.write(10);
        }
        writer.write(10);
        writer.write(10);
        writer.flush();
    }
}

