/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.builder.packaging.JarCreator;
import com.android.utils.PathUtils;
import com.android.zipflinger.Entry;
import com.android.zipflinger.FileSource;
import com.android.zipflinger.InputStreamSource;
import com.android.zipflinger.NoCopyByteArrayOutputStream;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipSource;
import com.google.common.collect.ImmutableSortedMap;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JarFlinger
implements JarCreator {
    private final ZipArchive zipArchive;
    private final Predicate<String> filter;
    private int compressionLevel = -1;

    public JarFlinger(Path jarFile) throws IOException {
        this(jarFile, null);
    }

    public JarFlinger(Path jarFile, Predicate<String> filter) throws IOException {
        Files.deleteIfExists(jarFile);
        this.zipArchive = new ZipArchive(jarFile.toFile());
        this.filter = filter;
    }

    @Override
    public void addDirectory(Path directory) throws IOException {
        this.addDirectory(directory, this.filter, null, null);
    }

    @Override
    public void addDirectory(final Path directory, final Predicate<String> filterOverride, JarCreator.Transformer transformer, final JarCreator.Relocator relocator) throws IOException {
        final ImmutableSortedMap.Builder candidateFiles = ImmutableSortedMap.naturalOrder();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String entryPath = PathUtils.toSystemIndependentPath((Path)directory.relativize(file));
                if (filterOverride != null && !filterOverride.test(entryPath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (relocator != null) {
                    entryPath = relocator.relocate(entryPath);
                }
                candidateFiles.put((Object)entryPath, (Object)file);
                return FileVisitResult.CONTINUE;
            }
        });
        ImmutableSortedMap sortedFiles = candidateFiles.build();
        for (Map.Entry entry : sortedFiles.entrySet()) {
            String entryPath = (String)entry.getKey();
            if (transformer != null) {
                BufferedInputStream is = new BufferedInputStream(Files.newInputStream((Path)entry.getValue(), new OpenOption[0]));
                Throwable throwable = null;
                try {
                    InputStream is2 = transformer.filter(entryPath, is);
                    if (is2 == null) continue;
                    InputStreamSource source = new InputStreamSource(is2, entryPath, this.compressionLevel);
                    this.zipArchive.add((Source)source);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                    continue;
                }
            }
            FileSource source = new FileSource(((Path)entry.getValue()).toFile(), entryPath, this.compressionLevel);
            this.zipArchive.add((Source)source);
        }
    }

    @Override
    public void addJar(Path file) throws IOException {
        this.addJar(file, this.filter, null);
    }

    @Override
    public void addJar(Path path, Predicate<String> filterOverride, JarCreator.Relocator relocator) throws IOException {
        File file = path.toFile();
        ZipSource source = new ZipSource(file);
        Map entries2 = source.entries();
        for (Entry entry : entries2.values()) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (filterOverride != null && !filterOverride.test(name)) continue;
            if (relocator != null) {
                name = relocator.relocate(name);
            }
            if (name.contains("../")) {
                throw new InvalidPathException(name, "Entry name contains invalid characters");
            }
            source.select(entry.getName(), name);
        }
        this.zipArchive.add(source);
    }

    @Override
    public void addFile(String entryPath, Path path) throws IOException {
        FileSource source = new FileSource(path.toFile(), entryPath, this.compressionLevel);
        this.zipArchive.add((Source)source);
    }

    @Override
    public void addEntry(String entryPath, InputStream input) throws IOException {
        InputStreamSource source = new InputStreamSource(input, entryPath, this.compressionLevel);
        this.zipArchive.add((Source)source);
    }

    @Override
    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public void close() throws IOException {
        this.zipArchive.close();
    }

    @Override
    public void setManifestProperties(Map<String, String> properties) throws IOException {
        Manifest manifest = new Manifest();
        Attributes global = manifest.getMainAttributes();
        global.put(Attributes.Name.MANIFEST_VERSION, "1.0.0");
        properties.forEach((attributeName, attributeValue) -> global.put(new Attributes.Name((String)attributeName), attributeValue));
        NoCopyByteArrayOutputStream os = new NoCopyByteArrayOutputStream(200);
        manifest.write((OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.buf(), 0, os.getCount());
        InputStreamSource source = new InputStreamSource((InputStream)is, "META-INF/MANIFEST.MF", 0);
        this.zipArchive.add((Source)source);
    }
}

