/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.ssa.BasicRegisterMapper;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.BitIntSet;
import java.util.BitSet;

public class FirstFitAllocator
extends RegisterAllocator {
    private static final boolean PRESLOT_PARAMS = true;
    private final BitSet mapped;

    public FirstFitAllocator(SsaMethod ssaMeth, InterferenceGraph interference) {
        super(ssaMeth, interference);
        this.mapped = new BitSet(ssaMeth.getRegCount());
    }

    @Override
    public boolean wantsParamsMovedHigh() {
        return true;
    }

    @Override
    public RegisterMapper allocateRegisters() {
        int oldRegCount = this.ssaMeth.getRegCount();
        BasicRegisterMapper mapper = new BasicRegisterMapper(oldRegCount);
        int nextNewRegister = 0;
        nextNewRegister = this.ssaMeth.getParamWidth();
        for (int i3 = 0; i3 < oldRegCount; ++i3) {
            if (this.mapped.get(i3)) continue;
            int maxCategory = this.getCategoryForSsaReg(i3);
            BitIntSet current = new BitIntSet(oldRegCount);
            this.interference.mergeInterferenceSet(i3, current);
            boolean isPreslotted = false;
            int newReg = 0;
            if (this.isDefinitionMoveParam(i3)) {
                NormalSsaInsn defInsn = (NormalSsaInsn)this.ssaMeth.getDefinitionForRegister(i3);
                newReg = this.paramNumberFromMoveParam(defInsn);
                mapper.addMapping(i3, newReg, maxCategory);
                isPreslotted = true;
            } else {
                mapper.addMapping(i3, nextNewRegister, maxCategory);
                newReg = nextNewRegister;
            }
            for (int j3 = i3 + 1; j3 < oldRegCount; ++j3) {
                if (this.mapped.get(j3) || this.isDefinitionMoveParam(j3) || current.has(j3) || isPreslotted && maxCategory < this.getCategoryForSsaReg(j3)) continue;
                this.interference.mergeInterferenceSet(j3, current);
                maxCategory = Math.max(maxCategory, this.getCategoryForSsaReg(j3));
                mapper.addMapping(j3, newReg, maxCategory);
                this.mapped.set(j3);
            }
            this.mapped.set(i3);
            if (isPreslotted) continue;
            nextNewRegister += maxCategory;
        }
        return mapper;
    }

    private int paramNumberFromMoveParam(NormalSsaInsn ndefInsn) {
        CstInsn origInsn = (CstInsn)ndefInsn.getOriginalRopInsn();
        return ((CstInteger)origInsn.getConstant()).getValue();
    }
}

