/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.DirectoryEntry;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.ZipCentralDirectory;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class IncrementalRelativeFileSets {
    private IncrementalRelativeFileSets() {
    }

    @Deprecated
    public static ImmutableMap<RelativeFile, FileStatus> fromDirectory(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        return ImmutableMap.copyOf((Map)Maps.asMap(RelativeFiles.fromDirectory(directory), (Function)Functions.constant((Object)FileStatus.NEW)));
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip) throws IOException {
        return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip, FileStatus status) throws IOException {
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile(): %s", (Object)zip);
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZip(new ZipCentralDirectory(zip)), f3 -> status)).build();
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(ZipCentralDirectory zip) throws IOException {
        return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(ZipCentralDirectory zip, FileStatus status) throws IOException {
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZip(zip), f3 -> status)).build();
    }

    public static Map<RelativeFile, FileStatus> fromZip(ZipCentralDirectory zipCentralDirectory, KeyedFileCache cache, Set<Runnable> cacheUpdates) throws IOException {
        File zipFile = zipCentralDirectory.getFile();
        File oldFile = cache.get(zipFile);
        if (oldFile == null) {
            if (!zipFile.isFile()) {
                return ImmutableMap.of();
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.add(zipCentralDirectory)));
            return IncrementalRelativeFileSets.fromZip(zipCentralDirectory, FileStatus.NEW);
        }
        if (!zipFile.isFile()) {
            ZipCentralDirectory oldCdr = new ZipCentralDirectory(oldFile);
            Collection<DirectoryEntry> entries2 = oldCdr.getEntries().values();
            HashMap map = Maps.newHashMapWithExpectedSize((int)entries2.size());
            for (DirectoryEntry entry : entries2) {
                map.put(new RelativeFile(zipFile, entry.getName()), FileStatus.REMOVED);
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.remove(zipFile)));
            return Collections.unmodifiableMap(map);
        }
        HashMap result = Maps.newHashMap();
        try (Closer closer = Closer.create();){
            String path;
            Map<String, DirectoryEntry> newEntries = zipCentralDirectory.getEntries();
            Map<String, DirectoryEntry> oldEntries = new ZipCentralDirectory(oldFile).getEntries();
            for (DirectoryEntry entry : newEntries.values()) {
                path = entry.getName();
                RelativeFile newRelative = new RelativeFile(zipFile, path);
                DirectoryEntry oldEntry = oldEntries.get(path);
                if (oldEntry == null) {
                    result.put(newRelative, FileStatus.NEW);
                    continue;
                }
                if (oldEntry.getCrc32() == entry.getCrc32() && oldEntry.getSize() == entry.getSize()) continue;
                result.put(newRelative, FileStatus.CHANGED);
            }
            for (DirectoryEntry entry : oldEntries.values()) {
                path = entry.getName();
                RelativeFile oldRelative = new RelativeFile(zipFile, path);
                DirectoryEntry newEntry = newEntries.get(path);
                if (newEntry != null) continue;
                result.put(oldRelative, FileStatus.REMOVED);
            }
        }
        cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.add(zipCentralDirectory)));
        return Collections.unmodifiableMap(result);
    }

    public static ImmutableMap<RelativeFile, FileStatus> union(Iterable<ImmutableMap<RelativeFile, FileStatus>> sets) {
        HashMap map = Maps.newHashMap();
        for (ImmutableMap<RelativeFile, FileStatus> set : sets) {
            map.putAll(set);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    @Deprecated
    public static ImmutableMap<RelativeFile, FileStatus> fromZipsAndDirectories(Iterable<File> files) throws IOException {
        HashSet sets = Sets.newHashSet();
        for (File f3 : files) {
            if (f3.isFile()) {
                sets.add(IncrementalRelativeFileSets.fromZip(f3));
                continue;
            }
            sets.add(IncrementalRelativeFileSets.fromDirectory(f3));
        }
        return IncrementalRelativeFileSets.union(sets);
    }

    @Deprecated
    public static ImmutableMap<RelativeFile, FileStatus> makeFromBaseFiles(Collection<File> baseFiles, Map<File, FileStatus> updates, KeyedFileCache cache, Set<Runnable> cacheUpdates, FileDeletionPolicy fileDeletionPolicy) throws IOException {
        for (File f3 : baseFiles) {
            Preconditions.checkArgument((boolean)f3.exists(), (String)"!f.exists(): %s", (Object)f3);
        }
        HashMap relativeUpdates = Maps.newHashMap();
        block1: for (Map.Entry<File, FileStatus> fileUpdate : updates.entrySet()) {
            File file = fileUpdate.getKey();
            FileStatus status = fileUpdate.getValue();
            if (fileDeletionPolicy == FileDeletionPolicy.DISALLOW_FILE_DELETIONS) {
                Preconditions.checkState((status != FileStatus.REMOVED ? 1 : 0) != 0, (Object)String.format("Changes include a deleted file ('%s'), which is not allowed.", file.getAbsolutePath()));
            }
            if (baseFiles.contains(file)) {
                relativeUpdates.putAll(IncrementalRelativeFileSets.fromZip(new ZipCentralDirectory(file), cache, cacheUpdates));
                continue;
            }
            if (file.isDirectory()) continue;
            for (File possibleBaseDirectory = file.getParentFile(); possibleBaseDirectory != null; possibleBaseDirectory = possibleBaseDirectory.getParentFile()) {
                if (!baseFiles.contains(possibleBaseDirectory)) continue;
                relativeUpdates.put(new RelativeFile(possibleBaseDirectory, file), status);
                continue block1;
            }
        }
        return ImmutableMap.copyOf((Map)relativeUpdates);
    }

    @Deprecated
    public static enum FileDeletionPolicy {
        ASSUME_NO_DELETED_DIRECTORIES,
        DISALLOW_FILE_DELETIONS;

    }
}

