/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.e;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.O;
import com.android.tools.r8.graph.U;
import com.android.tools.r8.graph.W;
import com.android.tools.r8.graph.a0;
import com.android.tools.r8.graph.e0;
import com.android.tools.r8.graph.g0;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class KeepReason {
    static KeepReason annotatedOn(O o4) {
        return new AnnotatedOn(o4);
    }

    static KeepReason dueToKeepRule(ProguardKeepRuleBase proguardKeepRuleBase) {
        if (proguardKeepRuleBase instanceof ProguardKeepRule) {
            return new DueToKeepRule(proguardKeepRuleBase);
        }
        if (proguardKeepRuleBase instanceof ProguardIfRule) {
            proguardKeepRuleBase = (ProguardIfRule)proguardKeepRuleBase;
            return new DueToConditionalKeepRule(proguardKeepRuleBase, ((ProguardIfRule)proguardKeepRuleBase).getPreconditions());
        }
        throw new e("Unexpected proguard keep rule: " + proguardKeepRuleBase);
    }

    static KeepReason dueToConditionalKeepRule(ProguardKeepRuleBase proguardKeepRuleBase, e0 e02) {
        return new DueToConditionalKeepRule(proguardKeepRuleBase, e02);
    }

    static KeepReason dueToProguardCompatibilityKeepRule(ProguardKeepRule proguardKeepRule) {
        return new DueToProguardCompatibilityKeepRule(proguardKeepRule);
    }

    static KeepReason instantiatedIn(U u4) {
        return new InstatiatedIn(u4);
    }

    public static KeepReason invokedViaSuperFrom(U u4) {
        return new InvokedViaSuper(u4);
    }

    public static KeepReason reachableFromLiveType(g0 g02) {
        return new ReachableFromLiveType(g02);
    }

    public static KeepReason invokedFrom(U u4) {
        return new InvokedFrom(u4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(U u4) {
        return new InvokedFromLambdaCreatedIn(u4);
    }

    public static KeepReason isLibraryMethod(g0 g02, g0 g03) {
        return new IsLibraryMethod(g02, g03);
    }

    public static KeepReason fieldReferencedIn(U u4) {
        return new ReferencedFrom(u4);
    }

    public static KeepReason referencedInAnnotation(W w4) {
        return new ReferencedInAnnotation(w4);
    }

    public static KeepReason targetedBySuperFrom(U u4) {
        return new TargetedBySuper(u4);
    }

    public static KeepReason reflectiveUseIn(U u4) {
        return new ReflectiveUseFrom(u4);
    }

    public static KeepReason methodHandleReferencedIn(U u4) {
        return new MethodHandleReferencedFrom(u4);
    }

    public static KeepReason overridesMethod(U u4) {
        return new OverridesMethod(u4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(Enqueuer var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    public boolean isDueToProguardCompatibility() {
        return false;
    }

    public boolean isDueToConditionalKeepRule() {
        return false;
    }

    public boolean isInstantiatedIn() {
        return false;
    }

    public InstatiatedIn asInstantiatedIn() {
        return null;
    }

    public ProguardKeepRuleBase getProguardKeepRule() {
        return null;
    }

    public Collection<e0> getPreconditions() {
        throw new e();
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(U u4) {
            super(u4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final O holder;

        private AnnotatedOn(O o4) {
            this.holder = o4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            if (this.holder.h()) {
                return enqueuer.getClassGraphNode(this.holder.e().c);
            }
            if (this.holder.i()) {
                return enqueuer.getFieldGraphNode(this.holder.f().a);
            }
            if (!$assertionsDisabled && !this.holder.j()) {
                throw new AssertionError();
            }
            return enqueuer.getMethodGraphNode(this.holder.g().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final W holder;

        private ReferencedInAnnotation(W w4) {
            this.holder = w4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final g0 implementer;
        private final g0 libraryType;

        private IsLibraryMethod(g0 g02, g0 g03) {
            this.implementer = g02;
            this.libraryType = g03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final g0 type;

        private ReachableFromLiveType(g0 g02) {
            this.type = g02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        private InvokedFrom(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(U u4) {
            super(u4);
        }

        @Override
        public boolean isInstantiatedIn() {
            return true;
        }

        @Override
        public InstatiatedIn asInstantiatedIn() {
            return this;
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static class OverridesMethod
    extends BasedOnOtherMethod {
        public OverridesMethod(U u4) {
            super(u4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.p;
        }

        @Override
        String getKind() {
            return "overrides";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final U method;

        private BasedOnOtherMethod(U u4) {
            this.method = u4;
        }

        abstract String getKind();

        public a0 getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getMethodGraphNode(this.method.a);
        }
    }

    private static class DueToConditionalKeepRule
    extends DueToKeepRule {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Set<e0> preconditions;

        public DueToConditionalKeepRule(ProguardKeepRuleBase proguardKeepRuleBase, e0 e02) {
            this(proguardKeepRuleBase, Collections.singleton(e02));
            if (!$assertionsDisabled && e02 == null) {
                throw new AssertionError();
            }
        }

        public DueToConditionalKeepRule(ProguardKeepRuleBase proguardKeepRuleBase, Set<e0> set) {
            super(proguardKeepRuleBase);
            if (!$assertionsDisabled && set.isEmpty()) {
                throw new AssertionError();
            }
            this.preconditions = set;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        public Set<e0> getPreconditions() {
            return this.preconditions;
        }

        @Override
        public boolean isDueToConditionalKeepRule() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.c;
        }
    }

    private static class DueToProguardCompatibilityKeepRule
    extends DueToKeepRule {
        private DueToProguardCompatibilityKeepRule(ProguardKeepRule proguardKeepRule) {
            super(proguardKeepRule);
        }

        @Override
        public a.a edgeKind() {
            return a.a.b;
        }

        @Override
        public boolean isDueToProguardCompatibility() {
            return true;
        }
    }

    private static class DueToKeepRule
    extends KeepReason {
        final ProguardKeepRuleBase keepRule;

        private DueToKeepRule(ProguardKeepRuleBase proguardKeepRuleBase) {
            this.keepRule = proguardKeepRuleBase;
        }

        @Override
        public a.a edgeKind() {
            return a.a.a;
        }

        @Override
        public boolean isDueToKeepRule() {
            return true;
        }

        @Override
        public ProguardKeepRuleBase getProguardKeepRule() {
            return this.keepRule;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getKeepRuleGraphNode(this.keepRule);
        }
    }
}

