/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.h;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.a;
import com.android.tools.r8.s.a.a.b.W;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.S;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.e;
import com.android.tools.r8.utils.t0;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GenerateMainDexListCommand
extends BaseCommand {
    static final String j = String.join((CharSequence)"\n", W.a("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --lib <file>             # Add <file> as a library resource.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));
    private final List<ProguardConfigurationRule> e;
    private final StringConsumer f;
    private final GraphConsumer g;
    private final com.android.tools.r8.graph.W h;
    private final t0 i;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder parse(String[] stringArray) {
        Builder builder = GenerateMainDexListCommand.builder();
        for (int i4 = 0; i4 < stringArray.length; ++i4) {
            String string = stringArray[i4].trim();
            if (string.length() == 0) continue;
            if (string.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (string.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (string.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.startsWith("--")) {
                builder.a().error(new StringDiagnostic(com.android.tools.r8.h.a("Unknown option: ", string), a.a));
            }
            builder.addProgramFiles(Paths.get(string, new String[0]));
        }
        return builder;
    }

    private GenerateMainDexListCommand(com.android.tools.r8.graph.W w4, e e4, List<ProguardConfigurationRule> list, StringConsumer stringConsumer, GraphConsumer graphConsumer, t0 t02) {
        super(e4);
        this.h = w4;
        this.e = list;
        this.f = stringConsumer;
        this.g = graphConsumer;
        this.i = t02;
    }

    private GenerateMainDexListCommand(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.h = new com.android.tools.r8.graph.W();
        this.e = W.e();
        this.f = null;
        this.g = null;
        this.i = new t0();
    }

    public StringConsumer getMainDexListConsumer() {
        return this.f;
    }

    t0 a() {
        return this.i;
    }

    @Override
    S getInternalOptions() {
        S s4;
        S s5 = s4;
        GenerateMainDexListCommand generateMainDexListCommand = w4;
        GenerateMainDexListCommand generateMainDexListCommand2 = w4;
        GenerateMainDexListCommand generateMainDexListCommand3 = w4;
        GenerateMainDexListCommand generateMainDexListCommand4 = w4;
        com.android.tools.r8.graph.W w4 = generateMainDexListCommand4.h;
        s5(w4, generateMainDexListCommand4.i);
        s5.d = ClassFileConsumer.emptyConsumer();
        s5.K0 = generateMainDexListCommand3.e;
        s5.Y0 = generateMainDexListCommand2.f;
        s4.f1 = generateMainDexListCommand.g;
        s4.L0 = s4.I0;
        s4.Q = false;
        s4.t = false;
        return s4;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final com.android.tools.r8.graph.W f;
        private final List<ProguardConfigurationSource> g;
        private StringConsumer h;
        private GraphConsumer i;

        private Builder() {
            ArrayList arrayList;
            com.android.tools.r8.graph.W w4;
            Object object = w4;
            w4 = new com.android.tools.r8.graph.W();
            v1.f = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.g = object;
            v1.h = null;
            v1.i = null;
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            ArrayList arrayList;
            com.android.tools.r8.graph.W w4;
            Object object = w4;
            w4 = new com.android.tools.r8.graph.W();
            v1.f = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.g = object;
            v1.h = null;
            v1.i = null;
        }

        public Builder addMainDexRulesFiles(Path ... pathArray) {
            Builder builder = this;
            builder.a(() -> {
                for (Path path : pathArray) {
                    this.g.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRulesFiles(List<Path> list) {
            Builder builder = this;
            builder.a(() -> {
                list = list.iterator();
                while (list.hasNext()) {
                    Path path = (Path)list.next();
                    this.g.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRules(List<String> list, Origin origin) {
            Builder builder = this;
            builder.a(() -> this.g.add(new ProguardConfigurationSourceStrings(list, Paths.get(".", new String[0]), origin)));
            return builder;
        }

        public Builder setMainDexListOutputPath(Path path) {
            this.h = new StringConsumer.FileConsumer(path);
            return this;
        }

        public Builder setMainDexListConsumer(StringConsumer stringConsumer) {
            this.h = stringConsumer;
            return this;
        }

        public Builder setMainDexKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.i = graphConsumer;
            return this;
        }

        @Override
        protected BaseCommand b() {
            GenerateMainDexListCommand generateMainDexListCommand;
            if (!((BaseCommand.Builder)((Object)w4)).isPrintHelp() && !((BaseCommand.Builder)((Object)w4)).isPrintVersion()) {
                GenerateMainDexListCommand generateMainDexListCommand2;
                List<ProguardConfigurationRule> list;
                if (((Builder)((Object)w4)).g.isEmpty()) {
                    list = W.e();
                } else {
                    Builder builder = w4;
                    list = builder.f;
                    ProguardConfigurationParser proguardConfigurationParser = new ProguardConfigurationParser((com.android.tools.r8.graph.W)((Object)list), builder.a());
                    proguardConfigurationParser.parse(((Builder)((Object)w4)).g);
                    list = proguardConfigurationParser.getConfig().getRules();
                }
                generateMainDexListCommand = generateMainDexListCommand2;
                Builder builder = w4;
                com.android.tools.r8.graph.W w4 = builder.f;
                e e4 = builder.getAppBuilder().a();
                StringConsumer stringConsumer = builder.h;
                GraphConsumer graphConsumer = builder.i;
                t0 t02 = builder.a();
                generateMainDexListCommand2 = new GenerateMainDexListCommand(w4, e4, list, stringConsumer, graphConsumer, t02);
            } else {
                GenerateMainDexListCommand generateMainDexListCommand3;
                generateMainDexListCommand = generateMainDexListCommand3;
                Builder builder = w4;
                boolean bl = builder.isPrintHelp();
                generateMainDexListCommand3 = new GenerateMainDexListCommand(bl, builder.isPrintVersion());
            }
            return generateMainDexListCommand;
        }

        @Override
        BaseCommand.Builder c() {
            return this;
        }
    }
}

