/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.SdkConstants;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Daemon$WhenMappings;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.ILogger;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H$J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H$J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010!\u001a\u00020\u0011J\b\u0010\"\u001a\u00020\u0011H$J\b\u0010#\u001a\u00020\u0011H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getDisplayName", "()Ljava/lang/String;", "getLogger", "()Lcom/android/utils/ILogger;", "<set-?>", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "state", "getState", "()Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "checkStarted", "", "compile", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "doCompile", "doLink", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "handleError", "", "action", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "unexpected", "", "link", "shutDown", "startProcess", "stopProcess", "State", "builder"})
@NotThreadSafe
public abstract class Aapt2Daemon
implements Aapt2 {
    @NotNull
    private State state;
    @NotNull
    private final String displayName;
    @NotNull
    private final ILogger logger;

    @NotNull
    public final State getState() {
        return this.state;
    }

    private final void checkStarted() {
        switch (Aapt2Daemon$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.logger.verbose("%1$s: starting", new Object[]{this.displayName});
                try {
                    this.startProcess();
                }
                catch (TimeoutException e4) {
                    Void void_ = Aapt2Daemon.handleError$default(this, "Daemon startup timed out", e4, false, 4, null);
                    throw null;
                }
                catch (Exception e5) {
                    if (SdkConstants.currentPlatform() != 2) {
                        String string = System.getProperty("os.arch");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.arch\")");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"64", (boolean)false, (int)2, null)) {
                            Void void_ = this.handleError("AAPT2 is not supported on 32-bit " + SdkConstants.currentPlatformName() + ',' + " see supported systems on https://developer.android.com/studio#system-requirements-a-namerequirementsa", new IllegalStateException("Unsupported operating system."), false);
                            throw null;
                        }
                    }
                    String message = "Daemon startup failed";
                    if (SdkConstants.currentPlatform() == 2) {
                        message = message + "\nPlease check if you installed the Windows Universal C Runtime.";
                    }
                    Void void_ = Aapt2Daemon.handleError$default(this, message, e5, false, 4, null);
                    throw null;
                }
                this.state = State.RUNNING;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String string = this.displayName + ": Cannot restart a shutdown process";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    protected abstract void startProcess();

    @Override
    public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doCompile(request, logger);
        }
        catch (Aapt2Exception e4) {
            throw (Throwable)e4;
        }
        catch (TimeoutException e5) {
            Void void_ = Aapt2Daemon.handleError$default(this, "Compile '" + request.getInputFile() + "' timed out", e5, false, 4, null);
            throw null;
        }
        catch (Exception e6) {
            Void void_ = Aapt2Daemon.handleError$default(this, "Unexpected error during compile '" + request.getInputFile() + '\'', e6, false, 4, null);
            throw null;
        }
    }

    protected abstract void doCompile(@NotNull CompileResourceRequest var1, @NotNull ILogger var2) throws TimeoutException, Aapt2InternalException, Aapt2Exception;

    @Override
    public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doLink(request, logger);
        }
        catch (Aapt2Exception e4) {
            throw (Throwable)e4;
        }
        catch (TimeoutException e5) {
            Void void_ = Aapt2Daemon.handleError$default(this, "Link timed out", e5, false, 4, null);
            throw null;
        }
        catch (Exception e6) {
            Void void_ = Aapt2Daemon.handleError$default(this, "Unexpected error during link", e6, false, 4, null);
            throw null;
        }
    }

    protected abstract void doLink(@NotNull AaptPackageConfig var1, @NotNull ILogger var2) throws TimeoutException, Aapt2InternalException, Aapt2Exception;

    public final void shutDown() {
        State state;
        Aapt2Daemon aapt2Daemon = this;
        switch (Aapt2Daemon$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                state = State.SHUTDOWN;
                break;
            }
            case 2: {
                this.logger.verbose("%1$s: shutdown", new Object[]{this.displayName});
                Aapt2Daemon aapt2Daemon2 = aapt2Daemon;
                try {
                    aapt2Daemon = aapt2Daemon2;
                    this.stopProcess();
                }
                catch (TimeoutException e4) {
                    aapt2Daemon = aapt2Daemon2;
                    this.logger.error((Throwable)e4, this.displayName + " Failed to shutdown within timeout", new Object[0]);
                }
                state = State.SHUTDOWN;
                break;
            }
            case 3: {
                String string = "Cannot call shutdown multiple times";
                Aapt2Daemon aapt2Daemon3 = aapt2Daemon;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        aapt2Daemon.state = state;
    }

    protected abstract void stopProcess() throws TimeoutException;

    private final Void handleError(String action, Exception exception, boolean unexpected) {
        Aapt2InternalException aapt2InternalException = new Aapt2InternalException(this.displayName + ": " + action + (this.state == State.RUNNING ? ", attempting to stop daemon.\n" : "\n") + (unexpected ? "This should not happen under normal circumstances, please file an issue if it does." : ""), exception);
        boolean bl = false;
        boolean bl2 = false;
        Aapt2InternalException $this$apply = aapt2InternalException;
        boolean bl3 = false;
        try {
            this.shutDown();
        }
        catch (Exception suppressed) {
            $this$apply.addSuppressed(suppressed);
        }
        throw (Throwable)aapt2InternalException;
    }

    static /* synthetic */ Void handleError$default(Aapt2Daemon aapt2Daemon, String string, Exception exception, boolean bl, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleError");
        }
        if ((n4 & 4) != 0) {
            bl = true;
        }
        return aapt2Daemon.handleError(string, exception, bl);
    }

    @NotNull
    protected final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    protected final ILogger getLogger() {
        return this.logger;
    }

    public Aapt2Daemon(@NotNull String displayName, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.displayName = displayName;
        this.logger = logger;
        this.state = State.NEW;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "", "(Ljava/lang/String;I)V", "NEW", "RUNNING", "SHUTDOWN", "builder"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NEW;
        public static final /* enum */ State RUNNING;
        public static final /* enum */ State SHUTDOWN;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = NEW = new State();
            stateArray[1] = RUNNING = new State();
            stateArray[2] = SHUTDOWN = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

