/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.V;
import com.android.tools.r8.graph.e0;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.t.a.a.b.W;
import com.android.tools.r8.t.a.a.b.v;
import com.android.tools.r8.w.a.a.a.h.A;
import com.android.tools.r8.w.a.a.a.h.a;
import com.android.tools.r8.w.a.a.a.h.y;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class ProguardClassNameList {
    public static Builder builder() {
        return new Builder();
    }

    public static ProguardClassNameList emptyList() {
        return new EmptyClassNameList();
    }

    public static ProguardClassNameList singletonList(ProguardTypeMatcher proguardTypeMatcher) {
        return new SingleClassNameList(proguardTypeMatcher);
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(ProguardClassNameList proguardClassNameList) {
        return proguardClassNameList == null ? Collections::emptyIterator : proguardClassNameList.getWildcards();
    }

    public abstract int size();

    public abstract void writeTo(StringBuilder var1);

    public String toString() {
        StringBuilder stringBuilder;
        ProguardClassNameList proguardClassNameList = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        proguardClassNameList.writeTo(new StringBuilder());
        return stringBuilder2.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract List<e0> asSpecificDexTypes();

    public abstract boolean matches(e0 var1);

    protected Iterable<ProguardWildcard> getWildcards() {
        return Collections::emptyIterator;
    }

    protected ProguardClassNameList materialize(V v4) {
        return this;
    }

    public abstract void forEachTypeMatcher(Consumer<ProguardTypeMatcher> var1);

    private static class MixedClassNameList
    extends ProguardClassNameList {
        private final A<ProguardTypeMatcher> classNames;

        private MixedClassNameList(A<ProguardTypeMatcher> a4) {
            this.classNames = a4;
        }

        @Override
        public int size() {
            return ((y)this.classNames).size();
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            boolean bl = true;
            for (A.a a4 : ((y)this.classNames).f()) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                if (((a)(a4 = (a)a4)).c()) {
                    stringBuilder.append('!');
                }
                stringBuilder.append(((ProguardTypeMatcher)a4.getKey()).toString());
                bl = false;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (mixedClassNameList2 == object) {
                return true;
            }
            if (object != null && MixedClassNameList.class == object.getClass()) {
                MixedClassNameList mixedClassNameList = mixedClassNameList2;
                MixedClassNameList mixedClassNameList2 = (MixedClassNameList)object;
                return Objects.equals(mixedClassNameList.classNames, mixedClassNameList2.classNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<e0> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(e0 e02) {
            for (A.a a4 : ((y)((MixedClassNameList)this).classNames).f()) {
                if (!((ProguardTypeMatcher)a4.getKey()).matches(e02)) continue;
                return ((a)a4).c() ^ true;
            }
            return false;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ((y)this.classNames).keySet().stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator;
        }

        @Override
        protected ProguardClassNameList materialize(V v4) {
            Builder builder = ProguardClassNameList.builder();
            this.classNames.forEach((proguardTypeMatcher, bl) -> {
                boolean bl2 = bl;
                builder.addClassName(bl2, proguardTypeMatcher.materialize(v4));
            });
            return builder.build();
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            ((y)this.classNames).f().forEach(a4 -> consumer.accept((ProguardTypeMatcher)a4.getKey()));
        }
    }

    private static class PositiveClassNameList
    extends ProguardClassNameList {
        private final W<ProguardTypeMatcher> classNames;

        private PositiveClassNameList(Collection<ProguardTypeMatcher> collection) {
            this.classNames = W.a(collection);
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            boolean bl = true;
            for (ProguardTypeMatcher proguardTypeMatcher : this.classNames) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(proguardTypeMatcher);
                bl = false;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (positiveClassNameList2 == object) {
                return true;
            }
            if (object != null && PositiveClassNameList.class == object.getClass()) {
                PositiveClassNameList positiveClassNameList = positiveClassNameList2;
                PositiveClassNameList positiveClassNameList2 = (PositiveClassNameList)object;
                return Objects.equals(positiveClassNameList.classNames, positiveClassNameList2.classNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<e0> asSpecificDexTypes() {
            if (this.classNames.stream().allMatch(proguardTypeMatcher -> proguardTypeMatcher.getSpecificType() != null)) {
                return this.classNames.stream().map(ProguardTypeMatcher::getSpecificType).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public boolean matches(e0 e02) {
            return this.classNames.stream().anyMatch(proguardTypeMatcher -> proguardTypeMatcher.matches(e02));
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.classNames.stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator;
        }

        @Override
        protected PositiveClassNameList materialize(V v4) {
            return new PositiveClassNameList(this.classNames.stream().map(proguardTypeMatcher -> proguardTypeMatcher.materialize(v4)).collect(Collectors.toList()));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.forEach(consumer);
        }
    }

    static class SingleClassNameList
    extends ProguardClassNameList {
        final ProguardTypeMatcher className;

        private SingleClassNameList(ProguardTypeMatcher proguardTypeMatcher) {
            this.className = proguardTypeMatcher;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            stringBuilder.append(this.className.toString());
        }

        @Override
        public boolean equals(Object object) {
            if (singleClassNameList2 == object) {
                return true;
            }
            if (object != null && SingleClassNameList.class == object.getClass()) {
                SingleClassNameList singleClassNameList = singleClassNameList2;
                SingleClassNameList singleClassNameList2 = (SingleClassNameList)object;
                return Objects.equals(singleClassNameList.className, singleClassNameList2.className);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.className);
        }

        @Override
        public List<e0> asSpecificDexTypes() {
            e0 e02 = ((SingleClassNameList)((Object)e02)).className.getSpecificType();
            return e02 == null ? null : Collections.singletonList(e02);
        }

        @Override
        public boolean matches(e0 e02) {
            return this.className.matches(e02);
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.className.getWildcards();
        }

        @Override
        protected SingleClassNameList materialize(V v4) {
            return new SingleClassNameList(this.className.materialize(v4));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            consumer.accept(this.className);
        }
    }

    private static class EmptyClassNameList
    extends ProguardClassNameList {
        private EmptyClassNameList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof EmptyClassNameList;
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        public List<e0> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(e0 e02) {
            return false;
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
        }
    }

    public static class Builder {
        private final A<ProguardTypeMatcher> matchers;

        private Builder() {
            y y4;
            y y5 = y4;
            y4 = new y();
            v1.matchers = y5;
        }

        public Builder addClassName(boolean bl, ProguardTypeMatcher proguardTypeMatcher) {
            Builder builder = this;
            ((y)builder.matchers).a(proguardTypeMatcher, bl);
            return builder;
        }

        ProguardClassNameList build() {
            if (((y)this.matchers).a(true)) {
                return new MixedClassNameList(this.matchers);
            }
            if (((y)this.matchers).size() == 1) {
                return new SingleClassNameList((ProguardTypeMatcher)v.b(((y)this.matchers).keySet()));
            }
            return new PositiveClassNameList(((y)this.matchers).keySet());
        }
    }
}

