/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.a;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.t.a.a.b.W;
import java.util.ArrayList;
import java.util.List;

public class ProguardKeepAttributes {
    public static final String SOURCE_FILE = "SourceFile";
    public static final String SOURCE_DIR = "SourceDir";
    public static final String INNER_CLASSES = "InnerClasses";
    public static final String ENCLOSING_METHOD = "EnclosingMethod";
    public static final String SIGNATURE = "Signature";
    public static final String EXCEPTIONS = "Exceptions";
    public static final String LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String LOCAL_VARIABLE_TYPE_TABLE = "LocalVariableTypeTable";
    public static final String METHOD_PARAMETERS = "MethodParameters";
    public static final String SOURCE_DEBUG_EXTENSION = "SourceDebugExtension";
    public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final String RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
    public static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
    public static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
    public static final String RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "RuntimeVisibleTypeAnnotations";
    public static final String RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "RuntimeInvisibleTypeAnnotations";
    public static final String ANNOTATION_DEFAULT = "AnnotationDefault";
    public static final String STACK_MAP_TABLE = "StackMapTable";
    public static final List<String> KEEP_ALL = W.a("*");
    public boolean sourceFile = false;
    public boolean sourceDir = false;
    public boolean innerClasses = false;
    public boolean enclosingMethod = false;
    public boolean signature = false;
    public boolean exceptions = false;
    public boolean lineNumberTable = false;
    public boolean localVariableTable = false;
    public boolean localVariableTypeTable = false;
    public boolean methodParameters = false;
    public boolean sourceDebugExtension = false;
    public boolean runtimeVisibleAnnotations = false;
    public boolean runtimeInvisibleAnnotations = false;
    public boolean runtimeVisibleParameterAnnotations = false;
    public boolean runtimeInvisibleParameterAnnotations = false;
    public boolean runtimeVisibleTypeAnnotations = false;
    public boolean runtimeInvisibleTypeAnnotations = false;
    public boolean annotationDefault = false;
    public boolean stackMapTable = false;

    private ProguardKeepAttributes() {
    }

    public static ProguardKeepAttributes filterOnlySignatures() {
        ProguardKeepAttributes proguardKeepAttributes = new ProguardKeepAttributes();
        proguardKeepAttributes.applyPatterns(KEEP_ALL);
        proguardKeepAttributes.signature = false;
        return proguardKeepAttributes;
    }

    private boolean update(boolean bl, String string, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (bl) {
                return true;
            }
            if (string2.length() > 0 && string2.charAt(0) == '!') {
                if (!this.matches(string2, 1, string, 0)) continue;
                break;
            }
            bl = this.matches(string2, 0, string, 0);
        }
        return bl;
    }

    private boolean matches(String string, int n4, String string2, int n5) {
        while (n4 < string.length()) {
            int n6 = n4 + 1;
            char c4 = string.charAt(n4);
            n4 = c4;
            if (c4 == '*') {
                while (n5 < string2.length()) {
                    n4 = n5 + 1;
                    if (this.matches(string, n6, string2, n5)) {
                        return true;
                    }
                    n5 = n4;
                }
                return n6 >= string.length();
            }
            if (n5 < string2.length() && string2.charAt(n5) == n4) {
                ++n5;
                n4 = n6;
                continue;
            }
            return false;
        }
        return n5 == string2.length();
    }

    public static ProguardKeepAttributes fromPatterns(List<String> list) {
        ProguardKeepAttributes proguardKeepAttributes = new ProguardKeepAttributes();
        proguardKeepAttributes.applyPatterns(list);
        return proguardKeepAttributes;
    }

    public void applyPatterns(List<String> list) {
        ProguardKeepAttributes proguardKeepAttributes = this;
        proguardKeepAttributes.sourceFile = proguardKeepAttributes.update(proguardKeepAttributes.sourceFile, SOURCE_FILE, list);
        proguardKeepAttributes.sourceDir = proguardKeepAttributes.update(proguardKeepAttributes.sourceDir, SOURCE_DIR, list);
        proguardKeepAttributes.innerClasses = proguardKeepAttributes.update(proguardKeepAttributes.innerClasses, INNER_CLASSES, list);
        proguardKeepAttributes.enclosingMethod = proguardKeepAttributes.update(proguardKeepAttributes.enclosingMethod, ENCLOSING_METHOD, list);
        proguardKeepAttributes.lineNumberTable = proguardKeepAttributes.update(proguardKeepAttributes.lineNumberTable, LINE_NUMBER_TABLE, list);
        proguardKeepAttributes.localVariableTable = proguardKeepAttributes.update(proguardKeepAttributes.localVariableTable, LOCAL_VARIABLE_TABLE, list);
        proguardKeepAttributes.localVariableTypeTable = proguardKeepAttributes.update(proguardKeepAttributes.localVariableTypeTable, LOCAL_VARIABLE_TYPE_TABLE, list);
        proguardKeepAttributes.exceptions = proguardKeepAttributes.update(proguardKeepAttributes.exceptions, EXCEPTIONS, list);
        proguardKeepAttributes.methodParameters = proguardKeepAttributes.update(proguardKeepAttributes.methodParameters, METHOD_PARAMETERS, list);
        proguardKeepAttributes.signature = proguardKeepAttributes.update(proguardKeepAttributes.signature, SIGNATURE, list);
        proguardKeepAttributes.sourceDebugExtension = proguardKeepAttributes.update(proguardKeepAttributes.sourceDebugExtension, SOURCE_DEBUG_EXTENSION, list);
        proguardKeepAttributes.runtimeVisibleAnnotations = proguardKeepAttributes.update(proguardKeepAttributes.runtimeVisibleAnnotations, RUNTIME_VISIBLE_ANNOTATIONS, list);
        proguardKeepAttributes.runtimeInvisibleAnnotations = proguardKeepAttributes.update(proguardKeepAttributes.runtimeInvisibleAnnotations, RUNTIME_INVISIBLE_ANNOTATIONS, list);
        proguardKeepAttributes.runtimeVisibleParameterAnnotations = proguardKeepAttributes.update(proguardKeepAttributes.runtimeVisibleParameterAnnotations, RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, list);
        proguardKeepAttributes.runtimeInvisibleParameterAnnotations = proguardKeepAttributes.update(proguardKeepAttributes.runtimeInvisibleParameterAnnotations, RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS, list);
        proguardKeepAttributes.runtimeVisibleTypeAnnotations = proguardKeepAttributes.update(proguardKeepAttributes.runtimeVisibleTypeAnnotations, RUNTIME_VISIBLE_TYPE_ANNOTATIONS, list);
        proguardKeepAttributes.runtimeInvisibleTypeAnnotations = proguardKeepAttributes.update(proguardKeepAttributes.runtimeInvisibleTypeAnnotations, RUNTIME_INVISIBLE_TYPE_ANNOTATIONS, list);
        proguardKeepAttributes.annotationDefault = proguardKeepAttributes.update(proguardKeepAttributes.annotationDefault, ANNOTATION_DEFAULT, list);
        proguardKeepAttributes.stackMapTable = proguardKeepAttributes.update(proguardKeepAttributes.stackMapTable, STACK_MAP_TABLE, list);
    }

    public void ensureValid(boolean bl) {
        if (bl && this.innerClasses != this.enclosingMethod) {
            ProguardKeepAttributes proguardKeepAttributes = this;
            proguardKeepAttributes.enclosingMethod = true;
            proguardKeepAttributes.innerClasses = true;
        }
        if (this.innerClasses && !this.enclosingMethod) {
            throw new a("Attribute InnerClasses requires EnclosingMethod attribute. Check -keepattributes directive.", Origin.unknown());
        }
        if (!this.innerClasses && this.enclosingMethod) {
            throw new a("Attribute EnclosingMethod requires InnerClasses attribute. Check -keepattributes directive.", Origin.unknown());
        }
        if (this.signature && !this.innerClasses) {
            throw new a("Attribute Signature requires InnerClasses attribute. Check -keepattributes directive.", Origin.unknown());
        }
        if (bl && this.localVariableTable && !this.lineNumberTable) {
            this.lineNumberTable = true;
        }
        if (this.localVariableTable && !this.lineNumberTable) {
            throw new a("Attribute LocalVariableTable requires LineNumberTable. Check -keepattributes directive.", Origin.unknown());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProguardKeepAttributes)) {
            return false;
        }
        object = (ProguardKeepAttributes)object;
        return this.sourceFile == ((ProguardKeepAttributes)object).sourceFile && this.sourceDir == ((ProguardKeepAttributes)object).sourceDir && this.innerClasses == ((ProguardKeepAttributes)object).innerClasses && this.enclosingMethod == ((ProguardKeepAttributes)object).enclosingMethod && this.signature == ((ProguardKeepAttributes)object).signature && this.exceptions == ((ProguardKeepAttributes)object).exceptions && this.methodParameters == ((ProguardKeepAttributes)object).methodParameters && this.sourceDebugExtension == ((ProguardKeepAttributes)object).sourceDebugExtension && this.runtimeVisibleAnnotations == ((ProguardKeepAttributes)object).runtimeVisibleAnnotations && this.runtimeInvisibleAnnotations == ((ProguardKeepAttributes)object).runtimeInvisibleAnnotations && this.runtimeVisibleParameterAnnotations == ((ProguardKeepAttributes)object).runtimeVisibleParameterAnnotations && this.runtimeInvisibleParameterAnnotations == ((ProguardKeepAttributes)object).runtimeInvisibleParameterAnnotations && this.runtimeVisibleTypeAnnotations == ((ProguardKeepAttributes)object).runtimeVisibleTypeAnnotations && this.runtimeInvisibleTypeAnnotations == ((ProguardKeepAttributes)object).runtimeInvisibleTypeAnnotations && this.annotationDefault == ((ProguardKeepAttributes)object).annotationDefault && this.stackMapTable == ((ProguardKeepAttributes)object).stackMapTable;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_18;
        ProguardKeepAttributes proguardKeepAttributes = this;
        int n4 = proguardKeepAttributes.sourceFile;
        int n5 = proguardKeepAttributes.sourceDir ? 2 : 0;
        int n6 = n4 + n5;
        n5 = this.innerClasses ? 4 : 0;
        int n7 = n6 + n5;
        n5 = this.enclosingMethod ? 8 : 0;
        int n8 = n7 + n5;
        n5 = this.signature ? 16 : 0;
        int n9 = n8 + n5;
        n5 = this.exceptions ? 32 : 0;
        int n10 = n9 + n5;
        n5 = this.sourceDebugExtension ? 64 : 0;
        int n11 = n10 + n5;
        n5 = this.runtimeVisibleAnnotations ? 128 : 0;
        int n12 = n11 + n5;
        n5 = this.runtimeInvisibleAnnotations ? 256 : 0;
        int n13 = n12 + n5;
        n5 = this.runtimeVisibleParameterAnnotations ? 512 : 0;
        int n14 = n13 + n5;
        n5 = this.runtimeInvisibleParameterAnnotations ? 1024 : 0;
        int n15 = n14 + n5;
        n5 = this.runtimeVisibleTypeAnnotations ? 2048 : 0;
        int n16 = n15 + n5;
        n5 = this.runtimeInvisibleTypeAnnotations ? 4096 : 0;
        int n17 = n16 + n5;
        n5 = this.annotationDefault ? 8192 : 0;
        int n18 = n17 + n5;
        n5 = this.stackMapTable ? 16384 : 0;
        int n62 = n18 + n5;
        if (this.methodParameters) {
            int n19 = 32768;
        } else {
            boolean bl = false;
        }
        return n62 + var1_18;
    }

    public boolean isEmpty() {
        return !this.sourceFile && !this.sourceDir && !this.innerClasses && !this.enclosingMethod && !this.signature && !this.exceptions && !this.methodParameters && !this.sourceDebugExtension && !this.runtimeVisibleAnnotations && !this.runtimeInvisibleAnnotations && !this.runtimeVisibleParameterAnnotations && !this.runtimeInvisibleParameterAnnotations && !this.runtimeVisibleTypeAnnotations && !this.runtimeInvisibleTypeAnnotations && !this.annotationDefault && !this.stackMapTable;
    }

    public StringBuilder append(StringBuilder stringBuilder) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (this.sourceFile) {
            arrayList2.add(SOURCE_FILE);
        }
        if (this.sourceDir) {
            arrayList2.add(SOURCE_DIR);
        }
        if (this.innerClasses) {
            arrayList2.add(INNER_CLASSES);
        }
        if (this.enclosingMethod) {
            arrayList2.add(ENCLOSING_METHOD);
        }
        if (this.signature) {
            arrayList2.add(SIGNATURE);
        }
        if (this.exceptions) {
            arrayList2.add(EXCEPTIONS);
        }
        if (this.methodParameters) {
            arrayList2.add(METHOD_PARAMETERS);
        }
        if (this.sourceDebugExtension) {
            arrayList2.add(SOURCE_DEBUG_EXTENSION);
        }
        if (this.runtimeVisibleAnnotations) {
            arrayList2.add(RUNTIME_INVISIBLE_ANNOTATIONS);
        }
        if (this.runtimeInvisibleAnnotations) {
            arrayList2.add(RUNTIME_INVISIBLE_ANNOTATIONS);
        }
        if (this.runtimeVisibleParameterAnnotations) {
            arrayList2.add(RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS);
        }
        if (this.runtimeInvisibleParameterAnnotations) {
            arrayList2.add(RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS);
        }
        if (this.runtimeVisibleTypeAnnotations) {
            arrayList2.add(RUNTIME_VISIBLE_TYPE_ANNOTATIONS);
        }
        if (this.runtimeInvisibleTypeAnnotations) {
            arrayList2.add(RUNTIME_INVISIBLE_TYPE_ANNOTATIONS);
        }
        if (this.annotationDefault) {
            arrayList2.add(ANNOTATION_DEFAULT);
        }
        if (this.stackMapTable) {
            arrayList2.add(STACK_MAP_TABLE);
        }
        if (arrayList2.size() > 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append("-keepattributes ");
            stringBuilder2.append(String.join((CharSequence)",", arrayList2));
        }
        return stringBuilder;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }
}

