/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexParameters;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.DexParser;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.StringConsumer;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

final class D8DexArchiveBuilder
extends DexArchiveBuilder {
    private static final String INVOKE_CUSTOM = "Invoke-customs are only supported starting with Android O";
    private static final String DEFAULT_INTERFACE_METHOD = "Default interface methods are only supported starting with Android N (--min-api 24)";
    private static final String STATIC_INTERFACE_METHOD = "Static interface methods are only supported starting with Android N (--min-api 24)";
    private DexParameters dexParams;

    public D8DexArchiveBuilder(DexParameters dexParams) {
        this.dexParams = dexParams;
    }

    @Override
    public void convert(Stream<ClassFileEntry> input, Path output2) throws DexArchiveBuilderException {
        InterceptingDiagnosticsHandler d8DiagnosticsHandler = new InterceptingDiagnosticsHandler();
        try {
            D8Command.Builder builder = D8Command.builder(d8DiagnosticsHandler);
            AtomicInteger entryCount = new AtomicInteger();
            input.forEach(entry -> {
                builder.addClassProgramData(D8DexArchiveBuilder.readAllBytes(entry), D8DiagnosticsHandler.getOrigin(entry));
                entryCount.incrementAndGet();
            });
            if (entryCount.get() == 0) {
                return;
            }
            ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.setMode(this.dexParams.getDebuggable() ? CompilationMode.DEBUG : CompilationMode.RELEASE)).setMinApiLevel(this.dexParams.getMinSdkVersion())).setIntermediate(true).setOutput(output2, this.dexParams.getDexPerClass() ? OutputMode.DexFilePerClassFile : OutputMode.DexIndexed)).setIncludeClassesChecksum(this.dexParams.getDebuggable());
            if (this.dexParams.getWithDesugaring()) {
                builder.addLibraryResourceProvider(this.dexParams.getDesugarBootclasspath().getOrderedProvider());
                builder.addClasspathResourceProvider(this.dexParams.getDesugarClasspath().getOrderedProvider());
                if (this.dexParams.getCoreLibDesugarConfig() != null) {
                    builder.addSpecialLibraryConfiguration(this.dexParams.getCoreLibDesugarConfig());
                    if (this.dexParams.getCoreLibDesugarOutputKeepRuleFile() != null) {
                        builder.setDesugaredLibraryKeepRuleConsumer(new StringConsumer.FileConsumer(this.dexParams.getCoreLibDesugarOutputKeepRuleFile().toPath()));
                    }
                }
            } else {
                builder.setDisableDesugaring(true);
            }
            D8.run((D8Command)builder.build(), (ExecutorService)MoreExecutors.newDirectExecutorService());
        }
        catch (Throwable e4) {
            throw D8DexArchiveBuilder.getExceptionToRethrow(e4, d8DiagnosticsHandler);
        }
    }

    private static byte[] readAllBytes(ClassFileEntry entry) {
        try {
            return entry.readAllBytes();
        }
        catch (IOException ex) {
            throw new DexArchiveBuilderException(ex);
        }
    }

    private static DexArchiveBuilderException getExceptionToRethrow(Throwable t4, D8DiagnosticsHandler d8DiagnosticsHandler) {
        StringBuilder msg = new StringBuilder();
        msg.append("Error while dexing.");
        for (String hint : d8DiagnosticsHandler.getPendingHints()) {
            msg.append(System.lineSeparator());
            msg.append(hint);
        }
        return new DexArchiveBuilderException(msg.toString(), t4);
    }

    private class InterceptingDiagnosticsHandler
    extends D8DiagnosticsHandler {
        public InterceptingDiagnosticsHandler() {
            super(D8DexArchiveBuilder.this.dexParams.getMessageReceiver());
        }

        @Override
        protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveBuilder.INVOKE_CUSTOM)) {
                this.addHint(DexParser.getEnableDesugaringHint((int)26));
            }
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveBuilder.DEFAULT_INTERFACE_METHOD)) {
                this.addHint(DexParser.getEnableDesugaringHint((int)24));
            }
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveBuilder.STATIC_INTERFACE_METHOD)) {
                this.addHint(DexParser.getEnableDesugaringHint((int)24));
            }
            return super.convertToMessage(kind, diagnostic);
        }
    }
}

