/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.util.Hex;
import com.android.dx.util.MutabilityControl;

public final class StdConstantPool
extends MutabilityControl
implements ConstantPool {
    private final Constant[] entries;

    public StdConstantPool(int size) {
        super(size > 1);
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.entries = new Constant[size];
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public Constant getOrNull(int n4) {
        try {
            return this.entries[n4];
        }
        catch (IndexOutOfBoundsException ex) {
            return StdConstantPool.throwInvalid(n4);
        }
    }

    @Override
    public Constant get0Ok(int n4) {
        if (n4 == 0) {
            return null;
        }
        return this.get(n4);
    }

    @Override
    public Constant get(int n4) {
        try {
            Constant result = this.entries[n4];
            if (result == null) {
                StdConstantPool.throwInvalid(n4);
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            return StdConstantPool.throwInvalid(n4);
        }
    }

    @Override
    public Constant[] getEntries() {
        return this.entries;
    }

    public void set(int n4, Constant cst) {
        Constant prev;
        boolean cat2;
        this.throwIfImmutable();
        boolean bl = cat2 = cst != null && cst.isCategory2();
        if (n4 < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        if (cat2) {
            if (n4 == this.entries.length - 1) {
                throw new IllegalArgumentException("(n == size - 1) && cst.isCategory2()");
            }
            this.entries[n4 + 1] = null;
        }
        if (cst != null && this.entries[n4] == null && (prev = this.entries[n4 - 1]) != null && prev.isCategory2()) {
            this.entries[n4 - 1] = null;
        }
        this.entries[n4] = cst;
    }

    private static Constant throwInvalid(int idx) {
        throw new ExceptionWithContext("invalid constant pool index " + Hex.u2(idx));
    }
}

