/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.L;
import com.android.tools.r8.graph.Q;
import com.android.tools.r8.graph.T;
import com.android.tools.r8.graph.X;
import com.android.tools.r8.graph.Z;
import com.android.tools.r8.graph.d0;
import com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    static KeepReason annotatedOn(L l4) {
        return new AnnotatedOn(l4);
    }

    static KeepReason instantiatedIn(Q q4) {
        return new InstatiatedIn(q4);
    }

    public static KeepReason invokedViaSuperFrom(Q q4) {
        return new InvokedViaSuper(q4);
    }

    public static KeepReason reachableFromLiveType(d0 d02) {
        return new ReachableFromLiveType(d02);
    }

    public static KeepReason invokedFrom(Z z4, Q q4) {
        return new InvokedFrom(z4, q4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(Q q4) {
        return new InvokedFromLambdaCreatedIn(q4);
    }

    public static KeepReason isLibraryMethod(Z z4, d0 d02) {
        return new IsLibraryMethod(z4.c, d02);
    }

    public static KeepReason fieldReferencedIn(Q q4) {
        return new ReferencedFrom(q4);
    }

    public static KeepReason referencedInAnnotation(T t4) {
        return new ReferencedInAnnotation(t4);
    }

    public static KeepReason targetedBySuperFrom(Q q4) {
        return new TargetedBySuper(q4);
    }

    public static KeepReason reflectiveUseIn(Q q4) {
        return new ReflectiveUseFrom(q4);
    }

    public static KeepReason methodHandleReferencedIn(Q q4) {
        return new MethodHandleReferencedFrom(q4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(Q q4) {
            super(q4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final L holder;

        private AnnotatedOn(L l4) {
            this.holder = l4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.d()) {
                return graphReporter.getClassGraphNode(this.holder.a().c);
            }
            if (this.holder.e()) {
                return graphReporter.getFieldGraphNode(this.holder.b().a);
            }
            if (!$assertionsDisabled && !this.holder.f()) {
                throw new AssertionError();
            }
            return graphReporter.getMethodGraphNode(this.holder.c().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final T holder;

        private ReferencedInAnnotation(T t4) {
            this.holder = t4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final d0 implementer;
        private final d0 libraryType;

        private IsLibraryMethod(d0 d02, d0 d03) {
            this.implementer = d02;
            this.libraryType = d03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final d0 type;

        private ReachableFromLiveType(d0 d02) {
            this.type = d02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InvokedFrom(Z z4, Q q4) {
            super(q4);
            if (!$assertionsDisabled && z4.c != q4.a.c) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final Q method;

        private BasedOnOtherMethod(Q q4) {
            this.method = q4;
        }

        abstract String getKind();

        public X getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode(this.method.a);
        }
    }
}

