/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.U;
import com.android.tools.r8.naming.g;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.s.a.a.b.W;
import com.android.tools.r8.s.a.a.b.v;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassSpecification;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardPackageMatcher;
import com.android.tools.r8.shaking.ProguardPackageNameList;
import com.android.tools.r8.shaking.ProguardPathFilter;
import com.android.tools.r8.shaking.ProguardPathList;
import com.android.tools.r8.utils.C0;
import com.android.tools.r8.utils.X;
import com.android.tools.r8.utils.z0;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProguardConfiguration {
    private final String parsedConfiguration;
    private final U dexItemFactory;
    private final W<FilteredClassPath> injars;
    private final W<FilteredClassPath> libraryjars;
    private final X.e packageObfuscationMode;
    private final String packagePrefix;
    private final boolean allowAccessModification;
    private final boolean ignoreWarnings;
    private final boolean optimizing;
    private final boolean obfuscating;
    private final boolean shrinking;
    private final boolean printConfiguration;
    private final Path printConfigurationFile;
    private final boolean printUsage;
    private final Path printUsageFile;
    private final boolean printMapping;
    private final Path printMappingFile;
    private final Path applyMappingFile;
    private final boolean verbose;
    private final String renameSourceFileAttribute;
    private final ProguardKeepAttributes keepAttributes;
    private final ProguardPackageNameList keepPackageNamesPatterns;
    private final ProguardClassFilter dontWarnPatterns;
    private final ProguardClassFilter dontNotePatterns;
    protected final W<ProguardConfigurationRule> rules;
    private final boolean printSeeds;
    private final Path seedFile;
    private final boolean overloadAggressively;
    private final W<String> obfuscationDictionary;
    private final W<String> classObfuscationDictionary;
    private final W<String> packageObfuscationDictionary;
    private final boolean keepParameterNames;
    private final ProguardClassFilter adaptClassStrings;
    private final ProguardPathFilter adaptResourceFilenames;
    private final ProguardPathFilter adaptResourceFileContents;
    private final ProguardPathFilter keepDirectories;
    private final boolean configurationDebugging;
    private final boolean dontUseMixedCaseClassnames;

    private ProguardConfiguration(String string, U u4, List<FilteredClassPath> list, List<FilteredClassPath> list2, X.e e4, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Path path, boolean bl7, Path path2, boolean bl8, Path path3, Path path4, boolean bl9, String string3, ProguardKeepAttributes proguardKeepAttributes, ProguardPackageNameList proguardPackageNameList, ProguardClassFilter proguardClassFilter, ProguardClassFilter proguardClassFilter2, Set<ProguardConfigurationRule> set, boolean bl10, Path path5, boolean bl11, W<String> w4, W<String> w5, W<String> w6, boolean bl12, ProguardClassFilter proguardClassFilter3, ProguardPathFilter proguardPathFilter, ProguardPathFilter proguardPathFilter2, ProguardPathFilter proguardPathFilter3, boolean bl13, boolean bl14) {
        this.parsedConfiguration = string;
        this.dexItemFactory = u4;
        this.injars = W.a(list);
        this.libraryjars = W.a(list2);
        this.packageObfuscationMode = e4;
        this.packagePrefix = string2;
        this.allowAccessModification = bl;
        this.ignoreWarnings = bl2;
        this.optimizing = bl3;
        this.obfuscating = bl4;
        this.shrinking = bl5;
        this.printConfiguration = bl6;
        this.printConfigurationFile = path;
        this.printUsage = bl7;
        this.printUsageFile = path2;
        this.printMapping = bl8;
        this.printMappingFile = path3;
        this.applyMappingFile = path4;
        this.verbose = bl9;
        this.renameSourceFileAttribute = string3;
        this.keepAttributes = proguardKeepAttributes;
        this.keepPackageNamesPatterns = proguardPackageNameList;
        this.dontWarnPatterns = proguardClassFilter;
        this.dontNotePatterns = proguardClassFilter2;
        this.rules = W.a(set);
        this.printSeeds = bl10;
        this.seedFile = path5;
        this.overloadAggressively = bl11;
        this.obfuscationDictionary = w4;
        this.classObfuscationDictionary = w5;
        this.packageObfuscationDictionary = w6;
        this.keepParameterNames = bl12;
        this.adaptClassStrings = proguardClassFilter3;
        this.adaptResourceFilenames = proguardPathFilter;
        this.adaptResourceFileContents = proguardPathFilter2;
        this.keepDirectories = proguardPathFilter3;
        this.configurationDebugging = bl13;
        this.dontUseMixedCaseClassnames = bl14;
    }

    public static Builder builder(U u4, z0 z02) {
        return new Builder(u4, z02);
    }

    public String getParsedConfiguration() {
        return this.parsedConfiguration;
    }

    public U getDexItemFactory() {
        return this.dexItemFactory;
    }

    public List<FilteredClassPath> getInjars() {
        return this.injars;
    }

    public List<FilteredClassPath> getLibraryjars() {
        return this.libraryjars;
    }

    public X.e getPackageObfuscationMode() {
        return this.packageObfuscationMode;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public boolean isAccessModificationAllowed() {
        return this.allowAccessModification;
    }

    public boolean isPrintMapping() {
        return this.printMapping;
    }

    public Path getPrintMappingFile() {
        return this.printMappingFile;
    }

    public boolean hasApplyMappingFile() {
        return this.applyMappingFile != null;
    }

    public Path getApplyMappingFile() {
        return this.applyMappingFile;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public boolean isOptimizing() {
        return this.optimizing;
    }

    public boolean isObfuscating() {
        return this.obfuscating;
    }

    public boolean isShrinking() {
        return this.shrinking;
    }

    public boolean isPrintConfiguration() {
        return this.printConfiguration;
    }

    public Path getPrintConfigurationFile() {
        return this.printConfigurationFile;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public Path getPrintUsageFile() {
        return this.printUsageFile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getRenameSourceFileAttribute() {
        return this.renameSourceFileAttribute;
    }

    public ProguardKeepAttributes getKeepAttributes() {
        return this.keepAttributes;
    }

    public ProguardPackageNameList getKeepPackageNamesPatterns() {
        return this.keepPackageNamesPatterns;
    }

    public ProguardClassFilter getDontWarnPatterns() {
        return this.dontWarnPatterns;
    }

    public ProguardClassFilter getDontNotePatterns() {
        return this.dontNotePatterns;
    }

    public List<ProguardConfigurationRule> getRules() {
        return this.rules;
    }

    public boolean isOverloadAggressively() {
        return this.overloadAggressively;
    }

    public List<String> getObfuscationDictionary() {
        return this.obfuscationDictionary;
    }

    public List<String> getClassObfuscationDictionary() {
        return this.classObfuscationDictionary;
    }

    public List<String> getPackageObfuscationDictionary() {
        return this.packageObfuscationDictionary;
    }

    public boolean isKeepParameterNames() {
        return this.keepParameterNames;
    }

    public ProguardClassFilter getAdaptClassStrings() {
        return this.adaptClassStrings;
    }

    public ProguardPathFilter getAdaptResourceFilenames() {
        return this.adaptResourceFilenames;
    }

    public ProguardPathFilter getAdaptResourceFileContents() {
        return this.adaptResourceFileContents;
    }

    public ProguardPathFilter getKeepDirectories() {
        return this.keepDirectories;
    }

    public boolean isPrintSeeds() {
        return this.printSeeds;
    }

    public Path getSeedFile() {
        return this.seedFile;
    }

    public boolean isConfigurationDebugging() {
        return this.configurationDebugging;
    }

    public boolean hasDontUseMixedCaseClassnames() {
        return this.dontUseMixedCaseClassnames;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (!((ProguardConfiguration)((Object)iterator)).keepAttributes.isEmpty()) {
            ((ProguardConfiguration)((Object)iterator)).keepAttributes.append(stringBuilder2);
            stringBuilder2.append('\n');
        }
        Iterator iterator = ((ProguardConfiguration)((Object)iterator)).rules.iterator();
        while (iterator.hasNext()) {
            ((ProguardConfigurationRule)iterator.next()).append(stringBuilder2, true);
            stringBuilder2.append('\n');
        }
        return stringBuilder2.toString();
    }

    public static class Builder {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final List<String> parsedConfiguration = new ArrayList<String>();
        private final List<FilteredClassPath> injars = new ArrayList<FilteredClassPath>();
        private final List<FilteredClassPath> libraryjars = new ArrayList<FilteredClassPath>();
        private final z0 reporter;
        private X.e packageObfuscationMode = X.e.a;
        private String packagePrefix = "";
        private boolean allowAccessModification;
        private boolean ignoreWarnings;
        private boolean optimizing = true;
        private boolean obfuscating = true;
        private boolean shrinking = true;
        private boolean printConfiguration;
        private Path printConfigurationFile;
        private boolean printUsage;
        private Path printUsageFile;
        private boolean printMapping;
        private Path printMappingFile;
        private Path applyMappingFile;
        private boolean verbose;
        private String renameSourceFileAttribute;
        private final List<String> keepAttributePatterns = new ArrayList<String>();
        private final ProguardPackageNameList.Builder keepPackageNamesPatterns = ProguardPackageNameList.builder();
        private final ProguardClassFilter.Builder dontWarnPatterns = ProguardClassFilter.builder();
        private final ProguardClassFilter.Builder dontNotePatterns = ProguardClassFilter.builder();
        protected final Set<ProguardConfigurationRule> rules = v.g();
        private final U dexItemFactory;
        private boolean printSeeds;
        private Path seedFile;
        private Path obfuscationDictionary;
        private Path classObfuscationDictionary;
        private Path packageObfuscationDictionary;
        private boolean keepParameterNames;
        private Origin keepParameterNamesOptionOrigin;
        private Position keepParameterNamesOptionPosition;
        private final ProguardClassFilter.Builder adaptClassStrings = ProguardClassFilter.builder();
        private final ProguardPathFilter.Builder adaptResourceFilenames = ProguardPathFilter.builder().addPattern(ProguardPathList.builder().addFileName("META-INF/services/*").build());
        private final ProguardPathFilter.Builder adaptResourceFileContents = ProguardPathFilter.builder().addPattern(ProguardPathList.builder().addFileName("META-INF/services/*").build());
        private final ProguardPathFilter.Builder keepDirectories = ProguardPathFilter.builder().disable();
        private boolean forceProguardCompatibility = false;
        private boolean overloadAggressively;
        private boolean keepRuleSynthesisForRecompilation = false;
        private boolean configurationDebugging = false;
        private boolean dontUseMixedCaseClassnames = false;

        private Builder(U u4, z0 z02) {
            this.dexItemFactory = u4;
            this.reporter = z02;
        }

        static {
            $assertionsDisabled = ProguardConfiguration.class.desiredAssertionStatus() ^ true;
        }

        public void addParsedConfiguration(String string) {
            this.parsedConfiguration.add(string);
        }

        public void addInjars(List<FilteredClassPath> list) {
            this.injars.addAll(list);
        }

        public void addLibraryJars(List<FilteredClassPath> list) {
            this.libraryjars.addAll(list);
        }

        public X.e getPackageObfuscationMode() {
            return this.packageObfuscationMode;
        }

        public void setPackagePrefix(String string) {
            this.packageObfuscationMode = X.e.b;
            this.packagePrefix = string;
        }

        public void setFlattenPackagePrefix(String string) {
            this.packageObfuscationMode = X.e.c;
            this.packagePrefix = string;
        }

        public void setAllowAccessModification(boolean bl) {
            this.allowAccessModification = bl;
        }

        public void setIgnoreWarnings(boolean bl) {
            this.ignoreWarnings = bl;
        }

        public Builder disableOptimization() {
            this.optimizing = false;
            return this;
        }

        public Builder disableObfuscation() {
            this.obfuscating = false;
            return this;
        }

        boolean isObfuscating() {
            return this.obfuscating;
        }

        public boolean isOptimizing() {
            return this.optimizing;
        }

        public boolean isShrinking() {
            return this.shrinking;
        }

        public Builder disableShrinking() {
            this.shrinking = false;
            return this;
        }

        public void setPrintConfiguration(boolean bl) {
            this.printConfiguration = bl;
        }

        public void setPrintConfigurationFile(Path path) {
            if (!$assertionsDisabled && !this.printConfiguration) {
                throw new AssertionError();
            }
            this.printConfigurationFile = path;
        }

        public void setPrintUsage(boolean bl) {
            this.printUsage = bl;
        }

        public void setPrintUsageFile(Path path) {
            this.printUsageFile = path;
        }

        public void setPrintMapping(boolean bl) {
            this.printMapping = bl;
        }

        public void setPrintMappingFile(Path path) {
            if (!$assertionsDisabled && !this.printMapping) {
                throw new AssertionError();
            }
            this.printMappingFile = path;
        }

        public void setApplyMappingFile(Path path) {
            this.applyMappingFile = path;
        }

        public boolean hasApplyMappingFile() {
            return this.applyMappingFile != null;
        }

        public void setVerbose(boolean bl) {
            this.verbose = bl;
        }

        public void setRenameSourceFileAttribute(String string) {
            this.renameSourceFileAttribute = string;
        }

        public Builder addKeepAttributePatterns(List<String> list) {
            Builder builder = this;
            builder.keepAttributePatterns.addAll(list);
            return builder;
        }

        public void addRule(ProguardConfigurationRule proguardConfigurationRule) {
            this.rules.add(proguardConfigurationRule);
        }

        public void addKeepPackageNamesPattern(boolean bl, ProguardPackageMatcher proguardPackageMatcher) {
            this.keepPackageNamesPatterns.addPackageName(bl, proguardPackageMatcher);
        }

        public void addDontWarnPattern(ProguardClassNameList proguardClassNameList) {
            this.dontWarnPatterns.addPattern(proguardClassNameList);
        }

        public void addDontNotePattern(ProguardClassNameList proguardClassNameList) {
            this.dontNotePatterns.addPattern(proguardClassNameList);
        }

        public void setSeedFile(Path path) {
            this.seedFile = path;
        }

        public void setPrintSeeds(boolean bl) {
            this.printSeeds = bl;
        }

        public void setObfuscationDictionary(Path path) {
            this.obfuscationDictionary = path;
        }

        public void setClassObfuscationDictionary(Path path) {
            this.classObfuscationDictionary = path;
        }

        public void setPackageObfuscationDictionary(Path path) {
            this.packageObfuscationDictionary = path;
        }

        boolean isOverloadAggressively() {
            return this.overloadAggressively;
        }

        public void setKeepParameterNames(boolean bl, Origin origin, Position position) {
            if (!$assertionsDisabled && origin == null && bl) {
                throw new AssertionError();
            }
            Builder builder = this;
            builder.keepParameterNames = bl;
            builder.keepParameterNamesOptionOrigin = origin;
            builder.keepParameterNamesOptionPosition = position;
        }

        boolean isKeepParameterNames() {
            return this.keepParameterNames;
        }

        Origin getKeepParameterNamesOptionOrigin() {
            return this.keepParameterNamesOptionOrigin;
        }

        Position getKeepParameterNamesOptionPosition() {
            return this.keepParameterNamesOptionPosition;
        }

        public void addAdaptClassStringsPattern(ProguardClassNameList proguardClassNameList) {
            this.adaptClassStrings.addPattern(proguardClassNameList);
        }

        public void addAdaptResourceFilenames(ProguardPathList proguardPathList) {
            this.adaptResourceFilenames.addPattern(proguardPathList);
        }

        public void addAdaptResourceFileContents(ProguardPathList proguardPathList) {
            this.adaptResourceFileContents.addPattern(proguardPathList);
        }

        public void enableKeepDirectories() {
            this.keepDirectories.enable();
        }

        public void addKeepDirectories(ProguardPathList proguardPathList) {
            this.keepDirectories.addPattern(proguardPathList);
        }

        public void setForceProguardCompatibility(boolean bl) {
            this.forceProguardCompatibility = bl;
        }

        public void setOverloadAggressively(boolean bl) {
            this.overloadAggressively = bl;
        }

        public void enableKeepRuleSynthesisForRecompilation() {
            this.keepRuleSynthesisForRecompilation = true;
        }

        public void setConfigurationDebugging(boolean bl) {
            this.configurationDebugging = bl;
        }

        boolean isConfigurationDebugging() {
            return this.configurationDebugging;
        }

        public void setDontUseMixedCaseClassnames(boolean bl) {
            this.dontUseMixedCaseClassnames = bl;
        }

        public void synthesizeKeepRulesForRecompilation() {
            ArrayList<ProguardConfigurationRule> arrayList;
            ArrayList<ProguardConfigurationRule> arrayList2 = arrayList;
            arrayList = new ArrayList<ProguardConfigurationRule>();
            Iterator<ProguardConfigurationRule> iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                ProguardConfigurationUtils.synthesizeKeepRulesForRecompilation(iterator.next(), arrayList2);
            }
            if (this.rules.addAll(arrayList2)) {
                this.parsedConfiguration.add(C0.b((String[])arrayList2.stream().map(ProguardClassSpecification::toString).toArray(String[]::new)));
            }
        }

        public ProguardConfiguration buildRaw() {
            Builder builder = w6;
            String string = String.join((CharSequence)System.lineSeparator(), ((Builder)((Object)w6)).parsedConfiguration);
            U u4 = builder.dexItemFactory;
            List<FilteredClassPath> list = builder.injars;
            List<FilteredClassPath> list2 = builder.libraryjars;
            X.e e4 = builder.packageObfuscationMode;
            String string2 = builder.packagePrefix;
            boolean bl = builder.allowAccessModification;
            boolean bl2 = builder.ignoreWarnings;
            boolean bl3 = builder.optimizing;
            boolean bl4 = builder.obfuscating;
            boolean bl5 = builder.shrinking;
            boolean bl6 = builder.printConfiguration;
            Path path = builder.printConfigurationFile;
            boolean bl7 = builder.printUsage;
            Path path2 = builder.printUsageFile;
            boolean bl8 = builder.printMapping;
            Path path3 = builder.printMappingFile;
            Path path4 = builder.applyMappingFile;
            boolean bl9 = builder.verbose;
            String string3 = builder.renameSourceFileAttribute;
            ProguardKeepAttributes proguardKeepAttributes = ProguardKeepAttributes.fromPatterns(builder.keepAttributePatterns);
            ProguardPackageNameList proguardPackageNameList = builder.keepPackageNamesPatterns.build();
            ProguardClassFilter proguardClassFilter = builder.dontWarnPatterns.build();
            ProguardClassFilter proguardClassFilter2 = builder.dontNotePatterns.build();
            Set<ProguardConfigurationRule> set = builder.rules;
            boolean bl10 = builder.printSeeds;
            Path path5 = builder.seedFile;
            boolean bl11 = builder.overloadAggressively;
            W<String> w4 = g.a(builder.obfuscationDictionary, ((Builder)((Object)w6)).reporter);
            W<String> w5 = g.a(builder.classObfuscationDictionary, ((Builder)((Object)w6)).reporter);
            W<String> w6 = g.a(builder.packageObfuscationDictionary, ((Builder)((Object)w6)).reporter);
            boolean bl12 = builder.keepParameterNames;
            ProguardClassFilter proguardClassFilter3 = builder.adaptClassStrings.build();
            ProguardPathFilter proguardPathFilter = builder.adaptResourceFilenames.build();
            ProguardPathFilter proguardPathFilter2 = builder.adaptResourceFileContents.build();
            ProguardPathFilter proguardPathFilter3 = builder.keepDirectories.build();
            boolean bl13 = builder.configurationDebugging;
            boolean bl14 = builder.dontUseMixedCaseClassnames;
            ProguardConfiguration proguardConfiguration = new ProguardConfiguration(string, u4, list, list2, e4, string2, bl, bl2, bl3, bl4, bl5, bl6, path, bl7, path2, bl8, path3, path4, bl9, string3, proguardKeepAttributes, proguardPackageNameList, proguardClassFilter, proguardClassFilter2, set, bl10, path5, bl11, w4, w5, w6, bl12, proguardClassFilter3, proguardPathFilter, proguardPathFilter2, proguardPathFilter3, bl13, bl14);
            ((Builder)((Object)w6)).reporter.a();
            return proguardConfiguration;
        }

        public ProguardConfiguration build() {
            if (this.forceProguardCompatibility && !this.isObfuscating()) {
                this.keepAttributePatterns.addAll(ProguardKeepAttributes.KEEP_ALL);
            }
            if (!(this.isShrinking() && this.isObfuscating() && this.isOptimizing())) {
                Builder builder2 = this;
                builder2.addRule(ProguardKeepRule.defaultKeepAllRule(builder -> {
                    builder.setAllowsShrinking(this.isShrinking());
                    builder.setAllowsOptimization(this.isOptimizing());
                    builder.setAllowsObfuscation(this.isObfuscating());
                }));
            }
            if (this.keepRuleSynthesisForRecompilation) {
                this.synthesizeKeepRulesForRecompilation();
            }
            return this.buildRaw();
        }
    }
}

