/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.testing.api.DeviceConnector;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.ILogger;

public class InstallUtils {
    public static boolean checkDeviceApiLevel(DeviceConnector device, AndroidVersion appMinSdkVersion, ILogger logger, String projectName, String variantName) {
        int deviceApiLevel = device.getApiLevel();
        if (deviceApiLevel == 0) {
            logger.lifecycle("Skipping device '%1$s' for '%2$s:%3$s': Unknown API Level", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        int minSdkVersion = appMinSdkVersion.getApiLevel();
        if (appMinSdkVersion.getCodename() != null) {
            String deviceCodeName = device.getApiCodeName();
            if (deviceCodeName != null) {
                if (!deviceCodeName.equals(appMinSdkVersion.getCodename())) {
                    logger.lifecycle("Skipping device '%1$s', due to different API preview '%2$s' and '%3$s'", new Object[]{device.getName(), deviceCodeName, appMinSdkVersion.getCodename()});
                    return false;
                }
            } else {
                minSdkVersion = SdkVersionInfo.getApiByBuildCode((String)appMinSdkVersion.getCodename(), (boolean)true);
            }
        }
        if (minSdkVersion > deviceApiLevel) {
            logger.lifecycle("Skipping device '%s' for '%s:%s': minSdkVersion [%s] > deviceApiLevel [%d]", new Object[]{device.getName(), projectName, variantName, appMinSdkVersion.getApiString(), deviceApiLevel});
            return false;
        }
        return true;
    }
}

