/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.p.a.a.b.W;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.P0;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class ProguardClassSpecification {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Origin origin;
    private final Position position;
    private final String source;
    private final ProguardTypeMatcher classAnnotation;
    private final ProguardAccessFlags classAccessFlags;
    private final ProguardAccessFlags negatedClassAccessFlags;
    private final boolean classTypeNegated;
    private final ProguardClassType classType;
    private final ProguardClassNameList classNames;
    private final ProguardTypeMatcher inheritanceAnnotation;
    private final ProguardTypeMatcher inheritanceClassName;
    private final boolean inheritanceIsExtends;
    private final List<ProguardMemberRule> memberRules;

    protected ProguardClassSpecification(Origin origin, Position position, String string, ProguardTypeMatcher proguardTypeMatcher, ProguardAccessFlags proguardAccessFlags, ProguardAccessFlags proguardAccessFlags2, boolean bl, ProguardClassType proguardClassType, ProguardClassNameList proguardClassNameList, ProguardTypeMatcher proguardTypeMatcher2, ProguardTypeMatcher proguardTypeMatcher3, boolean bl2, List<ProguardMemberRule> list) {
        if (!$assertionsDisabled && origin == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && position == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null && origin == Origin.unknown()) {
            throw new AssertionError();
        }
        this.origin = origin;
        this.position = position;
        this.source = string;
        this.classAnnotation = proguardTypeMatcher;
        this.classAccessFlags = proguardAccessFlags;
        this.negatedClassAccessFlags = proguardAccessFlags2;
        this.classTypeNegated = bl;
        this.classType = proguardClassType;
        if (!$assertionsDisabled && proguardClassType == null) {
            throw new AssertionError();
        }
        ProguardClassSpecification proguardClassSpecification = this;
        proguardClassSpecification.classNames = proguardClassNameList;
        proguardClassSpecification.inheritanceAnnotation = proguardTypeMatcher2;
        proguardClassSpecification.inheritanceClassName = proguardTypeMatcher3;
        proguardClassSpecification.inheritanceIsExtends = bl2;
        proguardClassSpecification.memberRules = list;
    }

    static {
        $assertionsDisabled = ProguardClassSpecification.class.desiredAssertionStatus() ^ true;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getSource() {
        return this.source;
    }

    public List<ProguardMemberRule> getMemberRules() {
        return this.memberRules;
    }

    public boolean getInheritanceIsExtends() {
        return this.inheritanceIsExtends;
    }

    public boolean getInheritanceIsImplements() {
        return this.inheritanceIsExtends ^ true;
    }

    public boolean hasInheritanceClassName() {
        return this.inheritanceClassName != null;
    }

    public ProguardTypeMatcher getInheritanceClassName() {
        return this.inheritanceClassName;
    }

    public ProguardTypeMatcher getInheritanceAnnotation() {
        return this.inheritanceAnnotation;
    }

    public ProguardClassNameList getClassNames() {
        return this.classNames;
    }

    public ProguardClassType getClassType() {
        return this.classType;
    }

    public boolean getClassTypeNegated() {
        return this.classTypeNegated;
    }

    public ProguardAccessFlags getClassAccessFlags() {
        return this.classAccessFlags;
    }

    public ProguardAccessFlags getNegatedClassAccessFlags() {
        return this.negatedClassAccessFlags;
    }

    public ProguardTypeMatcher getClassAnnotation() {
        return this.classAnnotation;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProguardClassSpecification)) {
            return false;
        }
        object = (ProguardClassSpecification)object;
        if (this.classTypeNegated != ((ProguardClassSpecification)object).classTypeNegated) {
            return false;
        }
        if (this.inheritanceIsExtends != ((ProguardClassSpecification)object).inheritanceIsExtends) {
            return false;
        }
        if (!Objects.equals(this.classAnnotation, ((ProguardClassSpecification)object).classAnnotation)) {
            return false;
        }
        if (!this.classAccessFlags.equals(((ProguardClassSpecification)object).classAccessFlags)) {
            return false;
        }
        if (!this.negatedClassAccessFlags.equals(((ProguardClassSpecification)object).negatedClassAccessFlags)) {
            return false;
        }
        if (this.classType != ((ProguardClassSpecification)object).classType) {
            return false;
        }
        if (!this.classNames.equals(((ProguardClassSpecification)object).classNames)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceAnnotation, ((ProguardClassSpecification)object).inheritanceAnnotation)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceClassName, ((ProguardClassSpecification)object).inheritanceClassName)) {
            return false;
        }
        return this.memberRules.equals(((ProguardClassSpecification)object).memberRules);
    }

    public int hashCode() {
        ProguardTypeMatcher proguardTypeMatcher = this.classAnnotation;
        int n4 = ((((proguardTypeMatcher != null ? proguardTypeMatcher.hashCode() : 0) * 3 + this.classAccessFlags.hashCode()) * 3 + this.negatedClassAccessFlags.hashCode()) * 3 + this.classTypeNegated) * 3;
        ProguardClassType proguardClassType = this.classType;
        int n5 = proguardClassType != null ? proguardClassType.hashCode() : 0;
        n4 = ((n4 + n5) * 3 + this.classNames.hashCode()) * 3;
        ProguardTypeMatcher proguardTypeMatcher2 = this.inheritanceAnnotation;
        int n6 = proguardTypeMatcher2 != null ? proguardTypeMatcher2.hashCode() : 0;
        n4 = (n4 + n6) * 3;
        ProguardTypeMatcher proguardTypeMatcher3 = this.inheritanceClassName;
        int n7 = proguardTypeMatcher3 != null ? proguardTypeMatcher3.hashCode() : 0;
        return ((n4 + n7) * 3 + this.inheritanceIsExtends) * 3 + this.memberRules.hashCode();
    }

    protected StringBuilder append(StringBuilder stringBuilder, boolean bl) {
        if (P0.a(stringBuilder, "@", this.classAnnotation, null) | P0.a(stringBuilder, "", this.classAccessFlags, null) | P0.a(stringBuilder, "!", (Object)this.negatedClassAccessFlags.toString().replace(" ", " !"), null)) {
            stringBuilder.append(' ');
        }
        if (this.classTypeNegated) {
            stringBuilder.append('!');
        }
        ProguardClassSpecification proguardClassSpecification = this;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append((Object)this.classType);
        stringBuilder2.append(' ');
        proguardClassSpecification.classNames.writeTo(stringBuilder);
        if (proguardClassSpecification.hasInheritanceClassName()) {
            StringBuilder stringBuilder3 = stringBuilder.append(' ');
            String string = this.inheritanceIsExtends ? "extends" : "implements";
            StringBuilder stringBuilder4 = stringBuilder;
            stringBuilder3.append(string);
            P0.a(stringBuilder4, "@", this.inheritanceAnnotation, null);
            stringBuilder4.append(' ');
            stringBuilder.append(this.inheritanceClassName);
        }
        if (bl && !this.memberRules.isEmpty()) {
            stringBuilder.append(" {").append(System.lineSeparator());
            this.memberRules.forEach(proguardMemberRule -> {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder.append("  ");
                stringBuilder2.append(proguardMemberRule);
                stringBuilder2.append(";").append(System.lineSeparator());
            });
            stringBuilder.append("}");
        }
        return stringBuilder;
    }

    public String toShortString() {
        return this.append(new StringBuilder(), false).toString();
    }

    public String toString() {
        return this.append(new StringBuilder(), true).toString();
    }

    public static abstract class Builder<C extends ProguardClassSpecification, B extends Builder<C, B>> {
        protected Origin origin;
        protected Position start;
        protected Position end;
        protected String source;
        protected ProguardTypeMatcher classAnnotation;
        protected ProguardAccessFlags classAccessFlags = new ProguardAccessFlags();
        protected ProguardAccessFlags negatedClassAccessFlags = new ProguardAccessFlags();
        protected boolean classTypeNegated = false;
        protected ProguardClassType classType = ProguardClassType.UNSPECIFIED;
        protected ProguardClassNameList classNames;
        protected ProguardTypeMatcher inheritanceAnnotation;
        protected ProguardTypeMatcher inheritanceClassName;
        protected boolean inheritanceIsExtends = false;
        protected List<ProguardMemberRule> memberRules = new LinkedList<ProguardMemberRule>();

        protected Builder() {
            this(Origin.unknown(), Position.UNKNOWN);
        }

        protected Builder(Origin origin, Position position) {
            this.origin = origin;
            this.start = position;
        }

        public abstract C build();

        public abstract B self();

        public B setOrigin(Origin origin) {
            this.origin = origin;
            return this.self();
        }

        public B setStart(Position position) {
            this.start = position;
            return this.self();
        }

        public B setEnd(Position position) {
            this.end = position;
            return this.self();
        }

        public B setSource(String string) {
            this.source = string;
            return this.self();
        }

        public Position getPosition() {
            Position position = ((Builder)((Object)textPosition)).start;
            if (position == null) {
                return Position.UNKNOWN;
            }
            Position position2 = ((Builder)((Object)textPosition)).end;
            if (position2 != null && position instanceof TextPosition && position2 instanceof TextPosition) {
                TextPosition textPosition = (TextPosition)position;
                return new TextRange(textPosition, (TextPosition)position2);
            }
            return ((Builder)((Object)textPosition)).start;
        }

        public List<ProguardMemberRule> getMemberRules() {
            return this.memberRules;
        }

        public B setMemberRules(List<ProguardMemberRule> list) {
            this.memberRules = list;
            return this.self();
        }

        public boolean getInheritanceIsExtends() {
            return this.inheritanceIsExtends;
        }

        public void setInheritanceIsExtends(boolean bl) {
            this.inheritanceIsExtends = bl;
        }

        public boolean hasInheritanceClassName() {
            return this.inheritanceClassName != null;
        }

        public ProguardTypeMatcher getInheritanceClassName() {
            return this.inheritanceClassName;
        }

        public void setInheritanceClassName(ProguardTypeMatcher proguardTypeMatcher) {
            this.inheritanceClassName = proguardTypeMatcher;
        }

        public ProguardTypeMatcher getInheritanceAnnotation() {
            return this.inheritanceAnnotation;
        }

        public void setInheritanceAnnotation(ProguardTypeMatcher proguardTypeMatcher) {
            this.inheritanceAnnotation = proguardTypeMatcher;
        }

        public ProguardClassNameList getClassNames() {
            return this.classNames;
        }

        public B setClassNames(ProguardClassNameList proguardClassNameList) {
            this.classNames = proguardClassNameList;
            return this.self();
        }

        public ProguardClassType getClassType() {
            return this.classType;
        }

        public B setClassType(ProguardClassType proguardClassType) {
            this.classType = proguardClassType;
            return this.self();
        }

        public boolean getClassTypeNegated() {
            return this.classTypeNegated;
        }

        public void setClassTypeNegated(boolean bl) {
            this.classTypeNegated = bl;
        }

        public ProguardAccessFlags getClassAccessFlags() {
            return this.classAccessFlags;
        }

        public void setClassAccessFlags(ProguardAccessFlags proguardAccessFlags) {
            this.classAccessFlags = proguardAccessFlags;
        }

        public ProguardAccessFlags getNegatedClassAccessFlags() {
            return this.negatedClassAccessFlags;
        }

        public void setNegatedClassAccessFlags(ProguardAccessFlags proguardAccessFlags) {
            this.negatedClassAccessFlags = proguardAccessFlags;
        }

        public ProguardTypeMatcher getClassAnnotation() {
            return this.classAnnotation;
        }

        public void setClassAnnotation(ProguardTypeMatcher proguardTypeMatcher) {
            this.classAnnotation = proguardTypeMatcher;
        }

        protected void matchAllSpecification() {
            Builder builder = this;
            builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.defaultAllMatcher()));
            builder.setMemberRules(W.a(ProguardMemberRule.defaultKeepAllRule()));
        }
    }
}

