/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.e;
import com.android.tools.r8.graph.S;
import com.android.tools.r8.graph.T;
import com.android.tools.r8.graph.U;
import com.android.tools.r8.graph.W;
import com.android.tools.r8.graph.Z;
import com.android.tools.r8.graph.f;
import com.android.tools.r8.p.a.a.b.B;
import com.android.tools.r8.p.a.a.b.v;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardNameMatcher;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.P0;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ProguardMemberRule {
    private final ProguardTypeMatcher annotation;
    private final ProguardAccessFlags accessFlags;
    private final ProguardAccessFlags negatedAccessFlags;
    private final ProguardMemberType ruleType;
    private final ProguardTypeMatcher type;
    private final ProguardNameMatcher name;
    private final List<ProguardTypeMatcher> arguments;
    private final ProguardMemberRuleReturnValue returnValue;

    private ProguardMemberRule(ProguardTypeMatcher list, ProguardAccessFlags proguardAccessFlags, ProguardAccessFlags proguardAccessFlags2, ProguardMemberType proguardMemberType, ProguardTypeMatcher proguardTypeMatcher, ProguardNameMatcher proguardNameMatcher, List<ProguardTypeMatcher> list2, ProguardMemberRuleReturnValue proguardMemberRuleReturnValue) {
        this.annotation = list;
        this.accessFlags = proguardAccessFlags;
        this.negatedAccessFlags = proguardAccessFlags2;
        this.ruleType = proguardMemberType;
        this.type = proguardTypeMatcher;
        this.name = proguardNameMatcher;
        list = list2 != null ? Collections.unmodifiableList(list2) : null;
        ProguardMemberRule proguardMemberRule = this;
        proguardMemberRule.arguments = list;
        proguardMemberRule.returnValue = proguardMemberRuleReturnValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProguardMemberRule defaultKeepAllRule() {
        Builder builder = new Builder();
        builder.setRuleType(ProguardMemberType.ALL);
        return builder.build();
    }

    private static /* synthetic */ ProguardTypeMatcher a(W w4, ProguardTypeMatcher proguardTypeMatcher) {
        return proguardTypeMatcher.materialize(w4);
    }

    public ProguardTypeMatcher getAnnotation() {
        return this.annotation;
    }

    public ProguardAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public ProguardAccessFlags getNegatedAccessFlags() {
        return this.negatedAccessFlags;
    }

    public ProguardMemberType getRuleType() {
        return this.ruleType;
    }

    public ProguardTypeMatcher getType() {
        return this.type;
    }

    public ProguardNameMatcher getName() {
        return this.name;
    }

    public List<ProguardTypeMatcher> getArguments() {
        return this.arguments;
    }

    public boolean hasReturnValue() {
        return this.returnValue != null;
    }

    public ProguardMemberRuleReturnValue getReturnValue() {
        return this.returnValue;
    }

    public ProguardTypeMatcher getTypeMatcher() {
        return this.type;
    }

    public boolean matches(S s4, f<?> f4, DexStringCache object) {
        U u4 = f4.g().getOriginalFieldSignature(s4.a);
        int n4 = this.getRuleType().ordinal();
        if (n4 != 0) {
            if ((n4 == 1 || n4 == 2) && this.getAccessFlags().containsAll(s4.b) && this.getNegatedAccessFlags().containsNone(s4.b)) {
                return RootSetBuilder.containsAnnotation(this.annotation, s4);
            }
        } else {
            object = ((DexStringCache)object).lookupString(u4.e);
            if (this.getName().matches((String)object) && this.getAccessFlags().containsAll(s4.b) && this.getNegatedAccessFlags().containsNone(s4.b) && this.getType().matches(u4.d, f4) && RootSetBuilder.containsAnnotation(this.annotation, s4)) {
                return true;
            }
        }
        return false;
    }

    public boolean matches(T f0Array, f<?> f4, DexStringCache object) {
        Z z4 = f4.g().getOriginalMethodSignature(f0Array.a);
        switch (((ProguardMemberRule)this).getRuleType().ordinal()) {
            default: {
                break;
            }
            case 7: {
                if (!((ProguardMemberRule)this).type.matches(z4.d.d, f4)) break;
            }
            case 4: 
            case 5: 
            case 6: {
                object = ((DexStringCache)object).lookupString(z4.e);
                if (!((ProguardMemberRule)this).getName().matches((String)object) || !((ProguardMemberRule)this).getAccessFlags().containsAll(f0Array.b) || !((ProguardMemberRule)this).getNegatedAccessFlags().containsNone(f0Array.b) || !RootSetBuilder.containsAnnotation(((ProguardMemberRule)this).annotation, (T)f0Array)) break;
                if ((this = ((ProguardMemberRule)this).getArguments()).size() == 1 && ((ProguardTypeMatcher)this.get(0)).isTripleDotPattern()) {
                    return true;
                }
                f0Array = z4.d.e.a;
                if (z4.d.e.a.length != this.size()) break;
                for (int i4 = 0; i4 < f0Array.length; ++i4) {
                    if (((ProguardTypeMatcher)this.get(i4)).matches(f0Array[i4], f4)) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                if (f0Array.y()) break;
            }
            case 2: {
                if (!((ProguardMemberRule)this).getAccessFlags().containsAll(f0Array.b) || !((ProguardMemberRule)this).getNegatedAccessFlags().containsNone(f0Array.b)) break;
                return RootSetBuilder.containsAnnotation(((ProguardMemberRule)this).annotation, (T)f0Array);
            }
        }
        return false;
    }

    public boolean isSpecific() {
        int n4 = this.getRuleType().ordinal();
        if (n4 != 1 && n4 != 2 && n4 != 3) {
            return v.e(this.getWildcards()) == 0;
        }
        return false;
    }

    Iterable<ProguardWildcard> getWildcards() {
        ProguardMemberRule proguardMemberRule = iterable2;
        Iterable<ProguardWildcard> iterable2 = ProguardTypeMatcher.getWildcardsOrEmpty(proguardMemberRule.annotation);
        Iterable<ProguardWildcard> iterable3 = ProguardTypeMatcher.getWildcardsOrEmpty(proguardMemberRule.type);
        Iterable<ProguardWildcard> iterable4 = ProguardNameMatcher.getWildcardsOrEmpty(proguardMemberRule.name);
        Iterable<ProguardTypeMatcher> iterable5 = proguardMemberRule.arguments;
        iterable5 = iterable5 != null ? iterable5.stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator : Collections::emptyIterator;
        return B.a(iterable2, iterable3, iterable4, iterable5);
    }

    ProguardMemberRule materialize(W object) {
        ProguardMemberRule proguardMemberRule;
        ProguardTypeMatcher proguardTypeMatcher = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getAnnotation() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getAnnotation().materialize((W)object);
        ProguardMemberRule proguardMemberRule2 = proguardMemberRuleReturnValue;
        ProguardAccessFlags proguardAccessFlags = proguardMemberRule2.getAccessFlags();
        ProguardAccessFlags proguardAccessFlags2 = proguardMemberRule2.getNegatedAccessFlags();
        ProguardMemberType proguardMemberType = proguardMemberRule2.getRuleType();
        ProguardTypeMatcher proguardTypeMatcher2 = proguardMemberRule2.getType() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getType().materialize((W)object);
        ProguardNameMatcher proguardNameMatcher = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getName() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getName().materialize();
        object = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getArguments() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getArguments().stream().map(arg_0 -> ProguardMemberRule.a((W)object, arg_0)).collect(Collectors.toList());
        ProguardMemberRule proguardMemberRule3 = proguardMemberRule;
        ProguardMemberRuleReturnValue proguardMemberRuleReturnValue = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getReturnValue();
        proguardMemberRule3(proguardTypeMatcher, proguardAccessFlags, proguardAccessFlags2, proguardMemberType, proguardTypeMatcher2, proguardNameMatcher, (List<ProguardTypeMatcher>)object, proguardMemberRuleReturnValue);
        return proguardMemberRule3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProguardMemberRule)) {
            return false;
        }
        object = (ProguardMemberRule)object;
        Object object2 = ((ProguardMemberRule)((Object)list)).annotation;
        if (object2 != null ? !((ProguardTypeMatcher)object2).equals(((ProguardMemberRule)object).annotation) : ((ProguardMemberRule)object).annotation != null) {
            return false;
        }
        if (!((ProguardMemberRule)((Object)list)).accessFlags.equals(((ProguardMemberRule)object).accessFlags)) {
            return false;
        }
        if (!((ProguardMemberRule)((Object)list)).negatedAccessFlags.equals(((ProguardMemberRule)object).negatedAccessFlags)) {
            return false;
        }
        if (((ProguardMemberRule)((Object)list)).ruleType != ((ProguardMemberRule)object).ruleType) {
            return false;
        }
        object2 = ((ProguardMemberRule)((Object)list)).name;
        if (object2 != null ? !object2.equals(((ProguardMemberRule)object).name) : ((ProguardMemberRule)object).name != null) {
            return false;
        }
        object2 = ((ProguardMemberRule)((Object)list)).type;
        if (object2 != null ? !((ProguardTypeMatcher)object2).equals(((ProguardMemberRule)object).type) : ((ProguardMemberRule)object).type != null) {
            return false;
        }
        List<ProguardTypeMatcher> list = ((ProguardMemberRule)((Object)list)).arguments;
        return list != null ? list.equals(((ProguardMemberRule)object).arguments) : ((ProguardMemberRule)object).arguments == null;
    }

    public int hashCode() {
        ProguardTypeMatcher proguardTypeMatcher = this.annotation;
        int n4 = (((proguardTypeMatcher != null ? proguardTypeMatcher.hashCode() : 0) * 31 + this.accessFlags.hashCode()) * 31 + this.negatedAccessFlags.hashCode()) * 31;
        ProguardMemberType proguardMemberType = this.ruleType;
        int n5 = proguardMemberType != null ? proguardMemberType.hashCode() : 0;
        n4 = (n4 + n5) * 31;
        ProguardTypeMatcher proguardTypeMatcher2 = this.type;
        int n6 = proguardTypeMatcher2 != null ? proguardTypeMatcher2.hashCode() : 0;
        n4 = (n4 + n6) * 31;
        ProguardNameMatcher proguardNameMatcher = this.name;
        int n7 = proguardNameMatcher != null ? proguardNameMatcher.hashCode() : 0;
        int n8 = (n4 + n7) * 31;
        List<ProguardTypeMatcher> list = this.arguments;
        int n9 = list != null ? list.hashCode() : 0;
        return n8 + n9;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        ProguardKeepRule.appendNonEmpty(stringBuilder2, "@", this.annotation, " ");
        ProguardKeepRule.appendNonEmpty(stringBuilder2, null, this.accessFlags, " ");
        ProguardKeepRule.appendNonEmpty(stringBuilder, null, this.negatedAccessFlags.toString().replace(" ", " !"), " ");
        switch (this.getRuleType().ordinal()) {
            default: {
                throw new e("Unknown kind of member rule");
            }
            case 7: {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(this.getType());
                stringBuilder3.append(' ');
            }
            case 4: 
            case 5: 
            case 6: {
                StringBuilder stringBuilder4 = stringBuilder2;
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append(this.getName());
                stringBuilder5.append('(');
                stringBuilder4.append(P0.a(this.getArguments(), ","));
                stringBuilder4.append(')');
                break;
            }
            case 3: {
                stringBuilder2.append("<methods>");
                break;
            }
            case 0: {
                StringBuilder stringBuilder6 = stringBuilder2;
                stringBuilder6.append(this.getType());
                stringBuilder6.append(' ');
                stringBuilder2.append(this.getName());
                break;
            }
            case 1: {
                stringBuilder2.append("<fields>");
                break;
            }
            case 2: {
                stringBuilder2.append("*");
            }
        }
        if (this.hasReturnValue()) {
            stringBuilder2.append(this.returnValue.toString());
        }
        return stringBuilder2.toString();
    }

    public static class Builder {
        static final /* synthetic */ boolean $assertionsDisabled;
        private ProguardTypeMatcher annotation;
        private ProguardAccessFlags accessFlags;
        private ProguardAccessFlags negatedAccessFlags;
        private ProguardMemberType ruleType;
        private ProguardTypeMatcher type;
        private ProguardNameMatcher name;
        private List<ProguardTypeMatcher> arguments;
        private ProguardMemberRuleReturnValue returnValue;

        private Builder() {
            ProguardAccessFlags proguardAccessFlags;
            ProguardAccessFlags proguardAccessFlags2;
            Object object = proguardAccessFlags2;
            proguardAccessFlags2 = new ProguardAccessFlags();
            v1.accessFlags = object;
            object = proguardAccessFlags;
            proguardAccessFlags = new ProguardAccessFlags();
            v1.negatedAccessFlags = object;
        }

        static {
            $assertionsDisabled = ProguardMemberRule.class.desiredAssertionStatus() ^ true;
        }

        public void setAnnotation(ProguardTypeMatcher proguardTypeMatcher) {
            this.annotation = proguardTypeMatcher;
        }

        public ProguardAccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public Builder setAccessFlags(ProguardAccessFlags proguardAccessFlags) {
            this.accessFlags = proguardAccessFlags;
            return this;
        }

        public ProguardAccessFlags getNegatedAccessFlags() {
            return this.negatedAccessFlags;
        }

        public void setNegatedAccessFlags(ProguardAccessFlags proguardAccessFlags) {
            this.negatedAccessFlags = proguardAccessFlags;
        }

        public Builder setRuleType(ProguardMemberType proguardMemberType) {
            this.ruleType = proguardMemberType;
            return this;
        }

        public ProguardTypeMatcher getTypeMatcher() {
            return this.type;
        }

        public Builder setTypeMatcher(ProguardTypeMatcher proguardTypeMatcher) {
            this.type = proguardTypeMatcher;
            return this;
        }

        public Builder setName(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards) {
            this.name = ProguardNameMatcher.create(identifierPatternWithWildcards);
            return this;
        }

        public void setArguments(List<ProguardTypeMatcher> list) {
            this.arguments = list;
        }

        public Builder setReturnValue(ProguardMemberRuleReturnValue proguardMemberRuleReturnValue) {
            this.returnValue = proguardMemberRuleReturnValue;
            return this;
        }

        public boolean isValid() {
            return this.ruleType != null;
        }

        public ProguardMemberRule build() {
            if (!$assertionsDisabled && !((Builder)((Object)proguardTypeMatcher)).isValid()) {
                throw new AssertionError();
            }
            Builder builder = proguardTypeMatcher;
            ProguardTypeMatcher proguardTypeMatcher = builder.annotation;
            ProguardAccessFlags proguardAccessFlags = builder.accessFlags;
            ProguardAccessFlags proguardAccessFlags2 = builder.negatedAccessFlags;
            ProguardMemberType proguardMemberType = builder.ruleType;
            ProguardTypeMatcher proguardTypeMatcher2 = builder.type;
            ProguardNameMatcher proguardNameMatcher = builder.name;
            List<ProguardTypeMatcher> list = builder.arguments;
            ProguardMemberRuleReturnValue proguardMemberRuleReturnValue = builder.returnValue;
            return new ProguardMemberRule(proguardTypeMatcher, proguardAccessFlags, proguardAccessFlags2, proguardMemberType, proguardTypeMatcher2, proguardNameMatcher, list, proguardMemberRuleReturnValue);
        }
    }
}

