/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassBucketGroup;
import com.android.builder.dexing.ClassBucketGroupKt;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.JarBucketGroup;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/android/builder/dexing/ClassBucket;", "Ljava/io/Serializable;", "bucketGroup", "Lcom/android/builder/dexing/ClassBucketGroup;", "bucketNumber", "", "(Lcom/android/builder/dexing/ClassBucketGroup;I)V", "getBucketGroup", "()Lcom/android/builder/dexing/ClassBucketGroup;", "getBucketNumber", "()I", "getClassFiles", "Ljava/util/stream/Stream;", "Lcom/android/builder/dexing/ClassFileEntry;", "filter", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "closer", "Lcom/google/common/io/Closer;", "isMemberOfBucket", "rootPath", "relativePath", "Companion", "builder"})
public final class ClassBucket
implements Serializable {
    @NotNull
    private final ClassBucketGroup bucketGroup;
    private final int bucketNumber;
    private static final long serialVersionUID = 1L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Stream<ClassFileEntry> getClassFiles(@NotNull Function2<? super File, ? super String, Boolean> filter, @NotNull Closer closer) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        Stream<ClassFileEntry> classFiles = Stream.empty();
        for (File root : this.bucketGroup.getRoots()) {
            ClassFileInput classFileInput;
            Intrinsics.checkExpressionValueIsNotNull((Object)ClassFileInputs.fromPath(root.toPath()), (String)"ClassFileInputs.fromPath(root.toPath())");
            closer.register((Closeable)classFileInput);
            classFiles = Stream.concat(classFiles, classFileInput.entries(new BiPredicate<Path, String>(this, filter){
                final /* synthetic */ ClassBucket this$0;
                final /* synthetic */ Function2 $filter;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(Path rootPath, String relativePath) {
                    File file = rootPath.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootPath.toFile()");
                    String string = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativePath");
                    if (!ClassBucket.access$isMemberOfBucket(this.this$0, file, string)) return false;
                    File file2 = rootPath.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootPath.toFile()");
                    if ((Boolean)this.$filter.invoke((Object)file2, (Object)relativePath) == false) return false;
                    return true;
                }
                {
                    this.this$0 = classBucket;
                    this.$filter = function2;
                }
            }));
        }
        Stream<ClassFileEntry> stream = classFiles;
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"classFiles");
        return stream;
    }

    private final boolean isMemberOfBucket(File rootPath, String relativePath) {
        boolean bl;
        int n4 = CollectionsKt.toSet((Iterable)this.bucketGroup.getRoots()).contains(rootPath);
        int n5 = 0;
        boolean bl2 = false;
        if (n4 == 0) {
            boolean bl3 = false;
            String string = "Unexpected rootPath: " + rootPath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n4 = !new File(relativePath).isAbsolute() ? 1 : 0;
        n5 = 0;
        bl2 = false;
        if (n4 == 0) {
            boolean bl4 = false;
            String string = "Unexpected absolute path: " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n4 = ((Boolean)ClassBucketGroupKt.isClassFile().invoke((Object)relativePath)).booleanValue();
        n5 = 0;
        bl2 = false;
        if (n4 == 0) {
            boolean bl5 = false;
            String string = "Unexpected non-class file: " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.bucketGroup instanceof JarBucketGroup) {
            n4 = relativePath.hashCode();
            n5 = 0;
            bl = Math.abs(n4) % this.bucketGroup.getNumOfBuckets() == this.bucketNumber;
        } else {
            String string = new File(relativePath).getParent();
            if (string == null) {
                string = "";
            }
            String packagePath = string;
            n5 = packagePath.hashCode();
            bl2 = false;
            bl = Math.abs(n5) % this.bucketGroup.getNumOfBuckets() == this.bucketNumber;
        }
        return bl;
    }

    @NotNull
    public final ClassBucketGroup getBucketGroup() {
        return this.bucketGroup;
    }

    public final int getBucketNumber() {
        return this.bucketNumber;
    }

    public ClassBucket(@NotNull ClassBucketGroup bucketGroup, int bucketNumber) {
        Intrinsics.checkParameterIsNotNull((Object)bucketGroup, (String)"bucketGroup");
        this.bucketGroup = bucketGroup;
        this.bucketNumber = bucketNumber;
    }

    public static final /* synthetic */ boolean access$isMemberOfBucket(ClassBucket $this, File rootPath, String relativePath) {
        return $this.isMemberOfBucket(rootPath, relativePath);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/builder/dexing/ClassBucket$Companion;", "", "()V", "serialVersionUID", "", "builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

