/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.files.RelativeFile;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LazyIncrementalFileMergerInput
implements IncrementalFileMergerInput {
    private final String name;
    @VisibleForTesting
    final CachedSupplier<Map<RelativeFile, FileStatus>> updates;
    @VisibleForTesting
    final CachedSupplier<ImmutableMap<String, RelativeFile>> updatePaths;
    @VisibleForTesting
    final CachedSupplier<ImmutableMap<String, RelativeFile>> filePaths;
    @VisibleForTesting
    final CachedSupplier<ImmutableSet<File>> zips;
    Map<File, ZFile> openZips;

    public LazyIncrementalFileMergerInput(String name, CachedSupplier<Map<RelativeFile, FileStatus>> updates, CachedSupplier<Set<RelativeFile>> files) {
        this.name = name;
        this.updates = updates;
        this.updatePaths = new CachedSupplier(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (Map.Entry e4 : ((Map)updates.get()).entrySet()) {
                pathsBuilder.put((Object)((RelativeFile)e4.getKey()).getRelativePath(), e4.getKey());
            }
            return pathsBuilder.build();
        });
        this.filePaths = new CachedSupplier(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (RelativeFile rf : (Set)files.get()) {
                pathsBuilder.put((Object)rf.getRelativePath(), (Object)rf);
            }
            return pathsBuilder.build();
        });
        this.zips = new CachedSupplier(() -> {
            HashSet<File> zips = new HashSet<File>();
            for (RelativeFile rf : (Set)files.get()) {
                if (rf.getType() != RelativeFile.Type.JAR || !rf.getBase().isFile()) continue;
                zips.add(rf.getBase());
            }
            return ImmutableSet.copyOf(zips);
        });
        this.openZips = null;
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return ((ImmutableMap)this.updatePaths.get()).keySet();
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return ((ImmutableMap)this.filePaths.get()).keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileStatus getFileStatus(String path) {
        RelativeFile rf = (RelativeFile)((ImmutableMap)this.updatePaths.get()).get((Object)path);
        if (rf == null) {
            return null;
        }
        return (FileStatus)((Map)this.updates.get()).get(rf);
    }

    @Override
    public InputStream openPath(String path) {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        RelativeFile rf = (RelativeFile)((ImmutableMap)this.filePaths.get()).get((Object)path);
        Preconditions.checkState((rf != null ? 1 : 0) != 0, (String)"Unknown file: %s", (Object)path);
        if (rf.getType() == RelativeFile.Type.JAR) {
            ZFile zf = this.openZips.get(rf.getBase());
            Preconditions.checkState((zf != null ? 1 : 0) != 0, (String)"Unknown base: %s", (Object)rf.getBase().getName());
            StoredEntry entry = zf.get(path);
            Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Unknown path %s in zip file %s", (Object)path, (Object)zf.getFile().getAbsolutePath());
            try {
                return entry.open();
            }
            catch (IOException e4) {
                throw new UncheckedIOException(e4);
            }
        }
        try {
            return new FileInputStream(rf.getFile());
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    @Override
    public void open() {
        Preconditions.checkState((this.openZips == null ? 1 : 0) != 0, (Object)"input already open");
        HashMap<File, ZFile> open = new HashMap<File, ZFile>();
        UncheckedIOException failure = null;
        for (File f4 : (ImmutableSet)this.zips.get()) {
            try {
                ZFile zf = ZFile.openReadOnly((File)f4);
                open.put(f4, zf);
            }
            catch (IOException e4) {
                failure = new UncheckedIOException(e4);
                break;
            }
        }
        if (failure != null) {
            for (ZFile zf : open.values()) {
                try {
                    zf.close();
                }
                catch (IOException e5) {
                    failure.addSuppressed(e5);
                }
            }
            throw failure;
        }
        this.openZips = open;
    }

    @Override
    public void close() {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        try (Closer closer = Closer.create();){
            for (ZFile zf : this.openZips.values()) {
                closer.register((Closeable)zf);
            }
        }
        catch (IOException e4) {
            throw new UncheckedIOException(e4);
        }
        finally {
            this.openZips = null;
        }
    }
}

