/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DirDexArchive;
import com.android.builder.dexing.NonIncrementalJarDexArchive;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DexArchives {
    private DexArchives() {
    }

    public static DexArchive fromInput(Path path) throws IOException {
        if (ClassFileInputs.jarMatcher.matches(path)) {
            return new NonIncrementalJarDexArchive(path);
        }
        return new DirDexArchive(path);
    }

    static List<DexArchiveEntry> getEntriesFromSingleArchive(Path archivePath) throws IOException {
        try (DexArchive archive = DexArchives.fromInput(archivePath);){
            List<DexArchiveEntry> list = archive.getSortedDexArchiveEntries();
            return list;
        }
    }

    static List<DexArchiveEntry> getAllEntriesFromArchives(Collection<Path> inputs) throws IOException {
        ArrayList entries2 = Lists.newArrayList();
        for (Path p4 : inputs) {
            entries2.addAll(DexArchives.getEntriesFromSingleArchive(p4));
        }
        return entries2;
    }
}

