/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.Z0;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public interface ProgramResource
extends Resource {
    public static ProgramResource fromFile(Kind kind, Path path) {
        return new FileResource(kind, path, null);
    }

    public static ProgramResource fromBytes(Origin origin, Kind kind, byte[] byArray, Set<String> set) {
        return new ByteResource(origin, kind, byArray, set);
    }

    public Kind getKind();

    public InputStream getByteStream() throws ResourceException;

    default public byte[] getBytes() throws ResourceException {
        try {
            return Z0.a(this.getByteStream());
        }
        catch (IOException iOException) {
            throw new ResourceException(this.getOrigin(), (Throwable)iOException);
        }
    }

    public Set<String> getClassDescriptors();

    public static class ByteResource
    implements ProgramResource {
        static final /* synthetic */ boolean a;
        private final Origin b;
        private final Kind c;
        private final byte[] d;
        private final Set<String> e;

        private ByteResource(Origin origin, Kind kind, byte[] byArray, Set<String> set) {
            if (!a && byArray == null) {
                throw new AssertionError();
            }
            ByteResource byteResource = this;
            byteResource.b = origin;
            byteResource.c = kind;
            byteResource.d = byArray;
            byteResource.e = set;
        }

        static {
            a = ProgramResource.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public Origin getOrigin() {
            return this.b;
        }

        @Override
        public Kind getKind() {
            return this.c;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            return new ByteArrayInputStream(this.d);
        }

        @Override
        public byte[] getBytes() throws ResourceException {
            return this.d;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.e;
        }
    }

    public static class FileResource
    implements ProgramResource {
        private final Origin a;
        private final Kind b;
        private final Path c;
        private final Set<String> d;

        private FileResource(Kind kind, Path path, Set<String> set) {
            PathOrigin pathOrigin;
            PathOrigin pathOrigin2 = pathOrigin;
            pathOrigin = new PathOrigin(path);
            v1.a = pathOrigin2;
            v1.b = kind;
            v1.c = path;
            v1.d = set;
        }

        @Override
        public Origin getOrigin() {
            return this.a;
        }

        @Override
        public Kind getKind() {
            return this.b;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return Files.newInputStream(this.c, new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new ResourceException(this.getOrigin(), (Throwable)iOException);
            }
        }

        @Override
        public byte[] getBytes() throws ResourceException {
            try {
                return Files.readAllBytes(this.c);
            }
            catch (IOException iOException) {
                throw new ResourceException(this.getOrigin(), (Throwable)iOException);
            }
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.d;
        }
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind CF;
        public static final /* enum */ Kind DEX;
        private static final /* synthetic */ Kind[] a;

        public static Kind[] values() {
            return (Kind[])a.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }

        static {
            Kind kind;
            Kind kind2;
            Kind kind3 = kind2;
            CF = new Kind();
            Kind kind4 = kind;
            DEX = new Kind();
            a = new Kind[]{kind3, kind4};
        }
    }
}

