/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.apksig.util.RunnablesExecutor;
import com.android.builder.internal.packaging.ApkFlinger;
import com.android.signflinger.SignedApk;
import com.android.signflinger.SignedApkOptions;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.zipflinger.Archive;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.StableArchive;
import com.android.zipflinger.SynchronizedArchive;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipSource;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J6\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001e2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/builder/internal/packaging/ApkFlinger;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "compressionLevel", "", "deterministicEntryOrder", "", "enableV3Signing", "enableV4Signing", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;IZZZ)V", "archive", "Lcom/android/zipflinger/SynchronizedArchive;", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "kotlin.jvm.PlatformType", "noCompressPredicate", "Lcom/google/common/base/Predicate;", "", "pageAlignPredicate", "subTasks", "", "Ljava/util/concurrent/ForkJoinTask;", "", "close", "deleteFile", "apkPath", "hasPendingChangesWithWait", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Lcom/google/common/base/Function;", "isIgnored", "builder"})
public final class ApkFlinger
implements ApkCreator {
    private final int compressionLevel;
    @NotNull
    private final SynchronizedArchive archive;
    @NotNull
    private final Predicate<String> noCompressPredicate;
    @NotNull
    private final Predicate<String> pageAlignPredicate;
    private final ForkJoinPool forkJoinPool;
    @NotNull
    private final List<ForkJoinTask<Unit>> subTasks;

    /*
     * WARNING - void declaration
     */
    public ApkFlinger(@NotNull ApkCreatorFactory.CreationData creationData, int compressionLevel, boolean deterministicEntryOrder, boolean enableV3Signing, boolean enableV4Signing) {
        Archive archive;
        Object object;
        Intrinsics.checkNotNullParameter((Object)creationData, (String)"creationData");
        this.compressionLevel = compressionLevel;
        this.forkJoinPool = ForkJoinPool.commonPool();
        boolean bl2 = false;
        this.subTasks = new ArrayList();
        NativeLibrariesPackagingMode nativeLibrariesPackagingMode = creationData.getNativeLibrariesPackagingMode();
        int n12 = nativeLibrariesPackagingMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nativeLibrariesPackagingMode.ordinal()];
        switch (n12) {
            case 1: {
                object = creationData.getNoCompressPredicate();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"creationData.noCompressPredicate");
                this.noCompressPredicate = object;
                this.pageAlignPredicate = 1.INSTANCE;
                break;
            }
            case 2: {
                Predicate baseNoCompressPredicate = creationData.getNoCompressPredicate();
                this.noCompressPredicate = (Predicate)new Predicate<String>((Predicate<String>)baseNoCompressPredicate){
                    final /* synthetic */ Predicate<String> $baseNoCompressPredicate;
                    {
                        this.$baseNoCompressPredicate = $baseNoCompressPredicate;
                    }

                    public final boolean apply(@Nullable String name) {
                        boolean bl2;
                        String string;
                        return this.$baseNoCompressPredicate.apply((Object)name) || ((string = name) == null ? false : (bl2 = StringsKt.endsWith$default((String)string, (String)".so", (boolean)false, (int)2, null)));
                    }
                };
                this.pageAlignPredicate = 3.INSTANCE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        SigningOptions signingOptions = (SigningOptions)creationData.getSigningOptions().orNull();
        if (signingOptions == null) {
            archive = (Archive)new ZipArchive(creationData.getApkPath().toPath(), Zip64.Policy.FORBID);
        } else {
            void builder;
            object = new SignedApkOptions.Builder().setCertificates((List)signingOptions.getCertificates()).setMinSdkVersion(signingOptions.getMinSdkVersion()).setPrivateKey(signingOptions.getKey()).setSdkDependencies(signingOptions.getSdkDependencyData()).setV1Enabled(signingOptions.isV1SigningEnabled()).setV2Enabled(signingOptions.isV2SigningEnabled()).setV3Enabled(enableV3Signing).setV4Enabled(enableV4Signing).setV1CreatedBy((object = creationData.getCreatedBy()) == null ? "Generated-by-ADT" : object).setV1TrustManifest(creationData.isIncremental());
            boolean bl3 = false;
            boolean bl4 = false;
            Object object2 = object;
            File file = creationData.getApkPath();
            boolean bl5 = false;
            RunnablesExecutor runnablesExecutor = signingOptions.getExecutor();
            if (runnablesExecutor != null) {
                RunnablesExecutor runnablesExecutor2 = runnablesExecutor;
                boolean bl6 = false;
                boolean bl7 = false;
                RunnablesExecutor it2 = runnablesExecutor2;
                boolean bl8 = false;
                builder.setExecutor(it2);
            }
            if (enableV4Signing) {
                builder.setV4Output(new File(Intrinsics.stringPlus((String)creationData.getApkPath().getAbsolutePath(), (Object)".idsig")));
            }
            Unit unit = Unit.INSTANCE;
            SignedApkOptions signedApkOptions = object.build();
            File file2 = file;
            archive = (Archive)new SignedApk(file2, signedApkOptions);
        }
        Archive innerArchive = archive;
        this.archive = new SynchronizedArchive(deterministicEntryOrder ? (Archive)new StableArchive(innerArchive) : innerArchive);
    }

    public /* synthetic */ ApkFlinger(ApkCreatorFactory.CreationData creationData, int n12, boolean bl2, boolean bl3, boolean bl4, int n13, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n13 & 4) != 0) {
            bl2 = true;
        }
        if ((n13 & 8) != 0) {
            bl3 = false;
        }
        if ((n13 & 0x10) != 0) {
            bl4 = false;
        }
        this(creationData, n12, bl2, bl3, bl4);
    }

    public void writeZip(@NotNull File zip, @Nullable Function<String, String> transform, @Nullable Predicate<String> isIgnored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile()", (Object[])new Object[0]);
        Predicate predicate = isIgnored;
        Predicate ignorePredicate2 = predicate == null ? (Predicate)writeZip.ignorePredicate.1.INSTANCE : predicate;
        ZipSource zipSource = new ZipSource(zip.toPath());
        Collection entries2 = zipSource.entries().values();
        for (Entry entry : entries2) {
            if (entry.isDirectory() || ignorePredicate2.apply((Object)entry.getName())) continue;
            Function<String, String> function = transform;
            String string = function == null ? null : (String)function.apply((Object)entry.getName());
            String name = string == null ? entry.getName() : string;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (StringsKt.contains$default((CharSequence)name, (CharSequence)"../", (boolean)false, (int)2, null)) {
                throw new InvalidPathException(name, "Entry name contains invalid characters");
            }
            long alignment = !entry.isCompressed() && this.pageAlignPredicate.apply((Object)name) ? 4096L : (!entry.isCompressed() ? 4L : 0L);
            zipSource.select(entry.getName(), name, -2, alignment);
        }
        this.archive.add(zipSource);
    }

    public void writeFile(@NotNull File inputFile, @NotNull String apkPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        Future future = this.forkJoinPool.submit(new Callable<Unit>(this, apkPath, inputFile){
            final /* synthetic */ ApkFlinger this$0;
            final /* synthetic */ String $apkPath;
            final /* synthetic */ File $inputFile;
            {
                this.this$0 = $receiver;
                this.$apkPath = $apkPath;
                this.$inputFile = $inputFile;
            }

            public final void call() {
                boolean mayCompress = !ApkFlinger.access$getNoCompressPredicate$p(this.this$0).apply((Object)this.$apkPath);
                Source source = Sources.from((File)this.$inputFile, (String)this.$apkPath, (int)(mayCompress ? ApkFlinger.access$getCompressionLevel$p(this.this$0) : 0));
                if (!mayCompress) {
                    if (ApkFlinger.access$getPageAlignPredicate$p(this.this$0).apply((Object)this.$apkPath)) {
                        source.align(4096L);
                    } else {
                        source.align(4L);
                    }
                }
                ApkFlinger.access$getArchive$p(this.this$0).add(source);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"@Throws(IOException::class)\n    override fun writeFile(inputFile: File, apkPath: String) {\n        subTasks.add(\n            forkJoinPool.submit(\n                Callable<Unit> {\n                    val mayCompress = !noCompressPredicate.apply(apkPath)\n                    val source = Sources.from(inputFile, apkPath, if (mayCompress) compressionLevel else Deflater.NO_COMPRESSION)\n                    if (!mayCompress) {\n                        if (pageAlignPredicate.apply(apkPath)) {\n                            source.align(PAGE_ALIGNMENT)\n                        } else {\n                            // by default all uncompressed entries are aligned at 4 byte boundaries.\n                            source.align(DEFAULT_ALIGNMENT)\n                        }\n                    }\n                    archive.add(source)\n                }\n            )\n        )\n    }");
        this.subTasks.add((ForkJoinTask<Unit>)future);
    }

    public void deleteFile(@NotNull String apkPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        this.archive.delete(apkPath);
    }

    public boolean hasPendingChangesWithWait() throws IOException {
        throw new RuntimeException("not implemented");
    }

    public void close() throws IOException {
        Iterable $this$forEach$iv = this.subTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForkJoinTask it2 = (ForkJoinTask)element$iv;
            boolean bl2 = false;
            it2.join();
        }
        this.archive.close();
    }

    public static final /* synthetic */ Predicate access$getNoCompressPredicate$p(ApkFlinger $this) {
        return $this.noCompressPredicate;
    }

    public static final /* synthetic */ int access$getCompressionLevel$p(ApkFlinger $this) {
        return $this.compressionLevel;
    }

    public static final /* synthetic */ Predicate access$getPageAlignPredicate$p(ApkFlinger $this) {
        return $this.pageAlignPredicate;
    }

    public static final /* synthetic */ SynchronizedArchive access$getArchive$p(ApkFlinger $this) {
        return $this.archive;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeLibrariesPackagingMode.values().length];
            nArray[NativeLibrariesPackagingMode.COMPRESSED.ordinal()] = 1;
            nArray[NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

