/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.assistant.runtime;

import com.android.tools.r8.assistant.runtime.ReflectiveOperationLogger;
import com.android.tools.r8.assistant.runtime.ReflectiveOperationReceiver;
import com.android.tools.r8.keepanno.annotations.KeepForApi;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;

@KeepForApi
public class ReflectiveOracle {
    private static Object instanceLock = new Object();
    private static volatile ReflectiveOperationReceiver INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReflectiveOperationReceiver getInstance() {
        if (INSTANCE == null) {
            Object object = instanceLock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = ReflectiveOracle.getReceiver();
                }
            }
        }
        return INSTANCE;
    }

    private static ReflectiveOperationReceiver getReceiver() {
        return new ReflectiveOperationLogger();
    }

    public static void onClassNewInstance(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassNewInstance(Stack.createStack(), clazz);
    }

    public static void onClassForName(String className) {
        ReflectiveOracle.getInstance().onClassForName(Stack.createStack(), className, true, null);
    }

    public static void onClassForName(String className, boolean initialize, ClassLoader classLoader) {
        ReflectiveOracle.getInstance().onClassForName(Stack.createStack(), className, initialize, classLoader);
    }

    public static void onClassGetDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        ReflectiveOracle.getInstance().onClassGetDeclaredMethod(Stack.createStack(), clazz, name, parameters);
    }

    public static void onClassGetDeclaredMethods(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetDeclaredMethods(Stack.createStack(), clazz);
    }

    public static void onClassGetDeclaredField(Class<?> clazz, String fieldName) {
        ReflectiveOracle.getInstance().onClassGetDeclaredField(Stack.createStack(), clazz, fieldName);
    }

    public static void onClassGetDeclaredFields(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetDeclaredFields(Stack.createStack(), clazz);
    }

    public static void onClassGetDeclaredConstructor(Class<?> clazz, Class<?> ... parameters) {
        ReflectiveOracle.getInstance().onClassGetDeclaredConstructor(Stack.createStack(), clazz, parameters);
    }

    public static void onClassGetDeclaredConstructors(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetDeclaredConstructors(Stack.createStack(), clazz);
    }

    public static void onClassGetMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        ReflectiveOracle.getInstance().onClassGetMethod(Stack.createStack(), clazz, name, parameterTypes);
    }

    public static void onClassGetMethods(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetMethods(Stack.createStack(), clazz);
    }

    public static void onClassGetField(Class<?> clazz, String name) {
        ReflectiveOracle.getInstance().onClassGetField(Stack.createStack(), clazz, name);
    }

    public static void onClassGetFields(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetFields(Stack.createStack(), clazz);
    }

    public static void onClassGetConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        ReflectiveOracle.getInstance().onClassGetConstructor(Stack.createStack(), clazz, parameterTypes);
    }

    public static void onClassGetConstructors(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetConstructors(Stack.createStack(), clazz);
    }

    public static void onClassGetName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.NAME);
    }

    public static void onClassGetSimpleName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.SIMPLE_NAME);
    }

    public static void onClassGetCanonicalName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.CANONICAL_NAME);
    }

    public static void onClassGetTypeName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.TYPE_NAME);
    }

    public static void onClassGetSuperclass(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetSuperclass(Stack.createStack(), clazz);
    }

    public static void onClassAsSubclass(Class<?> holder, Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassAsSubclass(Stack.createStack(), holder, clazz);
    }

    public static void onClassIsInstance(Class<?> holder, Object object) {
        ReflectiveOracle.getInstance().onClassIsInstance(Stack.createStack(), holder, object);
    }

    public static void onClassCast(Class<?> holder, Object object) {
        ReflectiveOracle.getInstance().onClassCast(Stack.createStack(), holder, object);
    }

    public static void onClassGetComponentType(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetComponentType(Stack.createStack(), clazz);
    }

    public static void onClassGetPackage(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetPackage(Stack.createStack(), clazz);
    }

    public static void onClassIsAssignableFrom(Class<?> clazz, Class<?> sup) {
        ReflectiveOracle.getInstance().onClassIsAssignableFrom(Stack.createStack(), clazz, sup);
    }

    public static void onClassIsAnnotation(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.ANNOTATION);
    }

    public static void onClassIsAnonymousClass(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.ANONYMOUS_CLASS);
    }

    public static void onClassIsArray(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.ARRAY);
    }

    public static void onClassIsEnum(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.ENUM);
    }

    public static void onClassIsHidden(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.HIDDEN);
    }

    public static void onClassIsInterface(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.INTERFACE);
    }

    public static void onClassIsLocalClass(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.LOCAL_CLASS);
    }

    public static void onClassIsMemberClass(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.MEMBER_CLASS);
    }

    public static void onClassIsPrimitive(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.PRIMITIVE);
    }

    public static void onClassIsRecord(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.RECORD);
    }

    public static void onClassIsSealed(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.SEALED);
    }

    public static void onClassIsSynthetic(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassFlag(Stack.createStack(), clazz, ReflectiveOperationReceiver.ClassFlag.SYNTHETIC);
    }

    public static void onAtomicIntegerFieldUpdaterNewUpdater(Class<?> clazz, String name) {
        ReflectiveOracle.getInstance().onAtomicIntegerFieldUpdaterNewUpdater(Stack.createStack(), clazz, name);
    }

    public static void onAtomicLongFieldUpdaterNewUpdater(Class<?> clazz, String name) {
        ReflectiveOracle.getInstance().onAtomicLongFieldUpdaterNewUpdater(Stack.createStack(), clazz, name);
    }

    public static void onAtomicReferenceFieldUpdaterNewUpdater(Class<?> clazz, Class<?> fieldClass, String name) {
        ReflectiveOracle.getInstance().onAtomicReferenceFieldUpdaterNewUpdater(Stack.createStack(), clazz, fieldClass, name);
    }

    public static void onServiceLoaderLoad(Class<?> clazz) {
        ReflectiveOracle.getInstance().onServiceLoaderLoad(Stack.createStack(), clazz, null);
    }

    public static void onServiceLoaderLoadWithClassLoader(Class<?> clazz, ClassLoader classLoader) {
        ReflectiveOracle.getInstance().onServiceLoaderLoad(Stack.createStack(), clazz, classLoader);
    }

    public static void onServiceLoaderLoadInstalled(Class<?> clazz) {
        ReflectiveOracle.getInstance().onServiceLoaderLoad(Stack.createStack(), clazz, ClassLoader.getSystemClassLoader());
    }

    public static void onProxyNewProxyInstance(ClassLoader classLoader, Class<?>[] interfaces, InvocationHandler invocationHandler) {
        ReflectiveOracle.getInstance().onProxyNewProxyInstance(Stack.createStack(), classLoader, interfaces, invocationHandler);
    }

    @KeepForApi
    public static class Stack {
        private final StackTraceElement[] stackTraceElements;

        private Stack(StackTraceElement[] stackTraceElements) {
            this.stackTraceElements = stackTraceElements;
        }

        static Stack createStack() {
            assert (INSTANCE != null);
            if (INSTANCE.requiresStackInformation()) {
                StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
                return new Stack(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
            }
            return new Stack(null);
        }

        public StackTraceElement[] getStackTraceElements() {
            return this.stackTraceElements;
        }

        public String toStringStackTrace() {
            if (this.stackTraceElements == null) {
                return "Stack extraction not enabled.";
            }
            StringBuilder sb5 = new StringBuilder();
            for (StackTraceElement element : this.stackTraceElements) {
                sb5.append(" at ").append(element).append("\n");
            }
            return sb5.toString();
        }
    }
}

