/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.apksig.util.RunnablesExecutor;
import com.android.builder.internal.packaging.ApkFlinger;
import com.android.signflinger.SignedApk;
import com.android.signflinger.SignedApkOptions;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.zipflinger.Archive;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.StableArchive;
import com.android.zipflinger.SynchronizedArchive;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipSource;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J6\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001e2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/builder/internal/packaging/ApkFlinger;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "compressionLevel", "", "deterministicEntryOrder", "", "enableV3Signing", "enableV4Signing", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;IZZZ)V", "archive", "Lcom/android/zipflinger/SynchronizedArchive;", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "kotlin.jvm.PlatformType", "noCompressPredicate", "Lcom/google/common/base/Predicate;", "", "pageAlignPredicate", "subTasks", "", "Ljava/util/concurrent/ForkJoinTask;", "", "close", "deleteFile", "apkPath", "hasPendingChangesWithWait", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Lcom/google/common/base/Function;", "isIgnored", "Companion", "builder"})
@SourceDebugExtension(value={"SMAP\nApkFlinger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApkFlinger.kt\ncom/android/builder/internal/packaging/ApkFlinger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n1#2:290\n1855#3,2:291\n*S KotlinDebug\n*F\n+ 1 ApkFlinger.kt\ncom/android/builder/internal/packaging/ApkFlinger\n*L\n244#1:291,2\n*E\n"})
public final class ApkFlinger
implements ApkCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int compressionLevel;
    @NotNull
    private final SynchronizedArchive archive;
    @NotNull
    private final Predicate<String> noCompressPredicate;
    @NotNull
    private final Predicate<String> pageAlignPredicate;
    private final ForkJoinPool forkJoinPool;
    @NotNull
    private final List<ForkJoinTask<Unit>> subTasks;

    /*
     * WARNING - void declaration
     */
    public ApkFlinger(@NotNull ApkCreatorFactory.CreationData creationData, int compressionLevel, boolean deterministicEntryOrder, boolean enableV3Signing, boolean enableV4Signing) {
        Archive archive;
        Intrinsics.checkNotNullParameter((Object)creationData, (String)"creationData");
        this.compressionLevel = compressionLevel;
        this.forkJoinPool = ForkJoinPool.commonPool();
        this.subTasks = new ArrayList();
        NativeLibrariesPackagingMode nativeLibrariesPackagingMode = creationData.getNativeLibrariesPackagingMode();
        switch (nativeLibrariesPackagingMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nativeLibrariesPackagingMode.ordinal()]) {
            case 1: {
                Predicate predicate = creationData.getNoCompressPredicate();
                Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"creationData.noCompressPredicate");
                this.noCompressPredicate = predicate;
                this.pageAlignPredicate = 1.INSTANCE;
                break;
            }
            case 2: {
                Predicate baseNoCompressPredicate = creationData.getNoCompressPredicate();
                this.noCompressPredicate = new Predicate((Predicate<String>)baseNoCompressPredicate){
                    final /* synthetic */ Predicate<String> $baseNoCompressPredicate;
                    {
                        this.$baseNoCompressPredicate = $baseNoCompressPredicate;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(String name) {
                        if (this.$baseNoCompressPredicate.apply((Object)name)) return true;
                        String string = name;
                        if (string == null) return false;
                        boolean bl2 = StringsKt.endsWith$default((String)string, (String)".so", (boolean)false, (int)2, null);
                        if (!bl2) return false;
                        return true;
                    }
                };
                this.pageAlignPredicate = 3.INSTANCE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        SigningOptions signingOptions = (SigningOptions)creationData.getSigningOptions().orNull();
        if (signingOptions == null) {
            archive = (Archive)new ZipArchive(creationData.getApkPath().toPath(), Zip64.Policy.FORBID);
        } else {
            void builder;
            SignedApkOptions.Builder builder2;
            File file = creationData.getApkPath();
            SignedApkOptions.Builder builder3 = new SignedApkOptions.Builder().setCertificates((List)signingOptions.getCertificates()).setMinSdkVersion(signingOptions.getMinSdkVersion()).setPrivateKey(signingOptions.getKey()).setSdkDependencies(signingOptions.getSdkDependencyData()).setV1Enabled(signingOptions.isV1SigningEnabled()).setV2Enabled(signingOptions.isV2SigningEnabled()).setV3Enabled(enableV3Signing).setV4Enabled(enableV4Signing);
            String string = creationData.getCreatedBy();
            if (string == null) {
                string = "Generated-by-ADT";
            }
            SignedApkOptions.Builder builder4 = builder2 = builder3.setV1CreatedBy(string).setV1TrustManifest(creationData.isIncremental());
            File file2 = file;
            boolean bl2 = false;
            RunnablesExecutor runnablesExecutor = signingOptions.getExecutor();
            if (runnablesExecutor != null) {
                RunnablesExecutor it = runnablesExecutor;
                boolean bl3 = false;
                builder.setExecutor(it);
            }
            if (enableV4Signing) {
                builder.setV4Output(new File(creationData.getApkPath().getAbsolutePath() + ".idsig"));
            }
            SignedApkOptions signedApkOptions = builder2.build();
            File file3 = file2;
            archive = (Archive)new SignedApk(file3, signedApkOptions);
        }
        Archive innerArchive = archive;
        this.archive = new SynchronizedArchive(deterministicEntryOrder ? (Archive)new StableArchive(innerArchive) : innerArchive);
    }

    public /* synthetic */ ApkFlinger(ApkCreatorFactory.CreationData creationData, int n11, boolean bl2, boolean bl3, boolean bl4, int n12, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n12 & 4) != 0) {
            bl2 = true;
        }
        if ((n12 & 8) != 0) {
            bl3 = false;
        }
        if ((n12 & 0x10) != 0) {
            bl4 = false;
        }
        this(creationData, n11, bl2, bl3, bl4);
    }

    public void writeZip(@NotNull File zip, @Nullable Function<String, String> transform, @Nullable Predicate<String> isIgnored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile()", (Object[])new Object[0]);
        Predicate predicate = isIgnored;
        if (predicate == null) {
            predicate = writeZip.ignorePredicate.1.INSTANCE;
        }
        Predicate ignorePredicate2 = predicate;
        ZipSource zipSource = new ZipSource(zip.toPath());
        Collection entries2 = zipSource.entries().values();
        for (Entry entry : entries2) {
            if (entry.isDirectory() || ignorePredicate2.apply((Object)entry.getName())) continue;
            Object object = transform;
            if (object == null || (object = (String)object.apply((Object)entry.getName())) == null) {
                object = entry.getName();
            }
            Object newName = object;
            Intrinsics.checkNotNullExpressionValue(newName, (String)"newName");
            if (StringsKt.contains$default((CharSequence)((CharSequence)newName), (CharSequence)"../", (boolean)false, (int)2, null)) {
                throw new InvalidPathException((String)newName, "Entry name contains invalid characters");
            }
            int newCompressionLevel = entry.isCompressed() && this.noCompressPredicate.apply(newName) ? 0 : -2;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            long newAlignment = ApkFlinger.Companion.getNewAlignment(entry, newName, newCompressionLevel, (Predicate<String>)this.pageAlignPredicate);
            zipSource.select(entry.getName(), newName, newCompressionLevel, newAlignment);
        }
        this.archive.add(zipSource);
    }

    public void writeFile(@NotNull File inputFile, @NotNull String apkPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        Future future = this.forkJoinPool.submit(new Callable(this, apkPath, inputFile){
            final /* synthetic */ ApkFlinger this$0;
            final /* synthetic */ String $apkPath;
            final /* synthetic */ File $inputFile;
            {
                this.this$0 = $receiver;
                this.$apkPath = $apkPath;
                this.$inputFile = $inputFile;
            }

            public final void call() {
                boolean mayCompress = !ApkFlinger.access$getNoCompressPredicate$p(this.this$0).apply((Object)this.$apkPath);
                Source source = Sources.from((File)this.$inputFile, (String)this.$apkPath, (int)(mayCompress ? ApkFlinger.access$getCompressionLevel$p(this.this$0) : 0));
                if (!mayCompress) {
                    if (ApkFlinger.access$getPageAlignPredicate$p(this.this$0).apply((Object)this.$apkPath)) {
                        source.align(4096L);
                    } else {
                        source.align(4L);
                    }
                }
                ApkFlinger.access$getArchive$p(this.this$0).add(source);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"@Throws(IOException::cla\u2026        )\n        )\n    }");
        this.subTasks.add((ForkJoinTask<Unit>)future);
    }

    public void deleteFile(@NotNull String apkPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        this.archive.delete(apkPath);
    }

    public boolean hasPendingChangesWithWait() throws IOException {
        throw new RuntimeException("not implemented");
    }

    public void close() throws IOException {
        Iterable $this$forEach$iv = this.subTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForkJoinTask it = (ForkJoinTask)element$iv;
            boolean bl2 = false;
            it.join();
        }
        this.archive.close();
    }

    public static final /* synthetic */ Predicate access$getNoCompressPredicate$p(ApkFlinger $this) {
        return $this.noCompressPredicate;
    }

    public static final /* synthetic */ int access$getCompressionLevel$p(ApkFlinger $this) {
        return $this.compressionLevel;
    }

    public static final /* synthetic */ Predicate access$getPageAlignPredicate$p(ApkFlinger $this) {
        return $this.pageAlignPredicate;
    }

    public static final /* synthetic */ SynchronizedArchive access$getArchive$p(ApkFlinger $this) {
        return $this.archive;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/builder/internal/packaging/ApkFlinger$Companion;", "", "()V", "getNewAlignment", "", "entry", "Lcom/android/zipflinger/Entry;", "newName", "", "newCompressionLevel", "", "pageAlignPredicate", "Lcom/google/common/base/Predicate;", "builder"})
    public static final class Companion {
        private Companion() {
        }

        private final long getNewAlignment(Entry entry, String newName, int newCompressionLevel, Predicate<String> pageAlignPredicate) {
            boolean isNewEntryCompressed;
            switch (newCompressionLevel) {
                case -2: {
                    boolean bl2 = entry.isCompressed();
                    break;
                }
                case 0: {
                    boolean bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = isNewEntryCompressed = true;
                }
            }
            if (isNewEntryCompressed) {
                return 0L;
            }
            return pageAlignPredicate.apply((Object)newName) ? 4096L : 4L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeLibrariesPackagingMode.values().length];
            try {
                nArray[NativeLibrariesPackagingMode.COMPRESSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

