/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.origin.Origin;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/builder/dexing/InMemoryClassFileResourceProvider;", "Lcom/android/tools/r8/ClassFileResourceProvider;", "classes", "", "", "", "<init>", "(Ljava/util/Map;)V", "origin", "Lcom/android/tools/r8/origin/Origin;", "getClassDescriptors", "", "getProgramResource", "Lcom/android/tools/r8/ProgramResource;", "descriptor", "builder-r8"})
final class InMemoryClassFileResourceProvider
implements ClassFileResourceProvider {
    @NotNull
    private final Map<String, byte[]> classes;
    @NotNull
    private final Origin origin;

    public InMemoryClassFileResourceProvider(@NotNull Map<String, byte[]> classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.classes = classes;
        Origin origin2 = Origin.root();
        this.origin = new Origin(origin2){

            public String part() {
                return "Runtime R class that will be generated by consuming app";
            }
        };
    }

    @Override
    @NotNull
    public Set<String> getClassDescriptors() {
        return this.classes.keySet();
    }

    @Override
    @Nullable
    public ProgramResource getProgramResource(@NotNull String descriptor) {
        ProgramResource programResource;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        byte[] byArray = this.classes.get(descriptor);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl5 = false;
            programResource = ProgramResource.fromBytes(this.origin, ProgramResource.Kind.CF, it, SetsKt.emptySet());
        } else {
            programResource = null;
        }
        return programResource;
    }
}

